/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.fishstiz.packed_packs.PackedPacks;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_3288;
import org.jetbrains.annotations.Nullable;

public record PackEntry(String id, @Nullable Boolean required, @Nullable SerializedPosition fixed) implements Serializable
{
    private static final String ID_SERIALIZED_NAME = "id";
    private static final String REQUIRED_SERIALIZED_NAME = "required";
    private static final String FIXED_SERIALIZED_NAME = "fixed";

    public PackEntry(String id) {
        this(id, null, null);
    }

    static enum SerializedPosition {
        TOP(class_3288.class_3289.field_14280),
        BOTTOM(class_3288.class_3289.field_14281);

        private final class_3288.class_3289 position;

        private SerializedPosition(class_3288.class_3289 position) {
            this.position = position;
        }

        public class_3288.class_3289 pos() {
            return this.position;
        }

        static SerializedPosition get(class_3288.class_3289 position) {
            return switch (position) {
                default -> throw new MatchException(null, null);
                case class_3288.class_3289.field_14280 -> TOP;
                case class_3288.class_3289.field_14281 -> BOTTOM;
            };
        }
    }

    static class Adapter
    implements JsonSerializer<PackEntry>,
    JsonDeserializer<PackEntry> {
        Adapter() {
        }

        public JsonElement serialize(PackEntry src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty(PackEntry.ID_SERIALIZED_NAME, src.id());
            if (src.required() != null) {
                obj.addProperty(PackEntry.REQUIRED_SERIALIZED_NAME, src.required());
            }
            if (src.fixed() != null) {
                obj.addProperty(PackEntry.FIXED_SERIALIZED_NAME, src.fixed().name());
            }
            return obj;
        }

        public PackEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                return new PackEntry(json.getAsString());
            }
            JsonObject obj = json.getAsJsonObject();
            String id = Objects.requireNonNull(obj.get(PackEntry.ID_SERIALIZED_NAME).getAsString(), "'id' in pack entry must not be null");
            Boolean required = obj.has(PackEntry.REQUIRED_SERIALIZED_NAME) ? Boolean.valueOf(obj.get(PackEntry.REQUIRED_SERIALIZED_NAME).getAsBoolean()) : null;
            SerializedPosition fixed = null;
            if (obj.has(PackEntry.FIXED_SERIALIZED_NAME)) {
                String position = obj.get(PackEntry.FIXED_SERIALIZED_NAME).getAsString();
                try {
                    fixed = SerializedPosition.valueOf(position.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    PackedPacks.LOGGER.error("[packed_packs] Invalid value for key 'fixed': '{}' in {}. Expected one of {}", new Object[]{position, id, SerializedPosition.values()});
                }
            }
            return new PackEntry(id, required, fixed);
        }
    }

    static class MapAdapter
    implements JsonSerializer<PackMap>,
    JsonDeserializer<PackMap> {
        MapAdapter() {
        }

        public JsonElement serialize(PackMap src, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray arr = new JsonArray();
            for (PackEntry entry : src.values()) {
                if (entry.required() == null && entry.fixed() == null) {
                    arr.add(entry.id());
                    continue;
                }
                arr.add(context.serialize((Object)entry));
            }
            return arr;
        }

        public PackMap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            PackMap map = new PackMap();
            for (JsonElement el : json.getAsJsonArray()) {
                PackEntry entry = (PackEntry)context.deserialize(el, PackEntry.class);
                map.put(entry.id(), entry);
            }
            return map;
        }
    }

    static class PackMap
    extends Object2ObjectLinkedOpenHashMap<String, PackEntry> {
        PackMap() {
        }

        PackMap(Map<String, PackEntry> map) {
            super(map);
        }
    }
}

