/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.config;

import io.github.fishstiz.packed_packs.config.PackEntry;
import io.github.fishstiz.packed_packs.config.PackOptions;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.lang.ObjectsUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_3288;
import net.minecraft.class_9225;
import org.jetbrains.annotations.Nullable;

public class Profile
implements PackOptions,
Serializable {
    public static final int NAME_MAX_LENGTH = 32;
    private boolean locked = false;
    private long id;
    private String name;
    private final Set<String> hiddenIds = new ObjectOpenHashSet();
    private PackEntry.PackMap packIds = new PackEntry.PackMap();

    public Profile() {
    }

    public Profile(String name) {
        this();
        this.name = Profile.trimName(name);
    }

    private Profile(String name, PackEntry.PackMap packIds) {
        this(name);
        this.packIds = packIds;
    }

    void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!this.isLocked()) {
            this.name = Profile.trimName(name);
        }
    }

    public Profile copy() {
        Object profileName = this.name;
        if (profileName != null && !((String)profileName).isBlank()) {
            profileName = (String)profileName + " - " + ResourceUtil.getText("profile.copy", new Object[0]).getString();
        }
        return new Profile((String)profileName, new PackEntry.PackMap((Map<String, PackEntry>)((Object)this.packIds)));
    }

    void setPackMap(PackEntry.PackMap packMap) {
        this.packIds = packMap;
    }

    public boolean includes(class_3288 pack) {
        return this.packIds.containsKey(pack.method_14463());
    }

    public List<String> getPackIds() {
        return List.copyOf(this.packIds.keySet());
    }

    public void setPacks(List<class_3288> packs) {
        if (!this.locked) {
            this.setPackMap(this.toMap(PackUtil.extractPackIds(packs)));
        }
    }

    public void setHidden(boolean hidden, class_3288 ... packs) {
        for (class_3288 pack : packs) {
            if (hidden) {
                this.hiddenIds.add(pack.method_14463());
                continue;
            }
            this.hiddenIds.remove(pack.method_14463());
        }
    }

    public void setRequired(@Nullable Boolean required, class_3288 ... packs) {
        for (class_3288 pack : packs) {
            PackEntry entry;
            String id = pack.method_14463();
            if (Boolean.FALSE.equals(required) && (id.equals("vanilla") || id.equals("fabric")) || (entry = (PackEntry)this.packIds.get(id)) == null) continue;
            this.packIds.put(id, new PackEntry(id, required, entry.fixed()));
        }
    }

    public void setPosition(@Nullable class_3288.class_3289 position, class_3288 ... packs) {
        for (class_3288 pack : packs) {
            PackEntry entry = (PackEntry)this.packIds.get(pack.method_14463());
            if (entry == null) continue;
            this.packIds.put(pack.method_14463(), new PackEntry(pack.method_14463(), entry.required(), position != null ? PackEntry.SerializedPosition.get(position) : null));
        }
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public boolean isHidden(class_3288 pack) {
        return this.hiddenIds.contains(pack.method_14463());
    }

    @Override
    public boolean isRequired(class_3288 pack) {
        return Boolean.TRUE.equals(ObjectsUtil.mapOrDefault((PackEntry)this.packIds.get(pack.method_14463()), false, PackEntry::required));
    }

    @Override
    public boolean isFixed(class_3288 pack) {
        return ObjectsUtil.mapOrDefault((PackEntry)this.packIds.get(pack.method_14463()), false, entry -> entry.fixed() != null);
    }

    @Override
    @Nullable
    public class_3288.class_3289 getPosition(class_3288 pack) {
        PackEntry entry = (PackEntry)this.packIds.get(pack.method_14463());
        if (entry != null && entry.fixed() != null) {
            return entry.fixed().pos();
        }
        return null;
    }

    @Override
    @Nullable
    public class_9225 getSelectionConfig(class_3288 pack) {
        PackEntry packEntry = (PackEntry)this.packIds.get(pack.method_14463());
        if (packEntry != null && (packEntry.required() != null || packEntry.fixed() != null)) {
            return new class_9225(this.isRequired(pack), this.getPosition(pack), this.isFixed(pack));
        }
        return null;
    }

    public boolean overridesRequired(class_3288 pack) {
        return this.overridesProperty(pack, PackEntry::required);
    }

    public boolean overridesPosition(class_3288 pack) {
        return this.overridesProperty(pack, PackEntry::fixed);
    }

    private boolean overridesProperty(class_3288 pack, Function<PackEntry, @Nullable Object> property) {
        PackEntry entry = (PackEntry)this.packIds.get(pack.method_14463());
        return entry != null && property.apply(entry) != null;
    }

    private PackEntry.PackMap toMap(List<String> packIds) {
        PackEntry.PackMap entryMap = new PackEntry.PackMap();
        Iterator<String> iterator = packIds.iterator();
        while (iterator.hasNext()) {
            String packId;
            PackEntry entry = (PackEntry)this.packIds.get(packId = iterator.next());
            entryMap.put(packId, entry != null ? entry : new PackEntry(packId));
        }
        return entryMap;
    }

    private static String trimName(String name) {
        if (name == null) {
            return null;
        }
        return name.length() <= 32 ? name : name.substring(0, 32);
    }
}

