/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.FidgetzText;
import io.github.fishstiz.fidgetz.gui.components.ToggleableDialog;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuContainer;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.gui.shapes.GuiRectangle;
import io.github.fishstiz.fidgetz.util.DrawUtil;
import io.github.fishstiz.packed_packs.gui.components.contextmenu.PackMenuHeader;
import io.github.fishstiz.packed_packs.gui.components.events.FileDeleteEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FileRenameOpenEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FolderCloseEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.gui.components.pack.FolderPackList;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.gui.components.pack.PackListBase;
import io.github.fishstiz.packed_packs.pack.PackAssets;
import io.github.fishstiz.packed_packs.pack.folder.FolderPack;
import io.github.fishstiz.packed_packs.transform.interfaces.IPack;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.lang.ObjectsUtil;
import net.minecraft.class_2561;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import org.jetbrains.annotations.Nullable;

public class FolderDialog
extends ToggleableDialog<FolderPackList>
implements ContextMenuContainer {
    private static final class_2561 BACK_TEXT = class_5244.field_24339.method_27661().method_10852(class_5244.field_39678);
    private static final int HEADER_HEIGHT = 16;
    private final FidgetzButton<Void> closeButton;
    private final FidgetzText<Void> folderTitle;
    private Sprite folderSprite = Sprite.of16(PackAssets.DEFAULT_FOLDER_ICON);
    private PackList parent;
    private FolderPack folderPack;

    private FolderDialog(Builder builder) {
        super(builder);
        ((FolderPackList)this.root()).field_22764 = false;
        this.closeButton = this.addRenderableWidget(((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().setOnPress(() -> this.sendEvent(new FolderCloseEvent((FolderPackList)this.root(), this.folderPack)))).makeSquare(GuiConstants.CROSS_SPRITE.width)).spriteOnly()).build());
        this.folderTitle = this.addRenderableWidget(((FidgetzText.Builder)FidgetzText.builder().setHeight(GuiConstants.CROSS_SPRITE.height)).setOffsetY(1).setShadow(true).alignLeft().build());
        this.addListener(open -> {
            ((FolderPackList)this.root()).field_22764 = open;
            if (!open.booleanValue()) {
                this.sendEvent(new FolderCloseEvent((FolderPackList)this.root(), this.folderPack));
            }
        });
    }

    private void updateBounds() {
        GuiRectangle bounds = this.getBoundingBox();
        int parentX = bounds.method_46426();
        int parentY = bounds.method_46427();
        int parentWidth = bounds.method_25368();
        int parentHeight = bounds.method_25364();
        int left = parentX + 8;
        int top = parentY + 8;
        int right = parentX + parentWidth - 8;
        int bottom = parentY + parentHeight - 8;
        ((FolderPackList)this.root()).method_48229(left, top + 16 + 8);
        ((FolderPackList)this.root()).method_25358(right - left);
        ((FolderPackList)this.root()).method_53533(bottom - ((FolderPackList)this.root()).method_46427());
        this.closeButton.method_48229(left, top);
        this.folderTitle.method_48229(left + this.closeButton.method_25368() + 8, top);
        this.folderTitle.method_25358(bounds.getRight() - this.folderTitle.method_46426() - 16);
    }

    public void updateFolder(PackList parent, FolderPack folderPack, PackAssets packAssets) {
        this.parent = parent;
        this.folderPack = folderPack;
        this.folderTitle.method_25355(folderPack.method_14457());
        packAssets.getOrLoadIcon(folderPack, icon -> {
            this.folderSprite = Sprite.of16(icon);
        });
        this.setBoundingBox(parent);
        this.updateBounds();
        ((FolderPackList)this.root()).onChangeParent(parent);
    }

    @Override
    protected void renderBackground(class_332 guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        this.updateBounds();
        super.renderBackground(guiGraphics, x, y, width, height, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderForeground(class_332 guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        int left = this.closeButton.method_46426();
        int top = this.closeButton.method_46427();
        this.folderSprite.renderClamped(guiGraphics, left, top, GuiConstants.CROSS_SPRITE.width, GuiConstants.CROSS_SPRITE.height, partialTick);
        if (this.closeButton.method_49606()) {
            GuiConstants.WHITE_OVERLAY.render(guiGraphics, left, top, GuiConstants.CROSS_SPRITE.width, GuiConstants.CROSS_SPRITE.height);
            GuiConstants.CROSS_SPRITE.render(guiGraphics, left, top);
        }
    }

    @Nullable
    public PackList getParent() {
        return this.parent;
    }

    @Nullable
    public FolderPack getFolderPack() {
        return this.folderPack;
    }

    @Override
    public void buildItems(ContextMenuItemBuilder builder, int mouseX, int mouseY) {
        ContextMenuContainer.super.buildItems(builder.when(this.folderPack != null && this.isOpen()).ifTrue(folderMenuBuilder -> folderMenuBuilder.add(new PackMenuHeader(this.folderPack, this.folderSprite)).simpleItem(BACK_TEXT, () -> this.setOpen(false)).when(((FolderPackList)this.root()).method_19355(mouseX, mouseY).isEmpty()).ifTrue(b -> b.whenNonNull(ObjectsUtil.mapOrNull(this.folderPack, IPack::packed_packs$getPath)).ifTrue((path, operationsMenuBuilder) -> operationsMenuBuilder.separator().simpleItem(PackAssets.RENAME_FILE_TEXT, this::canOperateFolder, this::renameDirectory).simpleItem(PackAssets.DELETE_FILE_TEXT, this::canOperateFolder, this::deleteDirectory).simpleItem(PackAssets.OPEN_FILE_TEXT, () -> PackUtil.openPack(this.folderPack)).simpleItem(PackAssets.OPEN_PARENT_TEXT, () -> PackUtil.openParent(this.folderPack))))), mouseX, mouseY);
    }

    private boolean canOperateFolder() {
        return this.folderPack != null && !((FolderPackList)this.root()).packAssets.isEnabled(this.folderPack) && PackAssets.validatePackPath(this.folderPack) != null;
    }

    private void renameDirectory() {
        if (this.folderPack != null) {
            this.sendEvent(new FileRenameOpenEvent((PackList)this.root(), this.folderPack));
        }
    }

    private void deleteDirectory() {
        if (((FolderPackList)this.root()).packAssets.deletePack(this.folderPack)) {
            this.setOpen(false);
            ((FolderPackList)this.root()).remove(this.folderPack);
            this.sendEvent(new FileDeleteEvent((PackList)this.root()));
        }
    }

    public void onRename(class_3288 pack, class_2561 newName) {
        PackList packList = this.parent;
        if (packList instanceof PackListBase) {
            PackListBase packListBase = (PackListBase)packList;
            if (pack == this.folderPack) {
                PackList.Entry entry = packListBase.getEntry(this.folderPack);
                if (entry != null) {
                    ((PackListBase.Entry)entry).onRename(newName);
                }
                this.setOpen(false);
            }
        }
    }

    private void sendEvent(PackListEvent event) {
        ((PackListEventListener)this.screen).onEvent(event);
    }

    public static <S extends class_437 & PackListEventListener> FolderDialog create(S screen, PackAssets packAssets) {
        return ((Builder)new Builder(screen, new FolderPackList(packAssets, screen)).setBackground(DrawUtil.DEMO_BACKGROUND)).build();
    }

    private static class Builder
    extends ToggleableDialog.Builder<FolderPackList, Builder> {
        protected <S extends class_437 & PackListEventListener> Builder(S screen, FolderPackList root) {
            super(screen, root);
        }

        public FolderDialog build() {
            return new FolderDialog(this);
        }
    }
}

