package io.github.fishstiz.fidgetz.gui.layouts;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.minecraft.class_339;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8133;
import net.minecraft.class_8667;

public class FlexLayout implements class_8133 {
    private final List<Child<? extends class_8021>> children = new ObjectArrayList<>();
    private final class_8667 wrappedLayout;
    private final class_8667.class_8668 orientation;
    private final @Nullable IntSupplier maxSizeAtOrientation;
    private int minWidth;
    private int minHeight;
    private int spacing;

    private FlexLayout(class_8667.class_8668 orientation, @Nullable IntSupplier maxSizeAtOrientation, int minWidth, int minHeight, int spacing) {
        this.wrappedLayout = new class_8667(0, 0, orientation).method_52735(spacing);
        this.orientation = orientation;
        this.maxSizeAtOrientation = maxSizeAtOrientation;
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.spacing = spacing;
    }

    private FlexLayout(class_8667.class_8668 orientation, @Nullable IntSupplier maxSizeAtOrientation) {
        this(orientation, maxSizeAtOrientation, 0, 0, 0);
    }

    private void addChild(Child<? extends class_8021> child) {
        this.children.add(child);
        switch (this.orientation) {
            case field_45404 -> this.minWidth = Math.max(this.minWidth, child.getWidth());
            case field_45403 -> this.minHeight = Math.max(this.minHeight, child.getHeight());
        }
    }

    public <T extends class_8021> T addChild(T child, class_7847 layoutSettings) {
        this.addChild(new Child<>(child, layoutSettings));
        return this.wrappedLayout.method_52737(child, layoutSettings);
    }

    public <T extends class_8021> T addChild(T child) {
        return this.addChild(child, this.wrappedLayout.method_52739());
    }

    public <T extends class_339> T addFlexChild(T child, boolean crossAxis, class_7847 layoutSettings) {
        this.addChild(new FlexWidget(child, crossAxis, layoutSettings));
        return this.wrappedLayout.method_52737(child, layoutSettings);
    }

    public <T extends class_339> T addFlexChild(T child, boolean crossAxis) {
        return this.addFlexChild(child, crossAxis, this.wrappedLayout.method_52739());
    }

    public <T extends class_339> T addFlexChild(T child) {
        return this.addFlexChild(child, false, this.wrappedLayout.method_52739());
    }

    public <T extends FlexLayout> T addFlexChild(T child, boolean crossAxis, class_7847 layoutSettings) {
        this.addChild(new NestedFlexLayout(child, crossAxis, layoutSettings));
        return this.wrappedLayout.method_52737(child, layoutSettings);
    }

    public <T extends FlexLayout> T addFlexChild(T child, boolean crossAxis) {
        return this.addFlexChild(child, crossAxis, this.wrappedLayout.method_52739());
    }

    public <T extends FlexLayout> T addFlexChild(T child) {
        return this.addFlexChild(child, false, this.wrappedLayout.method_52739());
    }

    private int getMinSizeAtOrientation() {
        return switch (this.orientation) {
            case field_45403 -> this.minWidth;
            case field_45404 -> this.minHeight;
        };
    }

    private int getPaddingAtOrientation(Child<?> child) {
        class_7847.class_7848 layoutSettings = child.layoutSettings.method_46480();
        return switch (this.orientation) {
            case field_45403 -> layoutSettings.field_40778 + layoutSettings.field_40780;
            case field_45404 -> layoutSettings.field_40779 + layoutSettings.field_40781;
        };
    }

    private int getFlexDistribution() {
        int padding = 0;
        int totalSize = 0;
        int flexCount = 0;

        for (int i = 0; i < this.children.size(); i++) {
            Child<?> child = this.children.get(i);

            if (child instanceof FlexChild<?>) {
                flexCount++;
            } else {
                totalSize += child.getSizeAtOrientation(this.orientation);
            }

            if (i < this.children.size() - 1) {
                totalSize += spacing;
            }

            padding += this.getPaddingAtOrientation(child);
        }

        int max = this.maxSizeAtOrientation != null ? this.maxSizeAtOrientation.getAsInt() : this.getMinSizeAtOrientation();
        return flexCount > 0 ? (max - padding - totalSize) / flexCount : 0;
    }

    @Override
    public void method_48222() {
        int distribution = this.getFlexDistribution();

        for (Child<?> child : this.children) {
            if (child instanceof FlexChild<?> flexChild) {
                flexChild.setDistribution(this.orientation, distribution, this.minWidth, this.minHeight);
            }
        }

        this.wrappedLayout.method_48222();
    }

    @Override
    public void method_48227(Consumer<class_8021> visitor) {
        this.wrappedLayout.method_48227(visitor);
    }

    @Override
    public void method_46421(int x) {
        this.wrappedLayout.method_46421(x);
    }

    @Override
    public void method_46419(int y) {
        this.wrappedLayout.method_46419(y);
    }

    @Override
    public int method_46426() {
        return this.wrappedLayout.method_46426();
    }

    @Override
    public int method_46427() {
        return this.wrappedLayout.method_46427();
    }

    @Override
    public int method_25368() {
        return Math.max(this.minWidth, this.wrappedLayout.method_25368());
    }

    @Override
    public int method_25364() {
        return Math.max(this.minHeight, this.wrappedLayout.method_25364());
    }

    public FlexLayout spacing(int spacing) {
        this.wrappedLayout.method_52735(spacing);
        this.spacing = spacing;
        return this;
    }

    public FlexLayout copyLayout() {
        return new FlexLayout(this.orientation, this.maxSizeAtOrientation, this.minWidth, this.minHeight, this.spacing);
    }

    public static FlexLayout horizontal(IntSupplier maxWidth) {
        return new FlexLayout(class_8667.class_8668.field_45403, maxWidth);
    }

    public static FlexLayout horizontal() {
        return new FlexLayout(class_8667.class_8668.field_45403, null);
    }

    public static FlexLayout vertical(IntSupplier maxHeight) {
        return new FlexLayout(class_8667.class_8668.field_45404, maxHeight);
    }

    public static FlexLayout vertical() {
        return new FlexLayout(class_8667.class_8668.field_45404, null);
    }

    private static class Child<T extends class_8021> {
        protected final T element;
        protected final class_7847 layoutSettings;

        protected Child(T element, class_7847 layoutSettings) {
            this.element = element;
            this.layoutSettings = layoutSettings;
        }

        protected int getSizeAtOrientation(class_8667.class_8668 orientation) {
            return orientation == class_8667.class_8668.field_45403 ? this.getWidth() : this.getHeight();
        }

        protected int getWidth() {
            return this.element.method_25368();
        }

        protected int getHeight() {
            return this.element.method_25364();
        }
    }

    private abstract static class FlexChild<T extends class_8021> extends Child<T> {
        protected final boolean crossAxis;

        protected FlexChild(T element, boolean crossAxis, class_7847 layoutSettings) {
            super(element, layoutSettings);

            this.crossAxis = crossAxis;
        }

        protected abstract void setWidth(int width);

        protected abstract void setHeight(int height);

        protected void setDistribution(class_8667.class_8668 orientation, int distribution, int width, int height) {
            if (orientation == class_8667.class_8668.field_45403) {
                this.setWidth(distribution);
                if (this.crossAxis && height > 0) {
                    this.setHeight(height);
                }
            } else {
                this.setHeight(distribution);
                if (this.crossAxis && width > 0) {
                    this.setWidth(width);
                }
            }
        }
    }

    private static class FlexWidget extends FlexChild<class_339> {
        private FlexWidget(class_339 element, boolean crossAxis, class_7847 layoutSettings) {
            super(element, crossAxis, layoutSettings);
        }

        @Override
        protected void setWidth(int width) {
            this.element.method_25358(width);
        }

        @Override
        protected void setHeight(int height) {
            this.element.method_53533(height);
        }
    }

    private static class NestedFlexLayout extends FlexChild<FlexLayout> {
        private NestedFlexLayout(FlexLayout element, boolean crossAxis, class_7847 layoutSettings) {
            super(element, crossAxis, layoutSettings);
        }

        @Override
        protected void setWidth(int width) {
            this.element.minWidth = width;
        }

        @Override
        protected void setHeight(int height) {
            this.element.minHeight = height;
        }
    }
}
