package io.github.fishstiz.fidgetz.transform.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.fishstiz.fidgetz.gui.components.ToggleableDialogContainer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_364;
import net.minecraft.class_4069;

@Mixin(class_4069.class)
public interface ContainerEventHandlerMixin {
    @WrapOperation(method = "handleTabNavigation", at = @At(
            value = "NEW",
            target = "(Ljava/util/Collection;)Ljava/util/ArrayList;"
    ))
    private ArrayList<class_364> filterCoveredFromPath(
            Collection<class_364> children,
            Operation<ArrayList<class_364>> original
    ) {
        if (!(this instanceof ToggleableDialogContainer dialogContainer)) {
            return original.call(children);
        }
        return this.fidgetz$filterCovered(dialogContainer, children);
    }

    @WrapOperation(method = {"nextFocusPathInDirection", "nextFocusPathVaguelyInDirection"}, at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/gui/components/events/ContainerEventHandler;children()Ljava/util/List;"
    ))
    private List<? extends class_364> filterCoveredFromPath(
            class_4069 instance,
            Operation<List<? extends class_364>> original
    ) {
        List<? extends class_364> children = original.call(instance);

        if (!(this instanceof ToggleableDialogContainer dialogContainer)) {
            return children;
        }

        return this.fidgetz$filterCovered(dialogContainer, children);
    }

    @Unique
    private ArrayList<class_364> fidgetz$filterCovered(
            ToggleableDialogContainer self,
            Collection<? extends class_364> children
    ) {
        ArrayList<class_364> focusable = new ArrayList<>(children.size());
        for (class_364 child : children) {
            if (!self.isChildCovered(child)) {
                focusable.add(child);
            }
        }
        return focusable;
    }
}
