package io.github.fishstiz.packed_packs.gui.components.events;

import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import net.minecraft.class_364;
import net.minecraft.class_4069;

import static io.github.fishstiz.packed_packs.util.InputUtil.isLeftClick;

public interface DragEventHandler extends class_4069 {
    @Nullable DragEvent getDragged();

    void setDragged(DragEvent dragged);

    default boolean isDraggingSelection() {
        return this.getDragged() != null;
    }

    default void handleDragEvent(DragEvent event) {
        if (!this.isDraggingSelection()) {
            this.setDragged(event);
        }
    }

    default void onRelease(@NotNull DragEvent event, double mouseX, double mouseY) {
        Optional<class_364> child = this.method_19355(mouseX, mouseY);
        if (child.isPresent() && child.get() instanceof PackList packList) {
            packList.drop(event, mouseX, mouseY);
        }
    }

    @Override
    default boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingSelection()) {
            return true;
        }

        return class_4069.super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    default boolean method_25406(double mouseX, double mouseY, int button) {
        DragEvent event = this.getDragged();

        if (isLeftClick(button) && event != null) {
            this.onRelease(event, mouseX, mouseY);
            this.setDragged(null);
            return true;
        }

        return class_4069.super.method_25406(mouseX, mouseY, button);
    }

    @Deprecated(since = "mc1.21.6")
    default float getDroppableZ() {
        return 1f;
    }
}
