package io.github.fishstiz.packed_packs.compat.vtdownloader;

import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.packed_packs.compat.ModScreenFactory;
import io.github.fishstiz.packed_packs.config.Preferences;
import io.github.fishstiz.packed_packs.gui.components.ToggleableHelper;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_7919;

public class VTDButtonFactory {
    static final String VTD_SCREEN_NAME = "me.bymartrixx.vtd.gui.VTDownloadScreen";
    static final Sprite VTD_ICON = Sprite.of32(class_2960.method_60655("vt_downloader", "icon.png"));
    static final class_2561 VTD_MESSAGE = class_2561.method_43471("vtd.resourcePack.button");
    static final class_2561 VTD_SUBTITLE = class_2561.method_43471("vtd.resourcePack.subtitle");

    private VTDButtonFactory() {
    }

    public static FidgetzButton<Void> create(class_437 previous) {
        return ToggleableHelper.applyPref(Preferences.INSTANCE.vtdButton, FidgetzButton.<Void>builder())
                .makeSquare()
                .setTooltip(class_7919.method_47407(VTD_MESSAGE))
                .setSprite(VTD_ICON)
                .setFocusedBorder(Theme.WHITE.getARGB())
                .setOnPress(ModScreenFactory.createScreenSetter(
                        VTD_SCREEN_NAME,
                        new ModScreenFactory.Arg<>(class_437.class, previous),
                        new ModScreenFactory.Arg<>(class_2561.class, VTD_SUBTITLE)
                ))
                .build();
    }
}

