/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.gui.renderables.GradientRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import io.github.fishstiz.fidgetz.util.lang.ObjectsUtil;
import io.github.fishstiz.packed_packs.gui.components.MouseSelectionHandler;
import io.github.fishstiz.packed_packs.gui.components.SelectionContext;
import io.github.fishstiz.packed_packs.gui.components.events.DragEvent;
import io.github.fishstiz.packed_packs.gui.components.events.MoveEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.gui.components.pack.PackListModel;
import io.github.fishstiz.packed_packs.pack.PackAssetManager;
import io.github.fishstiz.packed_packs.pack.PackFileOperations;
import io.github.fishstiz.packed_packs.pack.PackOptionsContext;
import io.github.fishstiz.packed_packs.util.InputUtil;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_350;
import org.jetbrains.annotations.NotNull;

public class CurrentPackList
extends PackList {
    private static final Sprite UNSELECT_HIGHLIGHTED_SPRITE = Sprite.of32(ResourceUtil.getVanillaSprite("transferable_list/unselect_highlighted"));
    private static final Sprite UNSELECT_SPRITE = Sprite.of32(ResourceUtil.getVanillaSprite("transferable_list/unselect"));
    private static final Sprite MOVE_UP_HIGHLIGHTED_SPRITE = Sprite.of32(ResourceUtil.getVanillaSprite("transferable_list/move_up_highlighted"));
    private static final Sprite MOVE_UP_SPRITE = Sprite.of32(ResourceUtil.getVanillaSprite("transferable_list/move_up"));
    private static final Sprite MOVE_DOWN_HIGHLIGHTED_SPRITE = Sprite.of32(ResourceUtil.getVanillaSprite("transferable_list/move_down_highlighted"));
    private static final Sprite MOVE_DOWN_SPRITE = Sprite.of32(ResourceUtil.getVanillaSprite("transferable_list/move_down"));
    private static final Theme DROP_THEME = Theme.GREEN_500;
    private static final ColoredRect DROP_INDEX = new ColoredRect(DROP_THEME.getARGB());
    private static final GradientRect SCROLL_UP = GradientRect.fromTop(DROP_THEME.withAlpha(0.75f), DROP_THEME.withAlpha(0.0f));
    private static final GradientRect SCROLL_DOWN = SCROLL_UP.flip();
    private static final int DROP_INDEX_PADDING = 2;
    private static final double SCROLL_STEP = 10.0;
    private boolean scrolling;

    public CurrentPackList(PackOptionsContext options, PackAssetManager assets, PackFileOperations fileOps, PackListEventListener listener) {
        super(options, assets, fileOps, listener);
    }

    @Override
    @NotNull
    protected Entry createEntry(SelectionContext<class_3288> pack, int index) {
        return new Entry(pack, index);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        PackList.Entry entry;
        boolean keyPressed = super.method_25404(keyCode, scanCode, modifiers);
        if (!keyPressed && (entry = this.getEntry(this.getLastSelected())) instanceof Entry) {
            Entry movableEntry = (Entry)entry;
            if (InputUtil.isMoveDown(keyCode, modifiers)) {
                if (movableEntry.moveDown()) {
                    GuiUtil.playClickSound();
                }
                return true;
            }
            if (InputUtil.isMoveUp(keyCode, modifiers)) {
                if (movableEntry.moveUp()) {
                    GuiUtil.playClickSound();
                }
                return true;
            }
        }
        return keyPressed;
    }

    private void scrollStep(MoveDirection direction, float partialTick) {
        double scrollAmount = this.method_25341();
        if (direction.isUp()) {
            scrollAmount -= 10.0 * (double)partialTick;
        } else if (direction.isDown()) {
            scrollAmount += 10.0 * (double)partialTick;
        }
        this.scrolling = true;
        this.method_60321(scrollAmount);
    }

    private int getDropIndex(double mouseY) {
        if (this.method_25396().isEmpty()) {
            return -1;
        }
        int index = this.getRowIndex(mouseY);
        if (index == -1) {
            return -1;
        }
        PackList.Entry entry = (PackList.Entry)this.method_25326(index);
        int centerY = entry.method_46427() + entry.method_25364() / 2;
        if (mouseY >= (double)centerY) {
            int next = index + 1;
            return next < this.method_25396().size() ? next : -1;
        }
        return index;
    }

    private int toPackIndex(int dropIndex) {
        List children = this.method_25396();
        if (dropIndex == -1) {
            return !children.isEmpty() ? this.list.indexOf(((PackList.Entry)children.getLast()).pack()) + 1 : -1;
        }
        return Math.clamp((long)this.list.indexOf(((PackList.Entry)children.get(dropIndex)).pack()), 0, this.list.size());
    }

    private boolean isMouserOverSelection(List<class_3288> selection, double mouseX, double mouseY) {
        for (class_3288 selected : selection) {
            PackList.Entry entry = this.getEntry(selected);
            if (entry == null || !entry.method_25405(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canInteract(PackList source) {
        return true;
    }

    @Override
    public boolean canDrop(DragEvent dragEvent, double mouseX, double mouseY) {
        PackList source = dragEvent.target();
        List<class_3288> payload = dragEvent.payload();
        class_3288 trigger = dragEvent.trigger();
        if (this.scrolling || this.isQueried() || this.options.isLocked() || payload.isEmpty() || !source.canInteract(this)) {
            return false;
        }
        if (this.method_25396().isEmpty()) {
            return true;
        }
        if (source == this && this.options.isFixed(trigger) || this.isMouserOverSelection(payload, mouseX, mouseY)) {
            return false;
        }
        int dropIndex = this.getDropIndex(mouseY);
        if (!this.list.isValidDropPosition(this.toPackIndex(dropIndex))) {
            return false;
        }
        if (source != this) {
            return source.isTransferable(trigger);
        }
        return this.list.isValidInsertPosition(dropIndex, payload);
    }

    @Override
    protected List<class_3288> handleDrop(DragEvent dragEvent, double mouseX, double mouseY) {
        if (!this.canDrop(dragEvent, mouseX, mouseY)) {
            return Collections.emptyList();
        }
        PackList source = dragEvent.target();
        List<class_3288> payload = dragEvent.payload();
        int dropPackIndex = this.list.clampPosition(this.toPackIndex(this.getDropIndex(mouseY)));
        if (source == this) {
            ObjectArrayList movable = new ObjectArrayList(payload);
            movable.removeIf(this.options::isFixed);
            return this.moveAll((List<class_3288>)movable, dropPackIndex) ? payload : Collections.emptyList();
        }
        this.clearSelection();
        ObjectArrayList dropped = new ObjectArrayList(payload);
        for (class_3288 selected : payload) {
            if (!source.isTransferable(selected)) continue;
            dropped.add(selected);
            this.addOrMove(selected, dropPackIndex);
        }
        this.refreshList();
        source.removeAll((List<class_3288>)dropped);
        dropped.forEach(this::select);
        this.select(dragEvent.trigger());
        return dropped;
    }

    private void renderDropIndex(class_332 guiGraphics, int mouseY, int x, int width) {
        int dropIndex = this.getDropIndex(mouseY);
        int rowTop = this.method_25337(dropIndex != -1 ? dropIndex : this.method_25396().size());
        int indexY = rowTop - this.rowGap - 2;
        guiGraphics.method_44379(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443());
        DROP_INDEX.render(guiGraphics, x, indexY, width, rowTop - indexY + 2);
        guiGraphics.method_44380();
    }

    @Override
    public void renderDroppableZone(class_332 guiGraphics, DragEvent dragEvent, int mouseX, int mouseY, float partialTick) {
        PackList source = dragEvent.target();
        if (this.options.isLocked() || !source.canInteract(this)) {
            return;
        }
        int x = this.method_46426();
        int y = this.method_46427();
        int width = this.method_57717() ? this.method_25368() - this.scrollbarOffset : this.method_25368();
        int height = this.method_25364();
        int bottom = this.method_55443();
        if (this.method_25405(mouseX, mouseY)) {
            double scrollAmount = this.method_25341();
            int scrollDownY = bottom - this.field_22741;
            if (scrollAmount < (double)this.method_25331() && mouseY >= scrollDownY) {
                SCROLL_DOWN.render(guiGraphics, x, scrollDownY, width, this.field_22741);
                this.scrollStep(MoveDirection.DOWN, partialTick);
            } else if (scrollAmount > 0.0 && mouseY <= y + this.field_22741) {
                SCROLL_UP.render(guiGraphics, x, y, width, this.field_22741);
                this.scrollStep(MoveDirection.UP, partialTick);
            } else {
                this.scrolling = false;
            }
            if (this.canDrop(dragEvent, mouseX, mouseY)) {
                this.renderDropIndex(guiGraphics, mouseY, x, width);
            }
        }
        guiGraphics.method_49601(x, y, width, height, DROP_THEME.getARGB());
    }

    public class Entry
    extends PackList.Entry {
        protected Entry(SelectionContext<class_3288> context, int index) {
            super(CurrentPackList.this, context, index);
        }

        @Override
        public boolean isTransferable() {
            return super.isTransferable() && !CurrentPackList.this.options.isRequired(this.pack());
        }

        @Override
        protected boolean handleMouseAction(MouseSelectionHandler.Action action) {
            if (action == MouseSelectionHandler.Action.DRAG) {
                return !this.isFixed() && super.handleMouseAction(action);
            }
            return super.handleMouseAction(action);
        }

        public boolean isFixed() {
            return CurrentPackList.this.options.isFixed(this.pack()) || CurrentPackList.this.options.isLocked() || CurrentPackList.this.isQueried() || this.isStale();
        }

        public boolean canMoveDown() {
            return !this.isFixed() && CurrentPackList.this.list.canMoveDown(this.pack());
        }

        public boolean canMoveUp() {
            return !this.isFixed() && CurrentPackList.this.list.canMoveUp(this.pack());
        }

        public boolean isMouseOverRemove(double mouseX, double mouseY) {
            return CurrentPackList.this.method_49606() && this.isTransferable() && GuiUtil.containsPoint(this.method_46426() + 2, this.method_46427(), CurrentPackList.UNSELECT_SPRITE.width / 2, CurrentPackList.UNSELECT_SPRITE.height, mouseX, mouseY);
        }

        public boolean isMouseOverUp(double mouseX, double mouseY) {
            return CurrentPackList.this.method_49606() && this.canMoveUp() && GuiUtil.containsPoint(this.method_46426() + 2 + CurrentPackList.MOVE_UP_SPRITE.width / 2, this.method_46427(), CurrentPackList.MOVE_UP_SPRITE.width / 2, CurrentPackList.MOVE_UP_SPRITE.height / 2, mouseX, mouseY);
        }

        public boolean isMouseOverDown(double mouseX, double mouseY) {
            return CurrentPackList.this.method_49606() && this.canMoveDown() && GuiUtil.containsPoint(this.method_46426() + 2 + CurrentPackList.MOVE_DOWN_SPRITE.width / 2, this.method_46427() + CurrentPackList.MOVE_DOWN_SPRITE.height / 2, CurrentPackList.MOVE_DOWN_SPRITE.width / 2, CurrentPackList.MOVE_DOWN_SPRITE.height / 2, mouseX, mouseY);
        }

        private void sendMoveEvent(List<class_3288> moved) {
            CurrentPackList.this.sendEvent(new MoveEvent(CurrentPackList.this, this.pack(), moved));
            PackList.Entry entry = CurrentPackList.this.getEntry(this.pack());
            if (entry != null) {
                CurrentPackList.this.method_25328((class_350.class_351)entry);
            }
        }

        private boolean move(MoveDirection moveDirection) {
            List<class_3288> selectedPacks = this.context.getItemOrSelection();
            if (selectedPacks.size() == 1) {
                class_3288 pack = (class_3288)selectedPacks.getFirst();
                if (moveDirection.movePack(CurrentPackList.this.list, pack)) {
                    CurrentPackList.this.selectExclusive(pack);
                    CurrentPackList.this.refreshList();
                    this.sendMoveEvent(selectedPacks);
                    return true;
                }
            } else if (selectedPacks.size() > 1) {
                class_3288 lastSelected = (class_3288)this.context.selection().getLast();
                List<class_3288> moved = moveDirection.moveSelection(CurrentPackList.this.list, selectedPacks);
                if (!moved.isEmpty()) {
                    CurrentPackList.this.select(lastSelected);
                    CurrentPackList.this.refreshList();
                    this.sendMoveEvent(moved);
                    return true;
                }
            }
            return false;
        }

        public boolean moveUp() {
            return this.move(MoveDirection.UP);
        }

        public boolean moveDown() {
            return this.move(MoveDirection.DOWN);
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (InputUtil.isLeftClick(button)) {
                if (this.isMouseOverRemove(mouseX, mouseY)) {
                    return this.consumeClick(PackList.Entry::transfer);
                }
                if (this.isMouseOverUp(mouseX, mouseY)) {
                    return this.consumeClick(Entry::moveUp);
                }
                if (this.isMouseOverDown(mouseX, mouseY)) {
                    return this.consumeClick(Entry::moveDown);
                }
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        private boolean consumeClick(Consumer<Entry> action) {
            GuiUtil.playClickSound();
            action.accept(this);
            return false;
        }

        @Override
        protected void renderForeground(class_332 guiGraphics, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (!hovering && !this.isSelectedLast()) {
                return;
            }
            int x = left + 2;
            GuiConstants.WHITE_OVERLAY.render(guiGraphics, x, top, CurrentPackList.UNSELECT_SPRITE.width, CurrentPackList.UNSELECT_SPRITE.height);
            if (this.isTransferable()) {
                ObjectsUtil.pick(!this.isMouseOverRemove(mouseX, mouseY), UNSELECT_SPRITE, UNSELECT_HIGHLIGHTED_SPRITE).render(guiGraphics, x, top);
            }
            if (this.canMoveUp()) {
                ObjectsUtil.pick(!this.isMouseOverUp(mouseX, mouseY), MOVE_UP_SPRITE, MOVE_UP_HIGHLIGHTED_SPRITE).render(guiGraphics, x, top);
            }
            if (this.canMoveDown()) {
                ObjectsUtil.pick(!this.isMouseOverDown(mouseX, mouseY), MOVE_DOWN_SPRITE, MOVE_DOWN_HIGHLIGHTED_SPRITE).render(guiGraphics, x, top);
            }
        }
    }

    static enum MoveDirection {
        UP{

            @Override
            boolean movePack(PackListModel list, class_3288 pack) {
                return list.moveUp(pack);
            }

            @Override
            List<class_3288> moveSelection(PackListModel list, List<class_3288> selection) {
                return list.moveSelectionUp(selection);
            }
        }
        ,
        DOWN{

            @Override
            boolean movePack(PackListModel list, class_3288 pack) {
                return list.moveDown(pack);
            }

            @Override
            List<class_3288> moveSelection(PackListModel list, List<class_3288> selection) {
                return list.moveSelectionDown(selection);
            }
        };


        boolean isUp() {
            return this == UP;
        }

        boolean isDown() {
            return this == DOWN;
        }

        abstract boolean movePack(PackListModel var1, class_3288 var2);

        abstract List<class_3288> moveSelection(PackListModel var1, List<class_3288> var2);
    }
}

