package io.github.fishstiz.fidgetz.gui.components;

import io.github.fishstiz.fidgetz.gui.Metadata;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuProvider;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.renderables.RenderableRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.ButtonSprites;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.DrawUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_11876;
import net.minecraft.class_11907;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_7919;

public class FidgetzButton<E> extends class_4185 implements Fidgetz, ContextMenuProvider, Metadata<E> {
    private final List<Runnable> listeners;
    private final Integer focusedBorder;
    private final boolean spriteOnly;
    private final boolean focusOnInteract;
    private final BiConsumer<FidgetzButton<E>, ContextMenuItemBuilder> contextMenuBuilder;
    private final RenderableRect foreground;
    private ButtonSprites sprites;
    private E metadata;

    protected FidgetzButton(Builder<E, ?> builder) {
        super(builder.x, builder.y, builder.width, builder.height, builder.message, builder.onPress, field_40754);

        this.metadata = builder.metadata;
        this.sprites = builder.sprites;
        this.spriteOnly = builder.spriteOnly;
        this.foreground = builder.foreground;
        this.focusedBorder = builder.focusedBorder;
        this.focusOnInteract = builder.focusOnInteract;
        this.contextMenuBuilder = builder.contextMenuBuilder;
        this.listeners = !builder.listeners.isEmpty() ? builder.listeners : Collections.emptyList();

        if (builder.tooltip != null) {
            this.method_47400(builder.tooltip);
        }
    }

    @Override
    public void method_25306(class_11907 inputWithModifiers) {
        super.method_25306(inputWithModifiers);

        for (var listener : this.listeners) {
            listener.run();
        }
    }

    public void setSprites(ButtonSprites sprites) {
        this.sprites = sprites;
    }

    @Override
    public E getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(E metadata) {
        this.metadata = metadata;
    }

    protected boolean hasSprite() {
        return this.sprites != null;
    }

    protected void renderSprite(class_332 guiGraphics, int x, int y, int width, int height, float partialTick) {
        this.sprites.render(guiGraphics, x, y, width, height, this.field_22763, partialTick);
    }

    protected void renderBorder(class_332 guiGraphics, int x, int y, int width, int height, float partialTick) {
        DrawUtil.renderOutline(guiGraphics, x, y, width, height, this.focusedBorder);
    }

    protected void renderForeground(class_332 guiGraphics, int x, int y, int width, int height, float partialTick) {
        if (this.foreground != null) {
            this.foreground.render(guiGraphics, x, y, width, height, partialTick);
        }
    }

    @Override
    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.field_22762 = this.field_22762 && this.isHovered(mouseX, mouseY);

        if (!this.spriteOnly) {
            super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        }

        if (this.hasSprite()) {
            int spriteWidth = this.method_25368();
            int spriteHeight = this.method_25364();
            int spriteX = this.method_46426() + (this.method_25368() - spriteWidth) / 2;
            int spriteY = this.method_46427() + (this.method_25364() - spriteHeight) / 2;

            this.renderSprite(guiGraphics, spriteX, spriteY, spriteWidth, spriteHeight, partialTick);
        }

        if (this.method_25367() && this.focusedBorder != null) {
            this.renderBorder(guiGraphics, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), partialTick);
        }

        this.renderForeground(guiGraphics, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), partialTick);

        this.updateCursor(guiGraphics);
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22764 && Fidgetz.super.method_25405(mouseX, mouseY);
    }

    protected void updateCursor(class_332 guiGraphics) {
        if (this.method_49606()) {
            guiGraphics.method_74037(this.method_37303() ? class_11876.field_62455 : class_11876.field_62459);
        }
    }

    @Override
    public void method_48589(class_332 guiGraphics, class_327 font, int color) {
        if (!this.hasSprite()) {
            super.method_48589(guiGraphics, font, color);
        }
    }

    @Override
    public boolean method_72784() {
        return this.focusOnInteract;
    }

    @Override
    public void buildItems(ContextMenuItemBuilder builder, int mouseX, int mouseY) {
        if (this.contextMenuBuilder != null) {
            this.contextMenuBuilder.accept(this, builder);
        }
    }

    public static <E> Builder<E, ?> builder() {
        return new Builder<>();
    }

    public static class Builder<E, B extends Builder<E, B>> extends AbstractWidgetBuilder<B> {
        private final List<Runnable> listeners = new ObjectArrayList<>();
        private class_2561 message = class_5244.field_39003;
        private class_7919 tooltip;
        private ButtonSprites sprites;
        private boolean spriteOnly = false;
        private RenderableRect foreground;
        private Integer focusedBorder;
        private boolean focusOnInteract = true;
        private class_4241 onPress = btn -> {};
        private BiConsumer<FidgetzButton<E>, ContextMenuItemBuilder> contextMenuBuilder;
        private E metadata;

        protected Builder() {
        }

        public B setMessage(class_2561 message) {
            this.message = message;
            return self();
        }

        public B setMessage(String message) {
            return this.setMessage(class_2561.method_43471(message));
        }

        public B setTooltip(class_7919 tooltip) {
            this.tooltip = tooltip;
            return self();
        }

        public B setSprite(ButtonSprites sprites) {
            this.sprites = sprites;
            return self();
        }

        public B setSprite(Sprite sprite) {
            this.sprites = ButtonSprites.of(sprite);
            return self();
        }

        public B spriteOnly() {
            this.spriteOnly = true;
            return self();
        }

        public B setForeground(RenderableRect foreground) {
            this.foreground = foreground;
            return self();
        }

        public B setFocusedBorder(Integer hoverBorder) {
            this.focusedBorder = hoverBorder;
            return self();
        }

        public B setFocusOnInteract(boolean focusOnInteract) {
            this.focusOnInteract = focusOnInteract;
            return self();
        }

        public B setOnPress(class_4241 onPress) {
            this.onPress = onPress;
            return self();
        }

        public B setOnPress(Runnable onPress) {
            this.onPress = btn -> onPress.run();
            return self();
        }

        public B addListener(Runnable listener) {
            this.listeners.add(listener);
            return self();
        }

        public B setContextMenuBuilder(BiConsumer<FidgetzButton<E>, ContextMenuItemBuilder> contextMenuBuilder) {
            this.contextMenuBuilder = contextMenuBuilder;
            return self();
        }

        public B setMetadata(E metadata) {
            this.metadata = metadata;
            return self();
        }

        public FidgetzButton<E> build() {
            return new FidgetzButton<>(this);
        }
    }
}
