package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.components.*;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuContainer;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.gui.shapes.GuiRectangle;
import io.github.fishstiz.fidgetz.util.DrawUtil;
import io.github.fishstiz.packed_packs.gui.components.contextmenu.PackMenuHeader;
import io.github.fishstiz.packed_packs.gui.components.events.*;
import io.github.fishstiz.packed_packs.pack.PackAssetManager;
import io.github.fishstiz.packed_packs.pack.PackFileOperations;
import io.github.fishstiz.packed_packs.pack.PackOptionsContext;
import io.github.fishstiz.packed_packs.pack.folder.FolderPack;
import io.github.fishstiz.packed_packs.transform.interfaces.FilePack;
import io.github.fishstiz.packed_packs.util.PackUtil;
import net.minecraft.class_2561;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import io.github.fishstiz.fidgetz.util.lang.ObjectsUtil;
import org.jetbrains.annotations.Nullable;

import static io.github.fishstiz.packed_packs.util.constants.GuiConstants.*;

public class FolderDialog extends ToggleableDialog<FolderPackList> implements ContextMenuContainer {
    private static final class_2561 BACK_TEXT = class_5244.field_24339.method_27661().method_10852(class_5244.field_39678);
    private static final int HEADER_HEIGHT = 16;
    private final FidgetzButton<Void> closeButton;
    private final FidgetzText<Void> folderTitle;
    private final PackFileOperations fileOps;
    private final PackListEventListener listener;
    private Sprite folderSprite = PackAssetManager.DEFAULT_FOLDER_ICON;
    private PackList parent;
    private FolderPack folderPack;

    public <S extends class_437 & ToggleableDialogContainer & PackListEventListener> FolderDialog(
            S screen,
            PackOptionsContext options,
            PackAssetManager assets,
            PackFileOperations fileOps
    ) {
        super(builder(screen, new FolderPackList(options, assets, fileOps, screen)).setBackground(DrawUtil.DEMO_BACKGROUND));

        this.listener = screen;
        this.fileOps = fileOps;
        this.closeButton = this.addRenderableWidget(
                FidgetzButton.<Void>builder()
                        .setOnPress(() -> this.sendEvent(new FolderCloseEvent(this.root(), this.folderPack)))
                        .makeSquare(CROSS_SPRITE.width)
                        .spriteOnly()
                        .build()
        );
        this.folderTitle = this.addRenderableWidget(
                FidgetzText.<Void>builder()
                        .setHeight(CROSS_SPRITE.height)
                        .setOffsetY(1)
                        .setShadow(true)
                        .build()
        );

        this.root().field_22764 = false;
        this.addListener(open -> {
            this.root().field_22764 = open;
            if (!open) this.sendEvent(new FolderCloseEvent(this.root(), this.folderPack));
        });
        this.root().method_48206(this::addRenderableWidget);
    }

    private void updateBounds() {
        GuiRectangle bounds = this.getBoundingBox();
        int parentX = bounds.getX();
        int parentY = bounds.getY();
        int parentWidth = bounds.getWidth();
        int parentHeight = bounds.getHeight();

        int left = parentX + SPACING;
        int top = parentY + SPACING;
        int right = (parentX + parentWidth) - SPACING;
        int bottom = (parentY + parentHeight) - SPACING;

        this.root().method_48229(left, top + HEADER_HEIGHT + SPACING);
        this.root().method_25358(right - left);
        this.root().method_53533(bottom - this.root().method_46427());
        this.closeButton.method_48229(left, top);
        this.folderTitle.method_48229(left + this.closeButton.method_25368() + SPACING, top);
        this.folderTitle.method_25358(bounds.getRight() - this.folderTitle.method_46426() - SPACING * 2);
    }

    public void updateFolder(PackList parent, FolderPack folderPack, PackAssetManager assets) {
        this.parent = parent;
        this.folderPack = folderPack;
        this.folderTitle.method_25355(folderPack.method_14457());
        assets.getOrLoadIcon(folderPack, icon -> this.folderSprite = icon);

        this.setBoundingBox(parent);
        this.updateBounds();
    }

    @Override
    protected void renderBackground(class_332 guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        this.updateBounds();
        super.renderBackground(guiGraphics, x, y, width, height, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderForeground(class_332 guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        int left = this.closeButton.method_46426();
        int top = this.closeButton.method_46427();
        this.folderSprite.renderClamped(guiGraphics, left, top, CROSS_SPRITE.width, CROSS_SPRITE.height, partialTick);

        if (this.closeButton.method_49606()) {
            WHITE_OVERLAY.render(guiGraphics, left, top, CROSS_SPRITE.width, CROSS_SPRITE.height);
            CROSS_SPRITE.render(guiGraphics, left, top);
        }
    }

    public @Nullable PackList getParent() {
        return this.parent;
    }

    public @Nullable FolderPack getFolderPack() {
        return this.folderPack;
    }

    @Override
    public void buildItems(ContextMenuItemBuilder builder, int mouseX, int mouseY) {
        ContextMenuContainer.super.buildItems(
                builder.when(this.folderPack != null && this.isOpen())
                        .ifTrue(folderMenuBuilder -> folderMenuBuilder
                                .add(new PackMenuHeader(this.folderPack, this.folderSprite))
                                .simpleItem(BACK_TEXT, () -> this.setOpen(false))
                                .when(this.root().method_19355(mouseX, mouseY).isEmpty())
                                .ifTrue(b -> b
                                        .whenNonNull(ObjectsUtil.mapOrNull(this.folderPack, FilePack::packed_packs$getPath))
                                        .ifTrue((path, operationsMenuBuilder) -> operationsMenuBuilder
                                                .separator()
                                                .simpleItem(RENAME_FILE_TEXT, this::canOperateFolder, this::renameDirectory)
                                                .simpleItem(DELETE_FILE_TEXT, this::canOperateFolder, this::deleteDirectory)
                                                .simpleItem(OPEN_FILE_TEXT, () -> PackUtil.openPack(this.folderPack))
                                                .simpleItem(OPEN_PARENT_TEXT, () -> PackUtil.openParent(this.folderPack))
                                        )
                                )
                        ),
                mouseX,
                mouseY
        );
    }

    private boolean canOperateFolder() {
        return ObjectsUtil.testNullable(this.folderPack, this.fileOps::isOperable) &&
               PackUtil.validatePackPath(this.folderPack) != null;
    }

    private void renameDirectory() {
        if (this.folderPack != null) {
            this.sendEvent(new FileRenameOpenEvent(this.root(), this.folderPack));
        }
    }

    private void deleteDirectory() {
        if (this.fileOps.deletePack(this.folderPack)) {
            this.setOpen(false);
            this.root().remove(this.folderPack);
            this.sendEvent(new FileDeleteEvent(this.root()));
        }
    }

    public void onRename(class_3288 pack, class_2561 newName) {
        if (this.parent != null && pack == this.folderPack) {
            PackList.Entry entry = this.parent.getEntry(this.folderPack);
            if (entry != null) {
                entry.onRename(newName);
            }
            this.setOpen(false);
        }
    }

    private void sendEvent(PackListEvent event) {
        this.listener.onEvent(event);
    }
}
