package io.github.fishstiz.packed_packs.gui.layouts;

import io.github.fishstiz.fidgetz.gui.components.FidgetzText;
import io.github.fishstiz.fidgetz.gui.components.ToggleButton;
import io.github.fishstiz.fidgetz.gui.layouts.Layouts;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.minecraft.class_11467;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8133;
import net.minecraft.class_8667;

public class OptionsLayout implements class_8133 {
    private static final int CONTENT_WIDTH = 200;
    private final IntSupplier maxHeightSupplier;
    private final class_11467 layout;

    public OptionsLayout(class_310 minecraft, IntSupplier maxHeightSupplier, Config.Packs... configs) {
        this.maxHeightSupplier = maxHeightSupplier;
        final int spacing = GuiConstants.SPACING;
        final LinearLayout contentLayout = LinearLayout.vertical().spacing(spacing);
        final LayoutSettings titleSettings = LayoutSettings.defaults()
                .paddingTop(-(spacing / 2))
                .paddingBottom(-spacing);

        for (Config.Packs config : configs) {
            switch (config) {
                case Config.ResourcePacks resourcePacks -> {
                    contentLayout.addChild(
                            FidgetzText.<Void>builder()
                                    .setMessage(ResourceUtil.getText("resource_packs"))
                                    .setWidth(CONTENT_WIDTH)
                                    .build(),
                            titleSettings
                    );
                    addCommonOptions(contentLayout, resourcePacks);
                    contentLayout.addChild(
                            ToggleButton.<Void>builder()
                                    .setMessage(ResourceUtil.getText("options.apply_on_close"))
                                    .setValue(resourcePacks.isApplyOnClose())
                                    .setOnPress(() -> resourcePacks.setApplyOnClose(!resourcePacks.isApplyOnClose()))
                                    .setWidth(CONTENT_WIDTH)
                                    .build()
                    );
                }
                case Config.DataPacks dataPacks -> {
                    contentLayout.addChild(
                            FidgetzText.<Void>builder()
                                    .setMessage(Component.translatable("selectWorld.dataPacks"))
                                    .setWidth(CONTENT_WIDTH)
                                    .build(),
                            titleSettings
                    );
                    addCommonOptions(contentLayout, dataPacks);
                }
            }
        }

        this.layout = Layouts.unpaddedScrollableLayout(minecraft, contentLayout);
    }

    public OptionsLayout(class_310 minecraft, IntSupplier maxHeightSupplier) {
        this(minecraft, maxHeightSupplier, Config.get().getResourcepacks(), Config.get().getDatapacks());
    }


    @Override
    public void method_48206(Consumer<class_339> visitor) {
        this.layout.method_48206(visitor);
    }

    @Override
    public void method_48227(Consumer<class_8021> visitor) {
        this.layout.method_48227(visitor);
    }

    @Override
    public void method_46421(int x) {
        this.layout.method_46421(x);
    }

    @Override
    public void method_46419(int y) {
        this.layout.method_46419(y);
    }

    @Override
    public int method_46426() {
        return this.layout.method_46426();
    }

    @Override
    public int method_46427() {
        return this.layout.method_46427();
    }

    @Override
    public int method_25368() {
        return this.layout.method_25368();
    }

    @Override
    public int method_25364() {
        return this.layout.method_25364();
    }

    @Override
    public void method_48222() {
        this.layout.method_71807(this.maxHeightSupplier.getAsInt());
        this.layout.method_48222();
    }

    private static void addCommonOptions(class_8667 linearLayout, Config.Packs config) {
        linearLayout.method_52736(
                ToggleButton.<Void>builder()
                        .setMessage(ResourceUtil.getText("options.replace_screen"))
                        .setValue(config.isReplaceOriginal())
                        .setOnPress(() -> config.setReplaceOriginal(!config.isReplaceOriginal()))
                        .setWidth(CONTENT_WIDTH)
                        .build()
        );
        linearLayout.method_52736(
                ToggleButton.<Void>builder()
                        .setMessage(ResourceUtil.getText("options.hide_incompatible_warnings"))
                        .setTooltip(class_7919.method_47407(ResourceUtil.getText("options.hide_incompatible_warnings.info")))
                        .setValue(config.isIncompatibleWarningsHidden())
                        .setOnPress(() -> config.setHideIncompatibleWarnings(!config.isIncompatibleWarningsHidden()))
                        .setWidth(CONTENT_WIDTH)
                        .build()
        );
        linearLayout.method_52736(
                ToggleButton.<Void>builder()
                        .setMessage(ResourceUtil.getText("options.remember_last_viewed_profile"))
                        .setValue(config.isLastViewedProfileRemembered())
                        .setOnPress(() -> config.setRememberLastViewedProfile(!config.isLastViewedProfileRemembered()))
                        .setWidth(CONTENT_WIDTH)
                        .build()
        );
    }
}
