package io.github.fishstiz.packed_packs.util;

import static net.minecraft.class_3675.*;

import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_310;

public class InputUtil {
    public static final String DEV_MODE_SHORTCUT = "CTRL + SHIFT + I";
    public static final long DOUBLE_CLICK_THRESHOLD_MS = 250;
    public static final int MOUSE_BUTTON_BACK = 3;
    public static final int MOUSE_BUTTON_FORWARD = 4;

    private InputUtil() {
    }

    public static boolean isLeftClick(class_11909 mouseEvent) {
        return mouseEvent.method_74245() == field_32000;
    }

    public static boolean isRightClick(class_11909 mouseEvent) {
        return mouseEvent.method_74245() == field_32002;
    }

    public static boolean isClickBack(class_11909 mouseEvent) {
        return mouseEvent.method_74245() == MOUSE_BUTTON_BACK;
    }

    public static boolean isClickForward(class_11909 mouseEvent) {
        return mouseEvent.method_74245() == MOUSE_BUTTON_FORWARD;
    }

    public static boolean isUndo(class_11908 keyEvent) {
        return keyEvent.comp_4795() == field_31915 && keyEvent.method_74240() && keyEvent.comp_4797() == field_32003;
    }

    public static boolean isRedo(class_11908 keyEvent) {
        if (keyEvent.comp_4795() == field_31915) {
            return keyEvent.method_74240() && keyEvent.method_74239() && keyEvent.comp_4797() == field_32003 + field_62548;
        } else if (keyEvent.comp_4795() == field_31914) {
            return keyEvent.method_74240() && keyEvent.comp_4797() == field_32003;
        }

        return false;
    }

    public static boolean isTransfer(class_11908 keyEvent) {
        return noModifiers(keyEvent.comp_4797()) && (keyEvent.comp_4795() == field_31947 || keyEvent.comp_4795() == field_31957);
    }

    public static boolean isMoveDown(class_11908 keyEvent) {
        return keyEvent.comp_4795() == field_31982 && moveModifiers(keyEvent.comp_4797());
    }

    public static boolean isMoveUp(class_11908 keyEvent) {
        return keyEvent.comp_4795() == field_31932 && moveModifiers(keyEvent.comp_4797());
    }

    public static boolean isExpandFolder(class_11908 keyEvent) {
        return noModifiers(keyEvent.comp_4797()) && keyEvent.comp_4795() == field_31957;
    }

    public static boolean isDelete(class_11908 keyEvent) {
        return noModifiers(keyEvent.comp_4797()) && keyEvent.comp_4795() == field_31987;
    }

    public static boolean isRename(class_11908 keyEvent) {
        return (noModifiers(keyEvent.comp_4797()) && keyEvent.comp_4795() == field_31917) ||
               (keyEvent.comp_4797() == field_32003 && keyEvent.comp_4795() == field_31907);
    }

    public static boolean isRefresh(class_11908 keyEvent) {
        return noModifiers(keyEvent.comp_4797()) && keyEvent.comp_4795() == field_31920;
    }

    public static boolean isOpenFile(class_11908 keyEvent) {
        return keyEvent.comp_4797() == field_32003 && keyEvent.comp_4795() == field_31957;
    }

    public static boolean isOpenFolder(class_11908 keyEvent) {
        return keyEvent.comp_4797() == field_62549 + field_62548 && keyEvent.comp_4795() == field_31907;
    }

    public static boolean isDeveloperMode(class_11908 keyEvent) {
        return noModifiers(keyEvent.comp_4797()) && keyEvent.comp_4795() == field_31927 ||
               keyEvent.comp_4797() == field_32003 + field_62548 && keyEvent.comp_4795() == field_32023;
    }

    public static boolean isSelectAll(class_11908 keyEvent) {
        return keyEvent.comp_4797() == field_32003 && keyEvent.comp_4795() == field_32015;
    }

    public static boolean isSwitchDefaultProfile(class_11908 keyEvent) {
        return noModifiers(keyEvent.comp_4797()) && keyEvent.comp_4795() == field_31916;
    }

    public static boolean isOpenProfiles(class_11908 keyEvent) {
        return keyEvent.comp_4797() == field_32003 && keyEvent.comp_4795() == field_31938;
    }

    public static boolean noModifiers(int modifiers) {
        return modifiers == 0;
    }

    public static boolean moveModifiers(int modifiers) {
        return modifiers == field_32003 || modifiers == field_62549;
    }

    public static boolean isRangeModifierActive() {
        return class_310.method_1551().method_74187();
    }

    public static boolean isSelectModifierActive() {
        return class_310.method_1551().method_74188();
    }
}
