/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.components.AbstractFixedListWidget;
import io.github.fishstiz.fidgetz.gui.components.AbstractWidgetBuilder;
import io.github.fishstiz.fidgetz.gui.components.ContainerEventHandlerPatch;
import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuContainer;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.util.DrawUtil;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import io.github.fishstiz.fidgetz.util.lang.ObjectsUtil;
import io.github.fishstiz.packed_packs.compat.ModAdditions;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.Preferences;
import io.github.fishstiz.packed_packs.gui.components.MouseSelectionHandler;
import io.github.fishstiz.packed_packs.gui.components.SelectionContext;
import io.github.fishstiz.packed_packs.gui.components.ToggleableHelper;
import io.github.fishstiz.packed_packs.gui.components.contextmenu.PackMenuHeader;
import io.github.fishstiz.packed_packs.gui.components.events.DragEvent;
import io.github.fishstiz.packed_packs.gui.components.events.DropEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FileDeleteEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FileRenameOpenEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FolderOpenEvent;
import io.github.fishstiz.packed_packs.gui.components.events.MoveEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackAliasOpenEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.gui.components.events.RequestTransferEvent;
import io.github.fishstiz.packed_packs.gui.components.events.SelectionEvent;
import io.github.fishstiz.packed_packs.gui.components.pack.PackListDevMenu;
import io.github.fishstiz.packed_packs.gui.components.pack.PackListModel;
import io.github.fishstiz.packed_packs.gui.components.pack.PackWidget;
import io.github.fishstiz.packed_packs.gui.components.pack.Query;
import io.github.fishstiz.packed_packs.gui.history.Restorable;
import io.github.fishstiz.packed_packs.pack.PackAssetManager;
import io.github.fishstiz.packed_packs.pack.PackFileOperations;
import io.github.fishstiz.packed_packs.pack.PackOptionsContext;
import io.github.fishstiz.packed_packs.pack.folder.FolderPack;
import io.github.fishstiz.packed_packs.transform.interfaces.FilePack;
import io.github.fishstiz.packed_packs.util.InputUtil;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.ToastUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PackList
extends AbstractFixedListWidget<Entry>
implements Restorable<Snapshot>,
ContainerEventHandlerPatch,
ContextMenuContainer {
    protected static final int Y_OFFSET = 1;
    protected static final int ITEM_HEIGHT = 35;
    protected static final int ROW_GAP = 3;
    protected final PackOptionsContext options;
    protected final PackAssetManager assets;
    protected final PackListModel list;
    private final PackFileOperations fileOps;
    private final PackListEventListener listener;

    protected PackList(PackOptionsContext options, PackAssetManager assets, PackFileOperations fileOps, PackListEventListener listener) {
        super(35);
        this.assets = assets;
        this.options = options;
        this.fileOps = fileOps;
        this.listener = listener;
        this.list = new PackListModel(this.options);
    }

    @NotNull
    protected abstract Entry createEntry(SelectionContext<class_3288> var1, int var2);

    @Nullable
    public Entry getEntry(@Nullable class_3288 pack) {
        if (pack == null) {
            return null;
        }
        for (Entry entry : this.method_25396()) {
            if (!Objects.equals(entry.pack(), pack)) continue;
            return entry;
        }
        return null;
    }

    private void refreshEntries() {
        Entry focused = (Entry)this.method_25336();
        List selection = this.list.getSelection();
        List visiblePacks = this.list.getVisibleItems();
        this.method_25339();
        for (int i = 0; i < visiblePacks.size(); ++i) {
            this.method_25321((class_350.class_351)this.createEntry(new SelectionContext<class_3288>(selection, (class_3288)visiblePacks.get(i)), i));
        }
        this.clampScrollAmount();
        this.method_25395((class_364)ObjectsUtil.mapOrNull(focused, f -> this.getEntry(f.pack())));
    }

    protected void refreshList() {
        this.list.refresh();
        this.refreshEntries();
    }

    public void scrollToTop() {
        this.method_44382(0.0);
    }

    public void reload(Collection<class_3288> packs) {
        this.list.replaceAll(packs);
        this.method_25395(null);
        this.refresh();
    }

    @NotNull
    public List<class_3288> copyPacks() {
        return List.copyOf(this.list.getItems());
    }

    public List<class_3288> getOrderedSelection() {
        return this.list.getOrderedSelection();
    }

    public void clearSelection() {
        this.list.clearSelection();
    }

    private void refresh() {
        this.clearSelection();
        this.refreshList();
        this.scrollToTop();
    }

    public void sort(Query.SortOption sort) {
        if (this.list.sort(sort)) {
            this.refresh();
        }
    }

    public void hideIncompatible(boolean hideIncompatible) {
        if (this.list.hideIncompatible(hideIncompatible)) {
            this.clearSelection();
            this.refreshList();
        }
    }

    public void search(@NotNull String search) {
        if (this.list.search(search)) {
            this.refresh();
        }
    }

    public boolean isQueried() {
        return this.list.isQueried();
    }

    public void addAll(List<class_3288> packs) {
        for (class_3288 pack : packs) {
            this.list.add(pack);
        }
        this.refreshList();
    }

    public void addOrMove(class_3288 pack, int to) {
        this.list.insertOrMove(to, pack);
        this.list.select(pack);
    }

    public boolean moveAll(List<class_3288> selection, int to) {
        if (this.list.moveAll(to, selection)) {
            this.refreshList();
            return true;
        }
        return true;
    }

    private boolean removePack(class_3288 pack) {
        Entry focused = (Entry)this.method_25336();
        if (this.list.remove(pack)) {
            if (focused != null && focused.pack().method_14463().equals(pack.method_14463())) {
                this.method_25395(null);
            }
            return true;
        }
        return false;
    }

    public void remove(class_3288 pack) {
        this.removePack(pack);
        this.refreshList();
    }

    public void removeAll(List<class_3288> packs) {
        boolean removed = false;
        for (class_3288 pack : packs) {
            removed |= this.removePack(pack);
        }
        if (removed) {
            this.refreshList();
        }
    }

    @Nullable
    public class_3288 getLastSelected() {
        return (class_3288)this.list.getLastSelected();
    }

    @Nullable
    public Entry getSelected() {
        return this.getLastSelected() != null ? this.getEntry(this.getLastSelected()) : (Entry)super.method_25334();
    }

    public void setSelected(@Nullable Entry selected) {
        this.field_22751 = selected;
    }

    public boolean isSelected(class_3288 pack) {
        return this.list.isSelected(pack);
    }

    public void scrollToLastSelected() {
        ObjectsUtil.ifPresent(this.getEntry(this.getLastSelected()), x$0 -> this.method_73377((class_350.class_351)x$0));
    }

    public void unselect(class_3288 pack) {
        this.list.unselect(pack);
        Entry entry = this.getEntry(pack);
        if (entry == this.method_25336()) {
            this.method_25395(null);
        }
        if (entry == this.getSelected()) {
            this.setSelected(null);
        }
    }

    public void select(class_3288 pack) {
        if (this.list.select(pack)) {
            Entry entry = this.getEntry(pack);
            this.method_25395((class_364)entry);
            this.setSelected(entry);
        }
    }

    public void selectAll() {
        this.list.getVisibleItems().forEach(this::select);
    }

    public void selectAll(List<class_3288> packs) {
        packs.forEach(this::select);
    }

    public void selectExclusive(class_3288 pack) {
        this.clearSelection();
        this.select(pack);
    }

    public void selectToggle(class_3288 pack) {
        if (this.isSelected(pack)) {
            this.unselect(pack);
        } else {
            this.select(pack);
        }
    }

    public void selectRange(class_3288 pack) {
        this.list.selectRange(pack);
        this.select(pack);
    }

    public boolean isTransferable(class_3288 pack) {
        return ObjectsUtil.testNullable(this.getEntry(pack), Entry::isTransferable);
    }

    public void transferAll() {
        ArrayList<class_3288> payload = new ArrayList<class_3288>();
        List visiblePacks = this.list.getVisibleItems();
        for (int i = visiblePacks.size() - 1; i >= 0; --i) {
            class_3288 pack = (class_3288)visiblePacks.get(i);
            if (!this.isTransferable(pack)) continue;
            payload.add(pack);
        }
        if (!payload.isEmpty()) {
            this.sendEvent(new RequestTransferEvent(this, this.getLastSelected(), payload));
        }
    }

    protected void sendEvent(PackListEvent event) {
        this.listener.onEvent(event);
    }

    public abstract boolean canInteract(PackList var1);

    protected abstract boolean canDrop(DragEvent var1, double var2, double var4);

    protected abstract List<class_3288> handleDrop(DragEvent var1, double var2, double var4);

    public abstract void renderDroppableZone(class_332 var1, DragEvent var2, int var3, int var4, float var5);

    public final void drop(DragEvent dragEvent, double mouseX, double mouseY) {
        if (this.options.isLocked()) {
            return;
        }
        List<class_3288> dropped = this.handleDrop(dragEvent, mouseX, mouseY);
        if (!dropped.isEmpty()) {
            if (dragEvent.target() != this) {
                this.sendEvent(new DropEvent(dragEvent.target(), this, dropped));
            } else {
                this.sendEvent(new MoveEvent(this, dragEvent.trigger(), dropped));
            }
        }
    }

    protected void openFolder(FolderPack folderPack) {
        this.sendEvent(new FolderOpenEvent(this, folderPack));
    }

    @Nullable
    private class_8016 handleArrowNavigation(class_8023.class_8024 arrowNavigation) {
        Entry entry;
        switch (arrowNavigation.comp_1191()) {
            case field_41826: {
                Entry entry2 = (Entry)this.getPreviousEntry();
                break;
            }
            case field_41827: {
                Entry entry2 = (Entry)this.getNextEntry();
                break;
            }
            default: {
                Entry entry2 = entry = null;
            }
        }
        if (entry != null) {
            if (InputUtil.isRangeModifierActive()) {
                this.selectRange(entry.pack());
            } else {
                this.selectExclusive(entry.pack());
            }
            this.sendEvent(new SelectionEvent(this));
            this.method_73377((class_350.class_351)entry);
            return class_8016.method_48194((class_364)entry, (class_4069[])new class_4069[]{this});
        }
        this.method_25395(null);
        return null;
    }

    @Nullable
    public class_8016 method_48205(class_8023 event) {
        if (!this.method_25370()) {
            class_3288 lastSelected = this.getLastSelected();
            Entry entry = null;
            if (lastSelected != null) {
                entry = this.getEntry(lastSelected);
            } else if (!this.method_25396().isEmpty()) {
                entry = (Entry)this.method_25396().getFirst();
            }
            if (entry != null) {
                this.select(entry.pack());
                this.method_73377((class_350.class_351)entry);
                return class_8016.method_48194((class_364)entry, (class_4069[])new class_4069[]{this});
            }
        } else {
            if (event instanceof class_8023.class_8024) {
                class_8023.class_8024 arrowNavigation = (class_8023.class_8024)event;
                return this.handleArrowNavigation(arrowNavigation);
            }
            this.method_25395(null);
        }
        return null;
    }

    public boolean method_25404(class_11908 keyEvent) {
        Entry entry = this.getEntry(this.getLastSelected());
        if (InputUtil.isExpandFolder(keyEvent) && entry != null && entry.folderWidget != null && this.list.getSelection().size() == 1) {
            this.openFolder(entry.folderWidget.getMetadata());
            return true;
        }
        if (InputUtil.isTransfer(keyEvent)) {
            if (entry != null && entry.transfer()) {
                GuiUtil.playClickSound();
            }
            return entry != null;
        }
        return super.method_25404(keyEvent);
    }

    @Override
    public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClicked) {
        boolean scrolling = this.method_65505(mouseButtonEvent);
        return this.method_25405(mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799()) && ContainerEventHandlerPatch.super.mouseClickedAt(mouseButtonEvent, doubleClicked) || scrolling;
    }

    protected void method_25311(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25311(guiGraphics, mouseX, mouseY, partialTick);
        Entry focused = (Entry)this.method_25336();
        if (focused != null && focused.method_25370() && this.method_25396().contains(focused)) {
            int outlineTop = focused.method_46427();
            int outlineHeight = focused.method_25364() + 1;
            DrawUtil.renderOutline(guiGraphics, focused.method_46426(), outlineTop, focused.method_25368(), outlineHeight, Theme.WHITE.getARGB());
        }
    }

    public int method_44390() {
        int maxScrollAmount = super.method_44390();
        return maxScrollAmount > 0 ? maxScrollAmount + 1 : maxScrollAmount;
    }

    @Override
    @NotNull
    public Snapshot captureState(String eventName) {
        return new Snapshot(this);
    }

    @Override
    public void replaceState(@NotNull Snapshot snapshot) {
        snapshot.model.restore();
        this.refreshEntries();
        this.method_25395((class_364)this.getEntry(snapshot.focused));
        this.setSelected(this.getEntry(snapshot.selected));
    }

    @Nullable
    private static class_3288 extractPack(@Nullable Entry entry) {
        return ObjectsUtil.mapOrNull(entry, Entry::pack);
    }

    public abstract class Entry
    extends AbstractFixedListWidget.Entry
    implements ContainerEventHandlerPatch,
    ContextMenuContainer {
        private static final int V_MARGIN = 2;
        private static final int BACKGROUND_MARGIN = 1;
        private static final class_7919 FOLDER_OPEN_INFO = class_7919.method_47407((class_2561)FolderPack.FOLDER_OPEN_TEXT);
        protected static final int H_SPACING = 2;
        protected static final ColoredRect SELECTED_OVERLAY = new ColoredRect(Theme.BLUE_500.withAlpha(0.25f));
        protected final SelectionContext<class_3288> context;
        private final List<class_364> children;
        private final List<class_4068> renderables;
        private final List<class_4068> topRenderables;
        private final List<class_6379> narratables;
        private final MouseSelectionHandler<class_3288> selectionHandler;
        private final PackWidget packWidget;
        @Nullable
        private final PackListDevMenu devMenu;
        private FidgetzButton<FolderPack> folderWidget;
        private boolean stale;

        protected Entry(SelectionContext<class_3288> context, int index) {
            super(index);
            this.children = new ObjectArrayList();
            this.renderables = new ObjectArrayList();
            this.topRenderables = new ObjectArrayList();
            this.narratables = new ObjectArrayList();
            this.stale = false;
            this.context = context;
            this.selectionHandler = new MouseSelectionHandler<class_3288>((class_364)this, context);
            this.packWidget = this.addRenderableWidget(new PackWidget(this.pack(), PackList.this.assets, this.method_46426(), PackList.this.method_25337(this.index), this.method_25368(), 32, 2));
            boolean devMode = Config.get().isDevMode();
            class_3288 class_32882 = this.pack();
            if (class_32882 instanceof FolderPack) {
                FolderPack folderPack = (FolderPack)class_32882;
                if (devMode || Preferences.INSTANCE.folderPackWidget.get().booleanValue()) {
                    this.folderWidget = this.addTopRenderableOnly((class_4068)this.prependWidget(((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((AbstractWidgetBuilder)ToggleableHelper.applyPref(Preferences.INSTANCE.folderPackWidget, FidgetzButton.builder()).setTooltip(FOLDER_OPEN_INFO)).setHeight(this.packWidget.method_25364() / 3)).makeSquare()).setSprite(GuiConstants.HAMBURGER_SPRITE)).setFocusOnInteract(false)).setMetadata((FolderPack)folderPack)).setOnPress(this::openFolder)).build()));
                }
            }
            this.devMenu = devMode ? new PackListDevMenu(PackList.this.field_22740, PackList.this.options, this.context, this::handleDevMenuEvent) : null;
            ModAdditions.onCreateEntry(PackList.this.options.getConfig().packType(), this);
        }

        public class_3288 pack() {
            return this.context.item();
        }

        public <U extends class_364 & class_4068> U addRenderableWidget(U widget) {
            this.children.add(widget);
            this.renderables.add(widget);
            if (widget instanceof class_6379) {
                class_6379 narratable = (class_6379)widget;
                this.narratables.add(narratable);
            }
            return widget;
        }

        public <U extends class_364> U prependWidget(U widget) {
            this.children.addFirst(widget);
            if (widget instanceof class_6379) {
                class_6379 narratable = (class_6379)widget;
                this.narratables.add(narratable);
            }
            return widget;
        }

        public <U extends class_4068> U addTopRenderableOnly(U renderable) {
            this.topRenderables.add(renderable);
            return renderable;
        }

        public boolean isTransferable() {
            return !PackList.this.options.isLocked() && !this.isStale();
        }

        public boolean isSelected() {
            return this.context.isSelected();
        }

        public boolean isSelectedLast() {
            return this.context.isSelectedLast();
        }

        protected void sendPacks(class_3288 trigger, List<class_3288> payload) {
            PackList.this.sendEvent(new RequestTransferEvent(PackList.this, trigger, payload));
        }

        private boolean sendSelection() {
            ObjectArrayList payload = new ObjectArrayList();
            for (class_3288 selected : PackList.this.getOrderedSelection().reversed()) {
                if (!PackList.this.isTransferable(selected)) continue;
                payload.add(selected);
            }
            if (!payload.isEmpty()) {
                class_3288 trigger = this.isTransferable() ? this.pack() : null;
                this.sendPacks(trigger, (List<class_3288>)payload);
                return true;
            }
            return false;
        }

        public boolean transfer() {
            if (!this.isSelected() && this.isTransferable()) {
                PackList.this.sendEvent(new RequestTransferEvent(PackList.this, this.pack()));
                return true;
            }
            return this.sendSelection();
        }

        protected boolean handleMouseAction(MouseSelectionHandler.Action action) {
            if (!action.shouldDispatch() || this.isStale()) {
                return false;
            }
            switch (action) {
                case SELECT: {
                    PackList.this.select(this.pack());
                    break;
                }
                case SELECT_TOGGLE: {
                    PackList.this.selectToggle(this.pack());
                    break;
                }
                case SELECT_EXCLUSIVE: {
                    PackList.this.selectExclusive(this.pack());
                    break;
                }
                case SELECT_RANGE: {
                    PackList.this.selectRange(this.pack());
                    break;
                }
                case TRANSFER: {
                    if (!this.isTransferable()) break;
                    PackList.this.sendEvent(new RequestTransferEvent(PackList.this, this.pack()));
                    return false;
                }
                case DRAG: {
                    PackList.this.sendEvent(new DragEvent(PackList.this, (List<class_3288>)PackList.this.getOrderedSelection().reversed(), this.pack()));
                }
            }
            if (action.shouldSelect()) {
                PackList.this.sendEvent(new SelectionEvent(PackList.this));
            }
            return true;
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            return PackList.this.beforeScrollbarX(mouseX) && super.method_25405(mouseX, mouseY);
        }

        @Override
        public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClicked) {
            if (ContainerEventHandlerPatch.super.method_25402(mouseButtonEvent, doubleClicked)) {
                return false;
            }
            return this.handleMouseAction(this.selectionHandler.mouseClicked(mouseButtonEvent));
        }

        public boolean method_25406(class_11909 mouseButtonEvent) {
            return this.handleMouseAction(this.selectionHandler.mouseReleased(mouseButtonEvent));
        }

        public boolean method_25403(class_11909 mouseButtonEvent, double dragX, double dragY) {
            return this.handleMouseAction(this.selectionHandler.mouseDragged(mouseButtonEvent, dragX, dragY));
        }

        public boolean method_25404(class_11908 keyEvent) {
            if (super.method_25404(keyEvent)) {
                return true;
            }
            if (InputUtil.isOpenFile(keyEvent)) {
                PackUtil.openPack(this.pack());
                return true;
            }
            if (InputUtil.isOpenFolder(keyEvent)) {
                PackUtil.openParent(this.pack());
                return true;
            }
            if (InputUtil.isDelete(keyEvent) && this.canOperateFile()) {
                this.deletePack();
                return true;
            }
            if (InputUtil.isRename(keyEvent) && this.canOperateFile()) {
                this.renamePack();
                return true;
            }
            return false;
        }

        public void renderBack(class_332 guiGraphics, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (!this.pack().method_14460().method_14437() && !PackList.this.options.getUserConfig().isIncompatibleWarningsHidden()) {
                int backgroundLeft = left + 1;
                int backgroundTop = top + 1;
                int backgroundRight = backgroundLeft + width - 2;
                int backgroundBottom = backgroundTop + height - 1;
                guiGraphics.method_25294(backgroundLeft, backgroundTop, backgroundRight, backgroundBottom, Theme.RED_900.getARGB());
            }
        }

        protected abstract void renderForeground(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

        private void renderSelection(class_332 guiGraphics, int top, int left, int width, int height) {
            if (this.isSelected()) {
                ObjectsUtil.pick(this.isSelectedLast(), GuiConstants.WHITE_OVERLAY, SELECTED_OVERLAY).render(guiGraphics, left, top, width, height);
                DrawUtil.renderOutline(guiGraphics, left, top, width, height, Theme.BLUE_500.getARGB());
            }
        }

        protected void renderTop(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.folderWidget != null) {
                int folderWidgetY = this.getBottom() - this.folderWidget.method_25364() - 1;
                this.folderWidget.method_48229(this.packWidget.getContentLeft(), folderWidgetY);
            }
            for (class_4068 renderable : this.topRenderables) {
                renderable.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            hovering = hovering && PackList.this.beforeScrollbarX(mouseX) && GuiUtil.isHovered((class_364)this, mouseX, mouseY);
            int left = this.method_46426();
            int top = this.method_46427();
            int width = this.method_25368();
            int height = this.method_25364();
            int innerTop = top + 2;
            int innerHeight = height - 3;
            this.packWidget.method_48229(left, innerTop);
            this.packWidget.method_25358(width);
            this.renderBack(guiGraphics, top, left, width, height, mouseX, mouseY, hovering, partialTick);
            for (class_4068 renderable : this.renderables) {
                renderable.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }
            this.renderSelection(guiGraphics, top, left, width, height + 1);
            this.renderForeground(guiGraphics, innerTop, left, width, innerHeight, mouseX, mouseY, hovering, partialTick);
            this.renderTop(guiGraphics, mouseX, mouseY, partialTick);
            if (this.devMenu != null) {
                this.devMenu.renderDevSprites(guiGraphics, innerTop, left, width);
            }
        }

        protected void handleDevMenuEvent(PackListDevMenu.Event<?> event) {
            if (event instanceof PackListDevMenu.Event.EditAliases) {
                PackListDevMenu.Event.EditAliases editAliases = (PackListDevMenu.Event.EditAliases)event;
                PackList.this.sendEvent(new PackAliasOpenEvent(PackList.this, editAliases.trigger()));
            }
        }

        @Override
        public void buildItems(ContextMenuItemBuilder builder, int mouseX, int mouseY) {
            PackList.this.method_25395((class_364)this);
            ContextMenuContainer.super.buildItems(builder.add(new PackMenuHeader(this.pack(), this.packWidget.getSprite())).whenNonNull(this.devMenu).ifTrue(PackListDevMenu::onBuildHeader).whenNonNull((PackListDevMenu)((Object)this.folderWidget)).ifTrue(b -> b.simpleItem(FolderPack.FOLDER_OPEN_TEXT, this::openFolder).separator()).whenNonNull(((FilePack)this.pack()).packed_packs$getPath()).ifTrue(b -> b.simpleItem(GuiConstants.RENAME_FILE_TEXT, this::canOperateFile, this::renamePack).simpleItem(GuiConstants.DELETE_FILE_TEXT, this::canOperateFile, this::deletePack).simpleItem(GuiConstants.OPEN_FILE_TEXT, () -> PackUtil.openPack(this.pack())).simpleItem(GuiConstants.OPEN_PARENT_TEXT, () -> PackUtil.openParent(this.pack()))), mouseX, mouseY);
        }

        private void openFolder() {
            PackList.this.openFolder(Objects.requireNonNull(this.folderWidget, "Cannot open folder without folder widget").getMetadata());
        }

        public boolean canOperateFile() {
            return PackList.this.fileOps.isOperable(this.pack());
        }

        public void deletePack() {
            if (PackList.this.fileOps.deletePack(this.pack())) {
                this.stale = true;
                PackList.this.remove(this.pack());
                PackList.this.sendEvent(new FileDeleteEvent(PackList.this));
            } else {
                ToastUtil.onFileFailToast(ToastUtil.getDeleteFailText(this.pack().method_14457().getString()));
            }
        }

        public void renamePack() {
            PackList.this.sendEvent(new FileRenameOpenEvent(PackList.this, this.pack()));
        }

        public void onRename(class_2561 newName) {
            this.stale = true;
            this.packWidget.onRename(newName);
            if (this.folderWidget != null) {
                this.folderWidget.field_22763 = false;
            }
        }

        public boolean isStale() {
            return this.stale;
        }

        @NotNull
        public List<class_364> method_25396() {
            return this.children;
        }

        @NotNull
        public List<class_6379> method_37025() {
            return this.narratables;
        }
    }

    public static final class Snapshot
    extends Record
    implements Restorable.Snapshot<Snapshot> {
        private final PackList target;
        @Nullable
        private final class_3288 focused;
        @Nullable
        private final class_3288 selected;
        private final PackListModel.Snapshot model;

        public Snapshot(PackList target, PackListModel.Snapshot model) {
            this(target, PackList.extractPack((Entry)target.method_25336()), PackList.extractPack(target.getSelected()), model);
        }

        public Snapshot(PackList target) {
            this(target, (PackListModel.Snapshot)target.list.captureState());
        }

        public Snapshot(PackList target, @Nullable class_3288 focused, @Nullable class_3288 selected, PackListModel.Snapshot model) {
            this.target = target;
            this.focused = focused;
            this.selected = selected;
            this.model = model;
        }

        public Snapshot replaceAll(List<class_3288> packs) {
            return new Snapshot(this.target, this.focused, this.selected, this.model.replaceAll(packs));
        }

        public Snapshot retainAll(Set<class_3288> packs) {
            return new Snapshot(this.target, this.focused, this.selected, this.model.retainAll(packs));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Snapshot.class, "target;focused;selected;model", "target", "focused", "selected", "model"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Snapshot.class, "target;focused;selected;model", "target", "focused", "selected", "model"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Snapshot.class, "target;focused;selected;model", "target", "focused", "selected", "model"}, this, o);
        }

        public PackList target() {
            return this.target;
        }

        @Nullable
        public class_3288 focused() {
            return this.focused;
        }

        @Nullable
        public class_3288 selected() {
            return this.selected;
        }

        public PackListModel.Snapshot model() {
            return this.model;
        }
    }
}

