/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.layouts;

import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.LayoutWrapper;
import io.github.fishstiz.fidgetz.gui.components.ToggleableEditBox;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.ButtonSprites;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.DevConfig;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.gui.components.profile.ProfileList;
import io.github.fishstiz.packed_packs.gui.components.profile.Sidebar;
import io.github.fishstiz.packed_packs.gui.screens.WidgetFactory;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import java.util.function.BiConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class ProfilesLayout {
    public static final class_2561 TITLE_TEXT = ResourceUtil.getText("profile", new Object[0]);
    private static final class_2561 NO_PROFILE_TEXT = ResourceUtil.getText("profile.none", new Object[0]);
    private static final class_2561 UNNAMED_TEXT = ResourceUtil.getText("profile.unnamed", new Object[0]);
    private static final class_2561 COPY_TEXT = ResourceUtil.getText("profile.copy", new Object[0]);
    private static final int MAX_WIDTH = 160;
    private final Config.Packs userConfig;
    private final DevConfig.Packs config;
    private final BiConsumer<Profile, Profile> copyListener;
    private final ButtonSprites toggleSprites;
    private final Sidebar sidebar;
    private final ProfileList profileList;
    private ToggleableEditBox<Void> nameField;
    private FidgetzButton<Void> toggleNameButton;
    private FidgetzButton<Void> noProfileButton;
    private boolean initialized = false;

    public <S extends class_437> ProfilesLayout(S screen, Config.Packs userConfig, DevConfig.Packs config, BiConsumer<Profile, Profile> selectListener, BiConsumer<Profile, Profile> copyListener) {
        this.userConfig = userConfig;
        this.config = config;
        this.copyListener = copyListener;
        this.toggleSprites = new ButtonSprites(Sprite.of16(ResourceUtil.getIcon("edit")), Sprite.of16(ResourceUtil.getIcon("edit_inactive")));
        WidgetFactory.ProfileWidgets widgets = WidgetFactory.createProfileWidgets(screen, userConfig, config, selectListener, this::updateGuiState);
        this.sidebar = widgets.sidebar();
        this.profileList = widgets.profileList();
    }

    public void init(Runnable onClose) {
        this.nameField = ToggleableEditBox.builder().setHint(UNNAMED_TEXT).setMaxLength(32).setFilter(value -> value != null && (value.isEmpty() || !value.isBlank())).addListener(this::onNameChange).build();
        this.toggleNameButton = ((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().makeSquare()).setTooltip(class_7919.method_47407((class_2561)ResourceUtil.getText("profile.edit", new Object[0])))).setSprite(this.toggleSprites)).setOnPress(this.nameField::toggle)).build();
        FidgetzButton copyButton = ((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().setMessage((class_2561)ResourceUtil.getText("profile.new", new Object[0]))).setTooltip(class_7919.method_47407((class_2561)ResourceUtil.getText("profile.new.info", new Object[0])))).setOnPress(this::copyProfile)).build();
        this.noProfileButton = ((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().setMessage(NO_PROFILE_TEXT)).setOnPress(() -> this.setProfile(null))).build();
        FlexLayout actions = FlexLayout.horizontal(this::getMaxWidth).spacing(8);
        actions.addFlexChild(this.noProfileButton);
        actions.addFlexChild(copyButton);
        FlexLayout list = FlexLayout.horizontal(this::getMaxWidth);
        list.addFlexChild(this.profileList, true);
        this.sidebar.init(TITLE_TEXT, onClose, 160);
        ((FlexLayout)((LayoutWrapper)((Object)this.sidebar.root())).layout()).addChild(actions);
        ((FlexLayout)((LayoutWrapper)((Object)this.sidebar.root())).layout()).addFlexChild(list, true);
        ((FlexLayout)((LayoutWrapper)((Object)this.sidebar.root())).layout()).method_48206(this.sidebar::addRenderableWidget);
        this.initialized = true;
        this.updateGuiState(this.profileList.getSelectedProfile());
        this.profileList.refresh();
    }

    public int getMaxWidth() {
        return 160;
    }

    public Sidebar getSidebar() {
        return this.sidebar;
    }

    public ToggleableEditBox<Void> getNameField() {
        return this.nameField;
    }

    public FidgetzButton<Void> getToggleNameButton() {
        return this.toggleNameButton;
    }

    private void onNameChange(String value) {
        Profile profile = this.profileList.getSelectedProfile();
        if (profile != null) {
            String name = value;
            if (value.isEmpty()) {
                name = UNNAMED_TEXT.getString();
            }
            this.userConfig.renameProfile(profile, name);
        }
        this.profileList.scheduleRefresh();
    }

    private void updateGuiState(@Nullable Profile profile) {
        if (!this.initialized) {
            return;
        }
        this.nameField.method_1888(false);
        boolean hasProfile = profile != null;
        this.nameField.method_47404(hasProfile ? UNNAMED_TEXT : NO_PROFILE_TEXT);
        this.nameField.setValueSilently(hasProfile ? profile.getName() : "");
        this.nameField.field_22764 = hasProfile;
        this.nameField.field_22763 = hasProfile;
        this.noProfileButton.field_22763 = hasProfile;
        this.toggleNameButton.field_22764 = hasProfile;
        boolean bl = this.toggleNameButton.field_22763 = hasProfile && !profile.isLocked();
        if (hasProfile && profile.isLocked()) {
            Profile defaultProfile = this.config.getDefaultProfile();
            ButtonSprites sprites = profile == defaultProfile ? ButtonSprites.of(GuiConstants.STAR_SPRITE) : ButtonSprites.unclamp(GuiConstants.LOCK_SPRITE);
            this.toggleNameButton.setSprites(sprites);
        } else {
            this.toggleNameButton.setSprites(this.toggleSprites);
        }
    }

    public void setProfile(@Nullable Profile profile) {
        this.profileList.selectProfile(profile);
    }

    @Nullable
    public Profile getProfile() {
        return this.profileList.getSelectedProfile();
    }

    private void copyProfile() {
        Profile selectedProfile = this.profileList.getSelectedProfile();
        Profile copiedProfile = selectedProfile != null ? selectedProfile.copy() : new Profile(NO_PROFILE_TEXT.getString() + " - " + COPY_TEXT.getString());
        this.copyListener.accept(selectedProfile, copiedProfile);
        this.userConfig.addProfile(copiedProfile);
        this.setProfile(copiedProfile);
        this.sidebar.setOpen(false);
        this.profileList.refresh();
    }
}

