package io.github.fishstiz.packed_packs.compat.respackopts;

import io.github.fishstiz.fidgetz.gui.components.Fidgetz;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuProvider;
import io.github.fishstiz.packed_packs.compat.Mod;
import io.github.fishstiz.packed_packs.compat.PackWrapperDelegatorAbstractionEpicModelEntry;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.ModPreferences;
import io.github.fishstiz.packed_packs.gui.components.ToggleableHelper;
import io.gitlab.jfronny.libjf.entrywidgets.api.v0.ResourcePackEntryWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.repository.Pack;
import org.jetbrains.annotations.Nullable;

public class RespackoptsWidget extends AbstractButton implements ContextMenuProvider, Fidgetz {
    private final ResourcePackEntryWidget wrapped;
    private final PackSelectionModel.Entry model;
    private final LayoutElement container;
    private final @Nullable ToggleableHelper toggleable;

    private RespackoptsWidget(LayoutElement container, ResourcePackEntryWidget wrapped, PackSelectionModel.Entry model) {
        super(0, 0, 0, 0, Component.literal(Mod.RESPACKOPTS.getId()));

        this.toggleable = Config.get().isDevMode() ? new ToggleableHelper(ModPreferences.RESPACKOPTS_BUTTON.get()) : null;
        this.container = container;
        this.wrapped = wrapped;
        this.model = model;
    }

    public static @Nullable RespackoptsWidget create(LayoutElement container, Pack pack) {
        for (ResourcePackEntryWidget widget : ResourcePackEntryWidget.WIDGETS) {
            PackSelectionModel.Entry model = new PackWrapperDelegatorAbstractionEpicModelEntry(pack);
            if (widget.isVisible(model, isSelectable(pack))) {
                return new RespackoptsWidget(container, widget, model);
            }
        }
        return null;
    }

    @Override
    public void onPress() {
        this.wrapped.onClick(this.model);
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int width = this.wrapped.getWidth(this.model);
        int height = this.wrapped.getHeight(this.model, this.container.getHeight());
        int marginRight = this.wrapped.getXMargin(this.model);

        this.setWidth(width);
        this.setHeight(height);
        this.setX((this.container.getX() + this.container.getWidth()) - width - marginRight);
        this.setY(this.container.getY() + (this.container.getHeight() - height) / 2);

        this.isHovered = this.isHovered && Fidgetz.super.isMouseOver(mouseX, mouseY);

        this.wrapped.render(this.model, guiGraphics, this.getX(), this.getY(), this.isHovered, partialTick);

        if (this.toggleable != null) {
            this.toggleable.render(guiGraphics, this.getX(), this.getY(), this.getWidth(), this.getHeight(), partialTick);
        }
    }

    @Override
    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        // unsupported
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return super.isMouseOver(mouseX, mouseY) && Fidgetz.super.isMouseOver(mouseX, mouseY);
    }

    /**
     * Copied from {@code TransferableSelectionList.Entry#showHoverOverlay()}
     */
    private static boolean isSelectable(Pack pack) {
        return !pack.isFixedPosition() || !pack.isRequired();
    }

    @Override
    public void buildItems(ContextMenuItemBuilder builder, int mouseX, int mouseY) {
        if (this.toggleable != null) {
            this.toggleable.buildContext(builder.separatorIfNonEmpty());
        }
    }
}
