/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import io.github.fishstiz.fidgetz.util.lang.ObjectsUtil;
import io.github.fishstiz.packed_packs.gui.components.SelectionContext;
import io.github.fishstiz.packed_packs.gui.components.events.DragEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.gui.components.pack.PackListDevMenu;
import io.github.fishstiz.packed_packs.pack.PackAssetManager;
import io.github.fishstiz.packed_packs.pack.PackFileOperations;
import io.github.fishstiz.packed_packs.pack.PackOptionsContext;
import io.github.fishstiz.packed_packs.util.InputUtil;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import org.jetbrains.annotations.NotNull;

public class AvailablePackList
extends PackList {
    private static final Sprite SELECT_HIGHLIGHTED_SPRITE = Sprite.of32((ResourceLocation)ResourceUtil.getVanillaSprite("transferable_list/select_highlighted"));
    private static final Sprite SELECT_SPRITE = Sprite.of32((ResourceLocation)ResourceUtil.getVanillaSprite("transferable_list/select"));
    private static final Theme DROP_ZONE_THEME = Theme.RED_700;
    private static final ColoredRect DROP_ZONE = new ColoredRect(DROP_ZONE_THEME.withAlpha(0.25f));

    public AvailablePackList(PackOptionsContext options, PackAssetManager assets, PackFileOperations fileOps, PackListEventListener listener) {
        super(options, assets, fileOps, listener);
    }

    @Override
    @NotNull
    protected Entry createEntry(SelectionContext<Pack> context, int index) {
        return new Entry(context, index);
    }

    @Override
    public boolean canInteract(PackList source) {
        return source != this;
    }

    private boolean isInvalidDrop(PackList source, List<Pack> payload, Pack trigger) {
        return !source.canInteract(this) || payload.isEmpty() || !source.isTransferable(trigger);
    }

    @Override
    public boolean canDrop(DragEvent dragEvent, double mouseX, double mouseY) {
        return this.isMouseOver(mouseX, mouseY) && !this.isInvalidDrop(dragEvent.target(), dragEvent.payload(), dragEvent.trigger());
    }

    @Override
    protected List<Pack> handleDrop(DragEvent dragEvent, double mouseX, double mouseY) {
        Pack trigger;
        List<Pack> payload;
        PackList source = dragEvent.target();
        if (this.isInvalidDrop(source, payload = dragEvent.payload(), trigger = dragEvent.trigger())) {
            return Collections.emptyList();
        }
        ArrayList<Pack> dropped = new ArrayList<Pack>();
        for (Pack pack : payload) {
            if (!source.isTransferable(pack)) continue;
            dropped.add(pack);
        }
        this.clearSelection();
        source.removeAll(dropped);
        this.addAll(dropped);
        this.selectAll(dropped);
        this.select(trigger);
        ObjectsUtil.ifPresent((Object)((Object)this.getEntry(trigger)), x$0 -> this.ensureVisible((AbstractSelectionList.Entry)x$0));
        return dropped;
    }

    @Override
    public void renderDroppableZone(GuiGraphics guiGraphics, DragEvent dragEvent, int mouseX, int mouseY, float partialTick) {
        int width;
        Pack trigger;
        List<Pack> payload;
        PackList source = dragEvent.target();
        if (this.isInvalidDrop(source, payload = dragEvent.payload(), trigger = dragEvent.trigger())) {
            return;
        }
        int n = width = this.scrollbarVisible() ? this.getWidth() - this.scrollbarOffset : this.getWidth();
        if (this.isMouseOver(mouseX, mouseY)) {
            DROP_ZONE.render(guiGraphics, this.getX(), this.getY(), width, this.getHeight(), partialTick);
        }
        guiGraphics.renderOutline(this.getX(), this.getY(), width, this.getHeight(), DROP_ZONE_THEME.getARGB());
    }

    public class Entry
    extends PackList.Entry {
        private Entry(SelectionContext<Pack> context, int index) {
            super(AvailablePackList.this, context, index);
        }

        public boolean isMouseOverSelect(double mouseX, double mouseY) {
            return AvailablePackList.this.isHovered() && GuiUtil.containsPoint((int)(this.getX() + 2), (int)this.getY(), (int)AvailablePackList.SELECT_SPRITE.width, (int)AvailablePackList.SELECT_SPRITE.height, (double)mouseX, (double)mouseY);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (InputUtil.isLeftClick(button) && this.isMouseOverSelect(mouseX, mouseY)) {
                GuiUtil.playClickSound();
                this.transfer();
                return false;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        @Override
        protected void renderForeground(GuiGraphics guiGraphics, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (!hovering && !this.isSelectedLast()) {
                return;
            }
            int x = left + 2;
            GuiConstants.WHITE_OVERLAY.render(guiGraphics, x, top, AvailablePackList.SELECT_SPRITE.width, AvailablePackList.SELECT_SPRITE.height);
            if (this.isTransferable()) {
                ((Sprite)ObjectsUtil.pick((!this.isMouseOverSelect(mouseX, mouseY) ? 1 : 0) != 0, (Object)SELECT_SPRITE, (Object)SELECT_HIGHLIGHTED_SPRITE)).render(guiGraphics, x, top);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void handleDevMenuEvent(PackListDevMenu.Event<?> event) {
            List<Pack> list;
            Boolean bl;
            Pack trigger;
            super.handleDevMenuEvent(event);
            if (!(event instanceof PackListDevMenu.Event.Require)) return;
            PackListDevMenu.Event.Require require = (PackListDevMenu.Event.Require)event;
            try {
                Pack pack;
                trigger = pack = require.trigger();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            Boolean bl2 = bl = require.value();
            List<Pack> list2 = list = require.packs();
            if (!Boolean.TRUE.equals(bl2)) return;
            this.sendPacks(trigger, list2);
        }
    }
}

