/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.FidgetzText;
import io.github.fishstiz.fidgetz.gui.components.LayoutWrapper;
import io.github.fishstiz.fidgetz.gui.components.Modal;
import io.github.fishstiz.fidgetz.gui.components.RenderableRectWidget;
import io.github.fishstiz.fidgetz.gui.components.ToggleableEditBox;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.fidgetz.gui.renderables.RenderableRect;
import io.github.fishstiz.fidgetz.util.DrawUtil;
import io.github.fishstiz.packed_packs.gui.components.events.FileRenameCloseEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FileRenameEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.pack.PackAssetManager;
import io.github.fishstiz.packed_packs.pack.PackFileOperations;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.ToastUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.repository.Pack;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileRenameModal
extends Modal<LinearLayout> {
    private static final int MAX_LENGTH = 255;
    private static final int CONTENT_WIDTH = 256;
    private static final int SHADOW_SIZE = 24;
    private static final Pattern ILLEGAL_CHAR_PATTERN = Pattern.compile(".*[<>:\"/\\\\|?*].*");
    private final RenderableRectWidget<Void> sprite;
    private final FidgetzText<Void> title;
    private final ToggleableEditBox<Void> nameEditor;
    private final FidgetzButton<Void> saveButton;
    private final PackFileOperations fileOps;
    private final PackAssetManager assets;
    private PackList packList;
    private Pack pack;
    private String oldName;

    public <S extends Screen & PackListEventListener> FileRenameModal(S screen, PackFileOperations fileOps, PackAssetManager assets) {
        super(Modal.builder(screen, (Layout)LinearLayout.vertical().spacing(8)).padding(8));
        this.fileOps = fileOps;
        this.assets = assets;
        this.sprite = ((RenderableRectWidget.Builder)RenderableRectWidget.builder((RenderableRect)PackAssetManager.DEFAULT_ICON).makeSquare()).build();
        this.title = ((FidgetzText.Builder)FidgetzText.builder().makeSquare()).setOffsetY(1).setShadow(true).build();
        FidgetzButton closeButton = ((FidgetzButton.Builder)FidgetzButton.builder().makeSquare()).setOnPress(() -> ((FileRenameModal)this).closeModal()).setSprite(GuiConstants.CROSS_SPRITE).build();
        this.nameEditor = ((ToggleableEditBox.Builder)ToggleableEditBox.builder().setWidth(256)).setEditable(true).addListener(this::handleChange).setMaxLength(255).setFilter(this::testInput).build();
        FidgetzButton cancelButton = FidgetzButton.builder().setOnPress(() -> ((FileRenameModal)this).closeModal()).setMessage(CommonComponents.GUI_CANCEL).build();
        this.saveButton = FidgetzButton.builder().setOnPress(this::saveName).setMessage(CommonComponents.GUI_DONE).build();
        FlexLayout titleLayout = FlexLayout.horizontal(this::getContentWidth).spacing(8);
        titleLayout.addChild(this.sprite);
        titleLayout.addFlexChild(this.title);
        titleLayout.addChild((LayoutElement)closeButton);
        FlexLayout buttonLayout = FlexLayout.horizontal(this::getContentWidth).spacing(8);
        buttonLayout.addFlexChild((AbstractWidget)cancelButton);
        buttonLayout.addFlexChild(this.saveButton);
        ((LinearLayout)((LayoutWrapper)this.root()).layout()).addChild((LayoutElement)titleLayout);
        ((LinearLayout)((LayoutWrapper)this.root()).layout()).addChild(this.nameEditor);
        ((LinearLayout)((LayoutWrapper)this.root()).layout()).addChild((LayoutElement)buttonLayout);
        ((LayoutWrapper)this.root()).visitWidgets(arg_0 -> ((FileRenameModal)this).addRenderableWidget(arg_0));
        this.addListener(this::onClose);
    }

    private int getContentWidth() {
        return 256;
    }

    private void clearReferences() {
        this.packList = null;
        this.pack = null;
        this.oldName = null;
        this.sprite.setRenderableRect((RenderableRect)PackAssetManager.DEFAULT_ICON);
        this.title.setMessage(CommonComponents.EMPTY);
        this.nameEditor.setValue("");
    }

    public void open(PackList packList, Pack pack) {
        this.packList = packList;
        this.pack = pack;
        this.sprite.setRenderableRect((RenderableRect)this.assets.getIcon(pack));
        this.title.setMessage(pack.getTitle());
        this.oldName = FileRenameModal.sanitizeNameForEdit(pack);
        this.nameEditor.setValue(this.oldName);
        this.nameEditor.setSuggestion(PackUtil.isZipPack(pack) ? ".zip" : null);
        this.saveButton.active = false;
        this.repositionElements();
        this.setOpen(true);
    }

    private boolean testInput(String input) {
        if (input == null || !input.isEmpty() && input.isBlank()) {
            return false;
        }
        return FileRenameModal.testIllegalChars(input);
    }

    private boolean canSave(String input) {
        if (input == null || input.isBlank()) {
            return false;
        }
        if (this.pack == null || PackUtil.validatePackPath(this.pack) == null) {
            return false;
        }
        String trimmed = input.trim();
        if (Objects.equals(this.oldName, trimmed)) {
            return false;
        }
        return FileRenameModal.testIllegalChars(input);
    }

    private void handleChange(String name) {
        this.saveButton.active = this.canSave(name);
    }

    private void onClose(boolean open) {
        if (open) {
            return;
        }
        PackList target = this.packList;
        Pack trigger = this.pack;
        if (target != null) {
            ((PackListEventListener)this.screen).onEvent(new FileRenameCloseEvent(target, trigger));
        }
        this.clearReferences();
    }

    private void saveName() {
        String newName = this.nameEditor.getValue();
        if (!this.canSave(newName)) {
            return;
        }
        String sanitizedName = FileRenameModal.sanitizeNameForSave(this.pack, newName);
        if (this.fileOps.renamePack(this.pack, sanitizedName)) {
            PackList.Entry entry;
            MutableComponent sanitizedNameText = Component.literal((String)sanitizedName);
            if (this.packList != null && (entry = this.packList.getEntry(this.pack)) != null) {
                entry.onRename((Component)sanitizedNameText);
            }
            ((PackListEventListener)this.screen).onEvent(new FileRenameEvent(this.packList, this.pack, (Component)sanitizedNameText));
            this.setOpen(false);
            this.clearReferences();
        } else {
            ToastUtil.onFileFailToast(ToastUtil.getRenameFailText(this.pack.getTitle().getString(), newName));
        }
    }

    private static String sanitizeNameForEdit(Pack pack) {
        String name = pack.getTitle().getString();
        return PackUtil.isZipPack(pack) ? name.replaceFirst(Pattern.quote(".zip") + "$", "") : name;
    }

    private static String sanitizeNameForSave(Pack pack, String newName) {
        newName = FilenameUtils.getName((String)newName).trim();
        return PackUtil.isZipPack(pack) ? newName + ".zip" : newName;
    }

    private static boolean testIllegalChars(@NotNull String input) {
        if (!(input = input.trim()).equals(FilenameUtils.getName((String)input))) {
            return false;
        }
        return !ILLEGAL_CHAR_PATTERN.matcher(input).matches();
    }

    protected void renderBackground(GuiGraphics guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        DrawUtil.renderDropShadow((GuiGraphics)guiGraphics, (int)x, (int)y, (int)width, (int)height, (int)24);
        super.renderBackground(guiGraphics, x, y, width, height, mouseX, mouseY, partialTick);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean keyPressed = super.keyPressed(keyCode, scanCode, modifiers);
        if (!keyPressed && this.isOpen() && keyCode == 257 && this.canSave(this.nameEditor.getValue())) {
            this.saveName();
            return true;
        }
        return keyPressed;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        boolean charTyped = super.charTyped(codePoint, modifiers);
        if (!charTyped && this.isOpen() && !this.nameEditor.isFocused()) {
            this.setFocused((GuiEventListener)this.nameEditor);
            return this.nameEditor.charTyped(codePoint, modifiers);
        }
        return charTyped;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        ScreenDirection direction;
        if (!this.nameEditor.isFocused() || !(event instanceof FocusNavigationEvent.ArrowNavigation)) return super.nextFocusPath(event);
        FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)event;
        try {
            ScreenDirection screenDirection;
            direction = screenDirection = arrowNavigation.direction();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (direction.getAxis() != ScreenAxis.HORIZONTAL) return super.nextFocusPath(event);
        if (Screen.hasShiftDown()) return ComponentPath.path(this.nameEditor, (ContainerEventHandler[])new ContainerEventHandler[]{this});
        this.nameEditor.setHighlightPos(this.nameEditor.getCursorPosition());
        return ComponentPath.path(this.nameEditor, (ContainerEventHandler[])new ContainerEventHandler[]{this});
    }
}

