/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.layouts;

import io.github.fishstiz.fidgetz.gui.components.FidgetzText;
import io.github.fishstiz.fidgetz.gui.components.ToggleButton;
import io.github.fishstiz.fidgetz.gui.layouts.Layouts;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ScrollableLayout;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.Component;

public class OptionsLayout
implements Layout {
    private static final int CONTENT_WIDTH = 200;
    private final IntSupplier maxHeightSupplier;
    private final ScrollableLayout layout;

    public OptionsLayout(Minecraft minecraft, IntSupplier maxHeightSupplier, Config.Packs ... configs) {
        this.maxHeightSupplier = maxHeightSupplier;
        int spacing = 8;
        LinearLayout contentLayout = LinearLayout.vertical().spacing(8);
        LayoutSettings titleSettings = LayoutSettings.defaults().paddingTop(-4).paddingBottom(-8);
        block4: for (Config.Packs config : configs) {
            Config.Packs packs;
            Objects.requireNonNull(config);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Config.ResourcePacks.class, Config.DataPacks.class}, (Object)packs, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Config.ResourcePacks resourcePacks = (Config.ResourcePacks)packs;
                    contentLayout.addChild((LayoutElement)FidgetzText.builder().setMessage((Component)ResourceUtil.getText("resource_packs", new Object[0])).alignLeft().setWidth(200).build(), titleSettings);
                    OptionsLayout.addCommonOptions(contentLayout, resourcePacks);
                    contentLayout.addChild((LayoutElement)((ToggleButton.ToggleBuilder)((ToggleButton.ToggleBuilder)((ToggleButton.ToggleBuilder)ToggleButton.builder().setMessage((Component)ResourceUtil.getText("options.apply_on_close", new Object[0]))).setValue(resourcePacks.isApplyOnClose()).setOnPress(() -> resourcePacks.setApplyOnClose(!resourcePacks.isApplyOnClose()))).setWidth(200)).build());
                    continue block4;
                }
                case 1: {
                    Config.DataPacks dataPacks = (Config.DataPacks)packs;
                    contentLayout.addChild((LayoutElement)FidgetzText.builder().setMessage((Component)Component.translatable((String)"selectWorld.dataPacks")).alignLeft().setWidth(200).build(), titleSettings);
                    OptionsLayout.addCommonOptions(contentLayout, dataPacks);
                }
            }
        }
        this.layout = Layouts.unpaddedScrollableLayout((Minecraft)minecraft, (Layout)contentLayout);
    }

    public OptionsLayout(Minecraft minecraft, IntSupplier maxHeightSupplier) {
        this(minecraft, maxHeightSupplier, Config.get().getResourcepacks(), Config.get().getDatapacks());
    }

    public void visitWidgets(Consumer<AbstractWidget> visitor) {
        this.layout.visitWidgets(visitor);
    }

    public void visitChildren(Consumer<LayoutElement> visitor) {
        this.layout.visitChildren(visitor);
    }

    public void setX(int x) {
        this.layout.setX(x);
    }

    public void setY(int y) {
        this.layout.setY(y);
    }

    public int getX() {
        return this.layout.getX();
    }

    public int getY() {
        return this.layout.getY();
    }

    public int getWidth() {
        return this.layout.getWidth();
    }

    public int getHeight() {
        return this.layout.getHeight();
    }

    public void arrangeElements() {
        this.layout.setMaxHeight(this.maxHeightSupplier.getAsInt());
        this.layout.arrangeElements();
    }

    private static void addCommonOptions(LinearLayout linearLayout, Config.Packs config) {
        linearLayout.addChild((LayoutElement)((ToggleButton.ToggleBuilder)((ToggleButton.ToggleBuilder)((ToggleButton.ToggleBuilder)ToggleButton.builder().setMessage((Component)ResourceUtil.getText("options.replace_screen", new Object[0]))).setValue(config.isReplaceOriginal()).setOnPress(() -> config.setReplaceOriginal(!config.isReplaceOriginal()))).setWidth(200)).build());
        linearLayout.addChild((LayoutElement)((ToggleButton.ToggleBuilder)((ToggleButton.ToggleBuilder)((ToggleButton.ToggleBuilder)((ToggleButton.ToggleBuilder)ToggleButton.builder().setMessage((Component)ResourceUtil.getText("options.hide_incompatible_warnings", new Object[0]))).setTooltip(Tooltip.create((Component)ResourceUtil.getText("options.hide_incompatible_warnings.info", new Object[0])))).setValue(config.isIncompatibleWarningsHidden()).setOnPress(() -> config.setHideIncompatibleWarnings(!config.isIncompatibleWarningsHidden()))).setWidth(200)).build());
        linearLayout.addChild((LayoutElement)((ToggleButton.ToggleBuilder)((ToggleButton.ToggleBuilder)((ToggleButton.ToggleBuilder)ToggleButton.builder().setMessage((Component)ResourceUtil.getText("options.remember_last_viewed_profile", new Object[0]))).setValue(config.isLastViewedProfileRemembered()).setOnPress(() -> config.setRememberLastViewedProfile(!config.isLastViewedProfileRemembered()))).setWidth(200)).build());
    }
}

