/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.screens;

import com.google.common.collect.ImmutableList;
import io.github.fishstiz.fidgetz.gui.components.CyclicButton;
import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.HoverStateHandler;
import io.github.fishstiz.fidgetz.gui.components.LayoutWrapper;
import io.github.fishstiz.fidgetz.gui.components.Modal;
import io.github.fishstiz.fidgetz.gui.components.ToggleableDialog;
import io.github.fishstiz.fidgetz.gui.components.ToggleableDialogContainer;
import io.github.fishstiz.fidgetz.gui.components.ToggleableEditBox;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenu;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuContainer;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.MenuItem;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.gui.renderables.RenderableRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.lang.CollectionsUtil;
import io.github.fishstiz.fidgetz.util.lang.FunctionsUtil;
import io.github.fishstiz.fidgetz.util.lang.ObjectsUtil;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.compat.ModAdditions;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.DevConfig;
import io.github.fishstiz.packed_packs.config.Folder;
import io.github.fishstiz.packed_packs.config.Preferences;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.config.Profiles;
import io.github.fishstiz.packed_packs.gui.components.ToggleableHelper;
import io.github.fishstiz.packed_packs.gui.components.contextmenu.DirectoryMenuItem;
import io.github.fishstiz.packed_packs.gui.components.contextmenu.PackMenuHeader;
import io.github.fishstiz.packed_packs.gui.components.events.FileDeleteEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FileRenameCloseEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FileRenameEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FileRenameOpenEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FolderCloseEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FolderOpenEvent;
import io.github.fishstiz.packed_packs.gui.components.events.MoveEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackAliasOpenEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEvent;
import io.github.fishstiz.packed_packs.gui.components.events.SelectionEvent;
import io.github.fishstiz.packed_packs.gui.components.pack.FileRenameModal;
import io.github.fishstiz.packed_packs.gui.components.pack.FolderDialog;
import io.github.fishstiz.packed_packs.gui.components.pack.FolderPackList;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.gui.components.pack.Query;
import io.github.fishstiz.packed_packs.gui.components.profile.Sidebar;
import io.github.fishstiz.packed_packs.gui.history.HistoryManager;
import io.github.fishstiz.packed_packs.gui.history.Restorable;
import io.github.fishstiz.packed_packs.gui.layouts.OptionsLayout;
import io.github.fishstiz.packed_packs.gui.layouts.ProfilesLayout;
import io.github.fishstiz.packed_packs.gui.layouts.pack.AvailablePacksLayout;
import io.github.fishstiz.packed_packs.gui.layouts.pack.CurrentPacksLayout;
import io.github.fishstiz.packed_packs.gui.layouts.pack.PackAliasLayout;
import io.github.fishstiz.packed_packs.gui.layouts.pack.PackLayout;
import io.github.fishstiz.packed_packs.gui.metadata.PackSelectionScreenArgs;
import io.github.fishstiz.packed_packs.gui.screens.PackListEventHandler;
import io.github.fishstiz.packed_packs.gui.screens.WidgetFactory;
import io.github.fishstiz.packed_packs.pack.PackGroup;
import io.github.fishstiz.packed_packs.pack.PackOptionsContext;
import io.github.fishstiz.packed_packs.pack.PackRepositoryManager;
import io.github.fishstiz.packed_packs.pack.PackWatcher;
import io.github.fishstiz.packed_packs.pack.folder.FolderPack;
import io.github.fishstiz.packed_packs.transform.mixin.PackSelectionModelAccessor;
import io.github.fishstiz.packed_packs.transform.mixin.PackSelectionScreenAccessor;
import io.github.fishstiz.packed_packs.util.AsyncUtil;
import io.github.fishstiz.packed_packs.util.InputUtil;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.ToastUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.NoticeWithLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackedPacksScreen
extends PackListEventHandler
implements HoverStateHandler,
ToggleableDialogContainer,
ContextMenuContainer,
Restorable<Snapshot> {
    private static final Component OPEN_FOLDER_TEXT = Component.translatable((String)"pack.openFolder");
    private final Screen previous;
    private final PackSelectionScreenArgs original;
    private final HistoryManager<Snapshot> history;
    private final LayoutWrapper<FlexLayout> layout;
    private final ProfilesLayout profiles;
    private final PackOptionsContext options;
    private final PackRepositoryManager repository;
    private final AvailablePacksLayout availablePacks;
    private final CurrentPacksLayout currentPacks;
    private final FolderDialog folderDialog;
    private final List<PackList> packLists;
    private final FileRenameModal fileRenameModal;
    private final ContextMenu contextMenu;
    private final Modal<OptionsLayout> optionsModal;
    private final List<ToggleableDialog<?>> dialogs;
    private Modal<PackAliasLayout> aliasModal;
    private List<Path> additionalFolders;
    private CompletableFuture<Void> refreshFuture;
    private CompletableFuture<Void> watcherFuture;
    private PackWatcher watcher;
    private boolean showActionBar = Config.get().isShowActionBar();
    @Nullable
    private GuiEventListener hoveredElement;
    private boolean initialized = false;

    private PackedPacksScreen(Minecraft minecraft, Screen previous, PackSelectionScreenArgs original, boolean initState) {
        super(minecraft, (Component)ResourceUtil.getModName());
        this.previous = previous;
        this.original = original;
        Config.Packs userConfig = Config.get().get(original.packType());
        DevConfig.Packs config = DevConfig.get().get(original.packType());
        this.history = new HistoryManager();
        this.layout = new LayoutWrapper((Layout)FlexLayout.vertical(this::getMaxHeight).spacing(8));
        this.layout.setPadding(8);
        this.profiles = new ProfilesLayout(this, userConfig, config, this::onProfileChange, this::onProfileCopy);
        this.options = new PackOptionsContext(this.profiles::getProfile, userConfig, config);
        this.repository = new PackRepositoryManager(this.original.repository(), this.options, this.original.packDir());
        WidgetFactory.PackedPacksWidgets widgets = WidgetFactory.createWidgets(this, this.options, this.repository, this.assetManager);
        this.availablePacks = widgets.availablePacksLayout();
        this.currentPacks = widgets.currentPacksLayout();
        this.folderDialog = widgets.folderDialog();
        this.packLists = widgets.packLists();
        this.fileRenameModal = widgets.fileRenameModal();
        this.contextMenu = widgets.contextMenu();
        this.optionsModal = ((Modal.Builder)((Modal.Builder)Modal.builder((Screen)this, (Layout)new OptionsLayout(this.minecraft, () -> this.layout.getHeight(), userConfig)).setBackdrop((RenderableRect)new ColoredRect(Theme.BLACK.withAlpha(0.5f)))).setCaptureFocus(true)).padding(8).build();
        if (Config.get().isDevMode()) {
            PackAliasLayout packAliasLayout = new PackAliasLayout(config, this.assetManager);
            this.aliasModal = ((Modal.Builder)Modal.builder((Screen)this, (Layout)packAliasLayout).addListener(open -> {
                if (!open.booleanValue()) {
                    ((PackAliasLayout)((LayoutWrapper)this.aliasModal.root()).layout()).saveAliases();
                }
            })).padding(8).build();
            this.dialogs = List.of(this.optionsModal, this.contextMenu, this.aliasModal, this.fileRenameModal, this.profiles.getSidebar(), this.folderDialog);
        } else {
            this.dialogs = List.of(this.optionsModal, this.contextMenu, this.fileRenameModal, this.profiles.getSidebar(), this.folderDialog);
        }
        this.initAdditionalFolders();
        if (initState) {
            Profile defaultProfile;
            Profile lastViewed = userConfig.getLastViewedProfile();
            if (Objects.equals(lastViewed, defaultProfile = config.getDefaultProfile())) {
                lastViewed = defaultProfile;
            }
            this.profiles.setProfile(lastViewed);
        }
    }

    public PackedPacksScreen(Minecraft minecraft, Screen previous, PackSelectionScreenArgs original) {
        this(minecraft, previous, original, true);
    }

    public PackedPacksScreen(Minecraft minecraft, Screen previous, PackSelectionScreenArgs original, Profile profile) {
        this(minecraft, previous, original, false);
        this.profiles.setProfile(profile);
    }

    public PackedPacksScreen(Minecraft minecraft, Screen previous, PackSelectionScreenArgs original, PackGroup packs) {
        this(minecraft, previous, original, false);
        this.applyPacks((List<Pack>)packs.unselected(), (List<Pack>)packs.selected());
    }

    public void added() {
        if (this.initialized) {
            this.refreshPacks();
            this.initAdditionalFolders();
            this.createWatcher();
        }
    }

    public void removed() {
        this.closeWatcher();
        this.availablePacks.saveFilters();
        Profile profile = this.profiles.getProfile();
        this.syncProfile(profile);
        this.options.getUserConfig().setLastViewedProfile(profile);
        List<Profile> profiles = this.options.getUserConfig().getProfiles();
        this.options.getUserConfig().setProfileOrder(profiles);
        Runnable profileSaver = profile != null ? () -> Profiles.save(this.original.packType(), profile) : FunctionsUtil.nop();
        Runnable[] runnableArray = new Runnable[4];
        runnableArray[0] = profileSaver;
        runnableArray[1] = Config.get()::save;
        runnableArray[2] = DevConfig.get()::save;
        runnableArray[3] = Preferences.INSTANCE::save;
        AsyncUtil.submitAndWait((Executor)Util.backgroundExecutor(), runnableArray);
    }

    protected void init() {
        if (this.initialized) {
            return;
        }
        this.profiles.init(() -> this.setInitialFocus());
        ((FlexLayout)this.layout.layout()).addChild((LayoutElement)this.createHeader());
        ((FlexLayout)this.layout.layout()).addFlexChild(this.createContents());
        ((FlexLayout)this.layout.layout()).addChild((LayoutElement)this.createFooter());
        this.dialogs.forEach(x$0 -> {
            ToggleableDialog cfr_ignored_0 = (ToggleableDialog)this.addWidget((GuiEventListener)x$0);
        });
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        CollectionsUtil.forEachReverse(this.dialogs, x$0 -> {
            ToggleableDialog cfr_ignored_0 = (ToggleableDialog)this.addRenderableOnly((Renderable)x$0);
        });
        this.clearHistory();
        this.repositionElements();
        this.refreshPacks();
        this.createWatcher();
        this.initialized = true;
    }

    private FlexLayout createHeader() {
        boolean devMode;
        FlexLayout header;
        block6: {
            block5: {
                PackSelectionScreen s;
                header = FlexLayout.horizontal(this::getMaxWidth).spacing(8);
                devMode = Config.get().isDevMode();
                header.addChild((LayoutElement)((FidgetzButton.Builder)FidgetzButton.builder().makeSquare()).setMessage(ProfilesLayout.TITLE_TEXT).setTooltip(Tooltip.create((Component)ProfilesLayout.TITLE_TEXT)).setSprite(GuiConstants.HAMBURGER_SPRITE).setOnPress(() -> ((Sidebar)this.profiles.getSidebar()).toggle()).build());
                if (devMode || Preferences.INSTANCE.actionBarWidget.get().booleanValue()) {
                    header.addChild((LayoutElement)((FidgetzButton.Builder)ToggleableHelper.applyPref(Preferences.INSTANCE.actionBarWidget, FidgetzButton.builder()).makeSquare()).setTooltip(Tooltip.create((Component)ResourceUtil.getText("toggle_actionbar.info", new Object[0]))).setSprite(Sprite.of16((ResourceLocation)ResourceUtil.getIcon("filter"))).setOnPress(this::toggleActionBar).build());
                }
                header.addChild(this.profiles.getToggleNameButton());
                header.addFlexChild(this.profiles.getNameField());
                Screen screen = this.previous;
                PackSelectionScreen originalScreen = screen instanceof PackSelectionScreen ? (s = (PackSelectionScreen)screen) : this.original.createDummy();
                ModAdditions.onCreateHeader(this.original.packType(), header, this, originalScreen);
                if (devMode) break block5;
                if (!Preferences.INSTANCE.optionsWidget.get().booleanValue()) break block6;
            }
            header.addChild((LayoutElement)((FidgetzButton.Builder)ToggleableHelper.applyPref(Preferences.INSTANCE.optionsWidget, FidgetzButton.builder()).makeSquare()).setMessage(GuiConstants.OPTIONS_TEXT).setTooltip(Tooltip.create((Component)GuiConstants.OPTIONS_TEXT.copy().append(CommonComponents.ELLIPSIS))).setSprite(Sprite.of16((ResourceLocation)ResourceUtil.getIcon("gear"))).setOnPress(() -> this.optionsModal.toggle()).build());
        }
        if (devMode || Preferences.INSTANCE.originalScreenWidget.get().booleanValue()) {
            header.addChild((LayoutElement)((FidgetzButton.Builder)ToggleableHelper.applyPref(Preferences.INSTANCE.originalScreenWidget, FidgetzButton.builder()).makeSquare()).setTooltip(Tooltip.create((Component)ResourceUtil.getText("original_screen.info", new Object[0]).append(CommonComponents.ELLIPSIS))).setSprite(Sprite.of16((ResourceLocation)ResourceUtil.getIcon("exit"))).setOnPress(this::setOriginalScreen).build());
        }
        return header;
    }

    private FlexLayout createContents() {
        FlexLayout contents = FlexLayout.horizontal(this::getMaxWidth).spacing(8);
        FlexLayout packLayout = FlexLayout.vertical().spacing(8);
        this.availablePacks.init(contents.addFlexChild(packLayout, true));
        this.currentPacks.init(contents.addFlexChild(packLayout.copyLayout(), true));
        this.currentPacks.getSearchField().addListener(this::recordState);
        this.availablePacks.getSearchField().addListener(this::recordState);
        return contents;
    }

    private FlexLayout createFooter() {
        FlexLayout footer = FlexLayout.horizontal(this::getMaxWidth).spacing(8);
        FlexLayout firstColumn = FlexLayout.horizontal().spacing(8);
        FlexLayout secondColumn = firstColumn.copyLayout();
        firstColumn.addFlexChild((AbstractWidget)FidgetzButton.builder().setMessage(OPEN_FOLDER_TEXT).setTooltip(Tooltip.create((Component)Component.translatable((String)"pack.folderInfo"))).setOnPress(this.repository::openDir).build());
        if (this.original.packType() == PackType.CLIENT_RESOURCES) {
            secondColumn.addFlexChild((AbstractWidget)FidgetzButton.builder().setMessage((Component)ResourceUtil.getText("apply", new Object[0])).setOnPress(this::commit).build());
        }
        secondColumn.addFlexChild((AbstractWidget)FidgetzButton.builder().setMessage(CommonComponents.GUI_DONE).setOnPress(this::onClose).build());
        footer.addFlexChild(firstColumn);
        footer.addFlexChild(secondColumn);
        return footer;
    }

    public int getMaxHeight() {
        return this.height - 16;
    }

    public int getMaxWidth() {
        return this.width - 16;
    }

    protected void rebuildWidgets() {
        PackedPacksScreen screen;
        if (this.minecraft == null) {
            return;
        }
        Profile profile = this.profiles.getProfile();
        if (profile != null) {
            profile.setPacks(this.currentPacks.list().copyPacks());
            screen = new PackedPacksScreen(this.minecraft, this.previous, this.original, profile);
        } else {
            PackGroup packs = PackGroup.of(this.currentPacks.list().copyPacks(), this.availablePacks.list().copyPacks());
            screen = new PackedPacksScreen(this.minecraft, this.previous, this.original, packs);
        }
        this.minecraft.setScreen((Screen)screen);
    }

    public void onFilesDrop(List<Path> packs) {
        if (this.minecraft != null) {
            this.minecraft.setScreen((Screen)new ConfirmScreen(this.confirmFileDrop(packs), (Component)Component.translatable((String)"pack.dropConfirm"), (Component)Component.literal((String)PackUtil.joinPackNames(packs))));
        }
    }

    private BooleanConsumer confirmFileDrop(List<Path> packs) {
        return confirmed -> {
            if (this.minecraft == null) {
                return;
            }
            if (!confirmed) {
                this.minecraft.setScreen((Screen)this);
                return;
            }
            PackUtil.PathValidationResults results = PackUtil.validatePaths(packs);
            if (!results.symlinkWarnings().isEmpty()) {
                this.minecraft.setScreen(NoticeWithLinkScreen.createPackSymlinkWarningScreen(() -> this.minecraft.setScreen((Screen)this)));
                return;
            }
            if (!results.valid().isEmpty()) {
                PackSelectionScreen.copyPacks((Minecraft)this.minecraft, results.valid(), (Path)this.original.packDir());
                this.refreshPacks();
            }
            if (!results.rejected().isEmpty()) {
                String rejectedNames = PackUtil.joinPackNames(results.rejected());
                this.minecraft.setScreen((Screen)new AlertScreen(() -> this.minecraft.setScreen((Screen)this), (Component)Component.translatable((String)"pack.dropRejected.title"), (Component)Component.translatable((String)"pack.dropRejected.message", (Object[])new Object[]{rejectedNames})));
                return;
            }
            this.minecraft.setScreen((Screen)this);
        };
    }

    private void setOriginalScreen() {
        if (this.previous instanceof PackSelectionScreen) {
            this.onClose();
        } else if (this.minecraft != null) {
            this.minecraft.setScreen((Screen)this.original.createScreen(this.previous));
        }
    }

    public void onClose() {
        Config.Packs packs;
        if (this.minecraft == null) {
            return;
        }
        String commitRequestor = ModAdditions.forceCommitOnClose(this.original.packType());
        if (commitRequestor != null) {
            this.commit();
            PackedPacks.LOGGER.info("[packed_packs] Commiting packs on close at the request of mod '{}'.", (Object)commitRequestor);
        } else {
            Config.ResourcePacks resourceConfig;
            packs = this.options.getUserConfig();
            if (!(packs instanceof Config.ResourcePacks) || (resourceConfig = (Config.ResourcePacks)packs).isApplyOnClose()) {
                this.commit();
            }
        }
        if (this.original.packType() == PackType.SERVER_DATA && !(this.previous instanceof PackSelectionScreen)) {
            this.original.output().accept(this.repository.getRepository());
            return;
        }
        packs = this.previous;
        if (packs instanceof PackSelectionScreenAccessor) {
            PackSelectionScreenAccessor packScreen = (PackSelectionScreenAccessor)((Object)packs);
            ((PackSelectionModelAccessor)packScreen.getModel()).packed_packs$reset();
            packScreen.invokeReload();
        }
        this.minecraft.setScreen(this.previous);
    }

    public void tick() {
        if (this.watcher != null) {
            this.watcher.poll();
        }
    }

    private void createWatcher() {
        if (this.watcher == null) {
            this.watcherFuture = CompletableFuture.supplyAsync(() -> {
                try {
                    ObjectArrayList paths = new ObjectArrayList(this.additionalFolders.size() + 1);
                    paths.add(this.repository.getBaseDir());
                    paths.addAll(this.additionalFolders);
                    return new PackWatcher(this.original.packType(), (Collection<Path>)paths, this::refreshPacks);
                }
                catch (Exception e) {
                    PackedPacks.LOGGER.error("[packed_packs] Failed to initialize pack directory watcher.", (Throwable)e);
                    return null;
                }
            }, (Executor)Util.backgroundExecutor()).thenAcceptAsync(watcher -> {
                if (watcher != null) {
                    this.watcher = watcher;
                } else {
                    this.closeWatcher();
                }
            }, (Executor)this.minecraft);
        }
    }

    private void closeWatcher() {
        if (this.watcherFuture != null) {
            this.watcherFuture.cancel(true);
        }
        if (this.watcher != null) {
            this.watcher.close();
            this.watcher = null;
        }
    }

    private void initAdditionalFolders() {
        this.additionalFolders = CollectionsUtil.deduplicate((Collection)CollectionsUtil.addAll((Collection[])new Collection[]{PackUtil.mapValidDirectories(this.options.getUserConfig().getAdditionalFolders()), this.repository.getAdditionalDirs()}));
    }

    private void repositionLists() {
        this.availablePacks.setHeaderVisibility(this.showActionBar);
        this.currentPacks.setHeaderVisibility(this.showActionBar);
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        this.layout.setPosition(0, 0);
        this.dialogs.forEach(ToggleableDialog::repositionElements);
        this.contextMenu.setOpen(false);
        this.repositionLists();
    }

    public void toggleActionBar() {
        this.showActionBar = !this.showActionBar;
        Config.get().setShowActionBar(this.showActionBar);
        this.repositionLists();
    }

    public void commit() {
        this.currentPacks.getSearchField().setValue("");
        this.syncProfile(this.profiles.getProfile());
        this.repository.selectPacks(this.currentPacks.list().copyPacks());
        if (this.original.packType() == PackType.CLIENT_RESOURCES) {
            this.original.output().accept(this.repository.getRepository());
        }
    }

    private void replacePacks(PackList list, List<Pack> packs) {
        ((PackList.Snapshot)list.captureState()).replaceAll(packs).restore();
    }

    private void revalidateFolder() {
        if (this.folderDialog.isOpen()) {
            FolderPack folderPack = this.folderDialog.getFolderPack();
            if (folderPack == null || this.repository.getFolderConfig(folderPack) == null) {
                this.folderDialog.setOpen(false);
            } else {
                this.replacePacks((PackList)this.folderDialog.root(), (List<Pack>)ImmutableList.copyOf(this.repository.getNestedPacks(folderPack)));
            }
        }
    }

    public void revalidatePacks() {
        PackList availableList = this.availablePacks.list();
        PackList currentList = this.currentPacks.list();
        PackGroup packs = this.repository.validatePacks(availableList.copyPacks(), currentList.copyPacks());
        this.assetManager.clearIconCache();
        this.replacePacks(availableList, (List<Pack>)packs.unselected());
        this.replacePacks(currentList, (List<Pack>)packs.selected());
        this.revalidateFolder();
        this.clearHistory();
    }

    public void refreshPacks() {
        this.refreshFuture = CompletableFuture.runAsync(this.repository::refresh, (Executor)Util.backgroundExecutor()).thenRunAsync(this::revalidatePacks, (Executor)this.minecraft);
    }

    public void useSelected() {
        PackGroup packs = this.repository.getPacksBySelected();
        this.availablePacks.list().reload((Collection<Pack>)packs.unselected());
        this.currentPacks.list().reload((Collection<Pack>)packs.selected());
        this.clearHistory();
    }

    public void onProfileChange(@Nullable Profile previous, @Nullable Profile current) {
        boolean unlocked;
        if (previous != null) {
            previous.setPacks(this.currentPacks.list().copyPacks());
            Profiles.save(this.original.packType(), previous);
        }
        this.availablePacks.getTransferButton().active = unlocked = current == null || !current.isLocked();
        this.currentPacks.getTransferButton().active = unlocked;
        this.availablePacks.getSearchField().setValueSilently("");
        this.currentPacks.getSearchField().setValueSilently("");
        this.availablePacks.list().search("");
        this.currentPacks.list().search("");
        if (current != null && !current.getPackIds().isEmpty()) {
            this.applyProfile(current);
        } else {
            this.useSelected();
        }
    }

    public void onProfileCopy(@Nullable Profile original, @NotNull Profile copy) {
        copy.setPacks(this.currentPacks.list().copyPacks());
    }

    private void applyProfile(@NotNull Profile profile) {
        List<Pack> available = this.availablePacks.list().copyPacks();
        List<Pack> current = this.repository.getPacksByFlattenedIds(profile.getPackIds());
        this.applyPacks(available, current);
    }

    private void applyPacks(List<Pack> available, List<Pack> current) {
        PackGroup packs = this.repository.validatePacks(available, current);
        this.availablePacks.list().reload((Collection<Pack>)packs.unselected());
        this.currentPacks.list().reload((Collection<Pack>)packs.selected());
        this.clearHistory();
    }

    public void syncProfile(@Nullable Profile profile) {
        if (profile != null) {
            profile.syncPacks(this.repository.getPacks(), this.currentPacks.list().copyPacks());
        }
    }

    @Override
    public boolean isUnlocked() {
        Profile profile = this.profiles.getProfile();
        return profile == null || !profile.isLocked();
    }

    @Override
    @NotNull
    public List<PackList> getPackLists() {
        return this.packLists;
    }

    @Override
    @Nullable
    public PackList getDestination(PackList source) {
        if (source == this.availablePacks.list()) {
            return this.currentPacks.list();
        }
        if (source == this.currentPacks.list()) {
            return this.availablePacks.list();
        }
        return null;
    }

    @Override
    protected void transferFocus(PackList source, PackList destination) {
        super.transferFocus(source, destination);
        if (destination == this.currentPacks.list()) {
            this.currentPacks.list().scrollToLastSelected();
        }
    }

    private void onFolderOpen(FolderOpenEvent event) {
        ((FolderPackList)this.folderDialog.root()).reload(this.repository.getNestedPacks(event.opened()));
        this.folderDialog.updateFolder(event.target(), event.opened(), this.assetManager);
        this.folderDialog.setOpen(true);
    }

    private void onFolderClose(FolderCloseEvent event) {
        this.folderDialog.setOpen(false);
        FolderPack folderPack = event.folderPack();
        if (folderPack == null) {
            return;
        }
        Folder folder = this.repository.getFolderConfig(folderPack);
        if (folder != null && this.isUnlocked()) {
            if (folder.trySetPacks(this.repository.validateAndOrderNestedPacks(folderPack, event.target().copyPacks()))) {
                folderPack.saveConfig(folder);
            }
            this.focusList((PackList)ObjectsUtil.firstNonNullOrDefault((Object)this.availablePacks.list(), (Object[])new PackList[]{this.folderDialog.getParent()}));
        }
    }

    private void onFileRename(FileRenameEvent event) {
        if (this.folderDialog.isOpen()) {
            this.folderDialog.onRename(event.renamed(), event.newName());
        }
        this.refreshPacks();
    }

    @Override
    protected void handleMoveEvent(MoveEvent event) {
        if (event.target() != this.folderDialog.root()) {
            super.handleMoveEvent(event);
            return;
        }
        PackList.Entry entry = event.target().getEntry(event.trigger());
        if (entry != null) {
            this.focus(ComponentPath.path((GuiEventListener)entry, (ContainerEventHandler[])new ContainerEventHandler[]{event.target(), this.folderDialog, this}));
        } else {
            this.focus(ComponentPath.path((GuiEventListener)event.target(), (ContainerEventHandler[])new ContainerEventHandler[]{this.folderDialog, this}));
        }
    }

    private void onOpenAliases(PackAliasOpenEvent event) {
        Objects.requireNonNull(this.aliasModal, "aliasModal");
        this.aliasModal.clear();
        ((PackAliasLayout)((LayoutWrapper)this.aliasModal.root()).layout()).editAliases(event.trigger(), () -> this.aliasModal.closeModal());
        ((LayoutWrapper)this.aliasModal.root()).visitWidgets(arg_0 -> this.aliasModal.addRenderableWidget(arg_0));
        this.aliasModal.repositionElements();
        this.aliasModal.setOpen(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onEvent(PackListEvent event) {
        boolean notFolderDialogEvent;
        super.onEvent(event);
        this.profiles.getSidebar().setOpen(false);
        this.contextMenu.setOpen(false);
        this.fileRenameModal.setOpen(false);
        ObjectsUtil.ifPresent(this.aliasModal, Modal::closeModal);
        boolean bl = notFolderDialogEvent = event.target() != this.folderDialog.root();
        if (notFolderDialogEvent) {
            this.folderDialog.setOpen(false);
        }
        PackListEvent packListEvent = event;
        Objects.requireNonNull(packListEvent);
        PackListEvent packListEvent2 = packListEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FileDeleteEvent.class, FileRenameOpenEvent.class, FileRenameEvent.class, FileRenameCloseEvent.class, FolderOpenEvent.class, FolderCloseEvent.class, PackAliasOpenEvent.class}, (Object)packListEvent2, n)) {
            case 0: {
                FileDeleteEvent ignore = (FileDeleteEvent)packListEvent2;
                this.revalidatePacks();
                break;
            }
            case 1: {
                FileRenameOpenEvent fileRenameOpenEvent = (FileRenameOpenEvent)packListEvent2;
                try {
                    PackList packList;
                    PackList target = packList = fileRenameOpenEvent.target();
                    PackList trigger = packList = fileRenameOpenEvent.trigger();
                    this.fileRenameModal.open(target, (Pack)trigger);
                    break;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 2: {
                FileRenameEvent e = (FileRenameEvent)packListEvent2;
                this.onFileRename(e);
                break;
            }
            case 3: {
                FileRenameCloseEvent e = (FileRenameCloseEvent)packListEvent2;
                this.focusList(e.target());
                break;
            }
            case 4: {
                FolderOpenEvent e = (FolderOpenEvent)packListEvent2;
                this.onFolderOpen(e);
                break;
            }
            case 5: {
                FolderCloseEvent e = (FolderCloseEvent)packListEvent2;
                this.onFolderClose(e);
                break;
            }
            case 6: {
                PackAliasOpenEvent e = (PackAliasOpenEvent)packListEvent2;
                this.onOpenAliases(e);
                break;
            }
        }
        if (!this.isUnlocked()) return;
        if (!event.pushToHistory()) return;
        if (!notFolderDialogEvent) return;
        this.history.push(this.captureState());
    }

    @Nullable
    public PackLayout getLayoutFromSelectedList() {
        return (PackLayout)ObjectsUtil.firstNonNull((Object[])new PackLayout[]{(PackLayout)ObjectsUtil.pick((Object)this.availablePacks, (Object)this.currentPacks, pl -> pl.list() == this.getFocused()), (PackLayout)ObjectsUtil.pick((Object)this.availablePacks, (Object)this.currentPacks, pl -> pl.list().isHovered()), (PackLayout)ObjectsUtil.pick((Object)this.availablePacks, (Object)this.currentPacks, pl -> pl.list().isFocused())});
    }

    public ToggleableEditBox<Void> focusSearchField(@NotNull PackLayout packLayout) {
        if (!this.showActionBar) {
            this.toggleActionBar();
        }
        ToggleableEditBox<Void> searchField = packLayout.getSearchField();
        this.focus((GuiEventListener)searchField);
        return searchField;
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        PackLayout packLayout;
        if (super.charTyped(codePoint, modifiers)) {
            return true;
        }
        if (CollectionsUtil.anyMatch(this.dialogs, ToggleableDialog::isOpen)) {
            return false;
        }
        if (codePoint != ' ' && InputUtil.noModifiers(modifiers) && (packLayout = this.getLayoutFromSelectedList()) != null && !packLayout.getSearchField().isFocused()) {
            return this.focusSearchField(packLayout).charTyped(codePoint, modifiers);
        }
        return false;
    }

    public void toggleDevMode() {
        Config.get().setDevMode(!Config.get().isDevMode());
        ToastUtil.onDevModeToggleToast(Config.get().isDevMode());
        this.rebuildWidgets();
    }

    public void switchDefaultProfile() {
        this.options.getDefaultProfile().ifPresent(profile -> {
            if (Objects.equals(this.profiles.getProfile(), profile)) {
                this.profiles.setProfile(null);
            } else {
                this.profiles.setProfile((Profile)profile);
            }
        });
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        ToggleableEditBox<Void> searchField;
        PackLayout packLayout;
        this.contextMenu.setOpen(false);
        if (InputUtil.isDeveloperMode(keyCode, modifiers)) {
            this.toggleDevMode();
            return true;
        }
        if (InputUtil.isSwitchDefaultProfile(keyCode, modifiers)) {
            this.switchDefaultProfile();
            return true;
        }
        if (InputUtil.isRefresh(keyCode, modifiers) && (this.refreshFuture == null || this.refreshFuture.isDone())) {
            this.refreshPacks();
            return true;
        }
        if (InputUtil.isOpenProfiles(keyCode, modifiers)) {
            this.profiles.getSidebar().toggle();
            return true;
        }
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (InputUtil.isRedo(keyCode, modifiers) && this.isUnlocked()) {
            return this.history.redo();
        }
        if (InputUtil.isUndo(keyCode, modifiers) && this.isUnlocked()) {
            return this.history.undo();
        }
        if (PackedPacksScreen.isSelectAll((int)keyCode) && (packLayout = this.getLayoutFromSelectedList()) != null) {
            packLayout.list().selectAll();
            this.onEvent(new SelectionEvent(packLayout.list()));
            return true;
        }
        if (keyCode == 259 && (packLayout = this.getLayoutFromSelectedList()) != null && !(searchField = packLayout.getSearchField()).isFocused() && !searchField.getValue().isEmpty()) {
            return this.focusSearchField(packLayout).keyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    private boolean hasHeader(List<MenuItem> items) {
        return !items.isEmpty() && items.getFirst() instanceof PackMenuHeader;
    }

    private void openContextMenu(int mouseX, int mouseY) {
        if (this.contextMenu.isMouseOver((double)mouseX, (double)mouseY)) {
            return;
        }
        this.buildItems(mouseX, mouseY).when(Config.get().isDevMode()).ifTrue(dev -> dev.separatorIfNonEmpty().whenNonNull((Object)this.profiles.getProfile()).ifTrue((profile, b) -> b.add(GuiConstants.devItem((Component)ResourceUtil.getText("profile.save", new Object[0])).action(() -> profile.setPacks(this.currentPacks.list().copyPacks())).build()).separator()).add(GuiConstants.devItem((Component)ResourceUtil.getText("preferences", new Object[0])).addChildren(ToggleableHelper.preferences(this.original.packType())).addChild(GuiConstants.devItem((Component)ResourceUtil.getText("preferences.reset", new Object[0])).action(Preferences.INSTANCE::reset).build()).build())).separatorIfNonEmpty().simpleItem((Component)ResourceUtil.getText("reset_enabled", new Object[0]), this::isUnlocked, this::useSelected).simpleItem((Component)ResourceUtil.getText("refresh", new Object[0]), this::canRefresh, this::refreshPacks).when(this.additionalFolders, List::isEmpty).ifTrue(b -> b.simpleItem(OPEN_FOLDER_TEXT, this.repository::openDir)).orElse((dirs, b) -> b.parent(OPEN_FOLDER_TEXT, p -> p.add((MenuItem)new DirectoryMenuItem(this.repository.getBaseDir())).separator().iterate((Iterable)dirs).map(DirectoryMenuItem::new))).peek(items -> {
            int yOffset = this.hasHeader((List<MenuItem>)items) ? this.contextMenu.getItemHeight() : 0;
            this.contextMenu.open(mouseX, mouseY - yOffset, items);
        });
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.setDragged(null);
        if (InputUtil.isRightClick(button) && !this.optionsModal.isMouseOver(mouseX, mouseY)) {
            this.openContextMenu((int)mouseX, (int)mouseY);
            return true;
        }
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (InputUtil.isClickForward(button) && this.isUnlocked()) {
            return this.history.redo();
        }
        if (InputUtil.isClickBack(button) && this.isUnlocked()) {
            return this.history.undo();
        }
        if (InputUtil.isLeftClick(button) && !(this.getFocused() instanceof PackList)) {
            this.setFocused((GuiEventListener)this.children().getFirst());
            this.layout.visitWidgets(w -> w.setFocused(false));
        }
        this.contextMenu.setOpen(false);
        return false;
    }

    public List<ToggleableDialog<?>> getDialogs() {
        return this.dialogs;
    }

    @Nullable
    public GuiEventListener getHovered() {
        return this.hoveredElement;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.hoveredElement = this.findHovered(mouseX, mouseY);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (Config.get().isDevMode()) {
            float scale = 0.5f;
            float f = this.height;
            Objects.requireNonNull(this.font);
            int y = (int)((f - 9.0f * scale) / scale);
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().scale(scale);
            guiGraphics.drawString(this.font, (Component)ResourceUtil.getText("dev_mode", "CTRL + SHIFT + I"), 0, y, Theme.WHITE.getARGB());
            guiGraphics.pose().popMatrix();
        }
    }

    public boolean canRefresh() {
        return this.refreshFuture == null || this.refreshFuture.isDone();
    }

    public void clearHistory() {
        this.history.reset(this.captureState());
    }

    public void recordState(String eventName) {
        this.history.push(this.captureState(eventName));
    }

    @Override
    @NotNull
    public Snapshot captureState(String eventName) {
        return new Snapshot(this, (PackList.Snapshot)this.availablePacks.list().captureState(), (PackList.Snapshot)this.currentPacks.list().captureState());
    }

    @Override
    public void replaceState(@NotNull Snapshot snapshot) {
        ObjectOpenHashSet validPacks = new ObjectOpenHashSet(this.repository.getPacks());
        Query availablePacksQuery = snapshot.availablePacks.model().query();
        this.availablePacks.getSortButton().setValueSilently((CyclicButton.Option)availablePacksQuery.sort());
        this.availablePacks.getCompatButton().setValueSilently(availablePacksQuery.hideIncompatible());
        this.availablePacks.getSearchField().setValueSilently(availablePacksQuery.unmodifiedSearch());
        this.currentPacks.getSearchField().setValueSilently(snapshot.currentPacks().model().query().unmodifiedSearch());
        snapshot.availablePacks.retainAll((Set<Pack>)validPacks).restore();
        snapshot.currentPacks.retainAll((Set<Pack>)validPacks).restore();
        this.availablePacks.list().scrollToLastSelected();
        this.currentPacks.list().scrollToLastSelected();
    }

    public static final class Snapshot
    extends Record
    implements Restorable.Snapshot<Snapshot> {
        private final PackedPacksScreen target;
        private final PackList.Snapshot availablePacks;
        private final PackList.Snapshot currentPacks;

        public Snapshot(PackedPacksScreen target, PackList.Snapshot availablePacks, PackList.Snapshot currentPacks) {
            this.target = target;
            this.availablePacks = availablePacks;
            this.currentPacks = currentPacks;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Snapshot.class, "target;availablePacks;currentPacks", "target", "availablePacks", "currentPacks"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Snapshot.class, "target;availablePacks;currentPacks", "target", "availablePacks", "currentPacks"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Snapshot.class, "target;availablePacks;currentPacks", "target", "availablePacks", "currentPacks"}, this, o);
        }

        public PackedPacksScreen target() {
            return this.target;
        }

        public PackList.Snapshot availablePacks() {
            return this.availablePacks;
        }

        public PackList.Snapshot currentPacks() {
            return this.currentPacks;
        }
    }
}

