/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.pack;

import io.github.fishstiz.fidgetz.util.lang.FunctionsUtil;
import io.github.fishstiz.packed_packs.config.DevConfig;
import io.github.fishstiz.packed_packs.config.PackOptions;
import io.github.fishstiz.packed_packs.config.Profile;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PackOptionsResolver(Supplier<@Nullable Profile> profileSupplier, DevConfig.Packs config) implements PackOptions
{
    public static final PackOptionsResolver DATA_PACKS = new PackOptionsResolver(DevConfig.get().get(PackType.SERVER_DATA));
    public static final PackOptionsResolver RESOURCE_PACKS = new PackOptionsResolver(DevConfig.get().get(PackType.CLIENT_RESOURCES));

    public PackOptionsResolver(DevConfig.Packs config) {
        this(FunctionsUtil.nullSupplier(), config);
    }

    @Override
    public boolean isHidden(Pack pack) {
        return Boolean.TRUE.equals(this.inDefaultOrSelected(pack, Profile::isHidden, Profile::isHidden));
    }

    @Override
    public boolean isRequired(Pack pack) {
        return Boolean.TRUE.equals(this.inDefaultOrSelected(pack, Profile::overridesRequired, Profile::isRequired));
    }

    @Override
    public boolean isFixed(Pack pack) {
        return Boolean.TRUE.equals(this.inDefaultOrSelected(pack, Profile::overridesPosition, Profile::isFixed));
    }

    @Override
    @Nullable
    public Pack.Position getPosition(Pack pack) {
        return this.inDefaultOrSelected(pack, Profile::overridesPosition, Profile::getPosition);
    }

    @Override
    @Nullable
    public PackSelectionConfig getSelectionConfig(Pack pack) {
        return this.inDefaultOrSelected(pack, (profile, p) -> profile.overridesPosition((Pack)p) || profile.overridesRequired((Pack)p), Profile::getSelectionConfig);
    }

    public boolean isRequiredOrDefault(Pack pack) {
        return this.inDefaultOrSelected(pack, Profile::overridesRequired, Profile::isRequired, Pack::isRequired);
    }

    public boolean isFixedOrDefault(Pack pack) {
        return this.inDefaultOrSelected(pack, Profile::overridesPosition, Profile::isFixed, Pack::isFixedPosition);
    }

    @NotNull
    public Pack.Position getPositionOrDefault(Pack pack) {
        return Objects.requireNonNull(this.inDefaultOrSelected(pack, Profile::overridesPosition, Profile::getPosition, Pack::getDefaultPosition));
    }

    @NotNull
    public PackSelectionConfig getSelectionConfigOrDefault(Pack pack) {
        return Objects.requireNonNull(this.getOrDefault(pack, PackOptions::getSelectionConfig, Objects::nonNull, Pack::selectionConfig));
    }

    public boolean overridesRequired(Pack pack) {
        return this.hasOverride(pack, Profile::overridesRequired);
    }

    public boolean overridesPosition(Pack pack) {
        return this.hasOverride(pack, Profile::overridesPosition);
    }

    private boolean hasOverride(Pack pack, BiPredicate<Profile, Pack> option) {
        Profile defaultProfile = this.config.getDefaultProfile();
        Profile selected = this.profileSupplier.get();
        if (defaultProfile != null && option.test(defaultProfile, pack)) {
            return true;
        }
        return selected != null && option.test(selected, pack);
    }

    private <T> T getOrDefault(Pack pack, BiFunction<PackOptions, Pack, T> option, Predicate<T> predicate, Function<Pack, T> defaultValue) {
        T value = option.apply(this, pack);
        return predicate.test(value) ? value : defaultValue.apply(pack);
    }

    private <T> T inDefaultOrSelected(Pack pack, BiPredicate<Profile, Pack> shouldApply, BiFunction<Profile, Pack, T> option, Function<Pack, T> defaultValue) {
        Profile defaultProfile = this.config.getDefaultProfile();
        if (defaultProfile != null && shouldApply.test(defaultProfile, pack)) {
            return option.apply(defaultProfile, pack);
        }
        Profile selected = this.profileSupplier.get();
        if (selected != null && shouldApply.test(selected, pack)) {
            return option.apply(selected, pack);
        }
        return defaultValue.apply(pack);
    }

    @Nullable
    private <T> T inDefaultOrSelected(Pack pack, BiPredicate<Profile, Pack> shouldApply, BiFunction<Profile, Pack, T> option) {
        return (T)this.inDefaultOrSelected(pack, shouldApply, option, p -> null);
    }
}

