/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.util;

import net.minecraft.client.gui.screens.Screen;

public class InputUtil {
    public static final String DEV_MODE_SHORTCUT = "CTRL + SHIFT + I";
    public static final long DOUBLE_CLICK_THRESHOLD_MS = 250L;
    public static final int MOUSE_BUTTON_BACK = 3;
    public static final int MOUSE_BUTTON_FORWARD = 4;
    public static final int MOD_SHIFT = 1;
    public static final int MOD_ALT = 4;

    private InputUtil() {
    }

    public static boolean isLeftClick(int button) {
        return button == 0;
    }

    public static boolean isRightClick(int button) {
        return button == 1;
    }

    public static boolean isClickBack(int button) {
        return button == 3;
    }

    public static boolean isClickForward(int button) {
        return button == 4;
    }

    public static boolean isUndo(int keyCode, int modifiers) {
        return keyCode == 90 && Screen.hasControlDown() && modifiers == 2;
    }

    public static boolean isRedo(int keyCode, int modifiers) {
        if (keyCode == 90) {
            return Screen.hasControlDown() && Screen.hasShiftDown() && modifiers == 3;
        }
        if (keyCode == 89) {
            return Screen.hasControlDown() && modifiers == 2;
        }
        return false;
    }

    public static boolean isTransfer(int keyCode, int modifiers) {
        return InputUtil.noModifiers(modifiers) && (keyCode == 32 || keyCode == 257);
    }

    public static boolean isMoveDown(int keyCode, int modifiers) {
        return keyCode == 264 && InputUtil.moveModifiers(modifiers);
    }

    public static boolean isMoveUp(int keyCode, int modifiers) {
        return keyCode == 265 && InputUtil.moveModifiers(modifiers);
    }

    public static boolean isExpandFolder(int keyCode, int modifiers) {
        return InputUtil.noModifiers(modifiers) && keyCode == 257;
    }

    public static boolean isDelete(int keyCode, int modifiers) {
        return InputUtil.noModifiers(modifiers) && keyCode == 261;
    }

    public static boolean isRename(int keyCode, int modifiers) {
        return InputUtil.noModifiers(modifiers) && keyCode == 291 || modifiers == 2 && keyCode == 82;
    }

    public static boolean isRefresh(int keyCode, int modifiers) {
        return InputUtil.noModifiers(modifiers) && keyCode == 294;
    }

    public static boolean isOpenFile(int keyCode, int modifiers) {
        return modifiers == 2 && keyCode == 257;
    }

    public static boolean isOpenFolder(int keyCode, int modifiers) {
        return modifiers == 5 && keyCode == 82;
    }

    public static boolean isDeveloperMode(int keyCode, int modifiers) {
        return InputUtil.noModifiers(modifiers) && keyCode == 301 || modifiers == 3 && keyCode == 73;
    }

    public static boolean isSelectAll(int keyCode, int modifiers) {
        return modifiers == 2 && keyCode == 65;
    }

    public static boolean isSwitchDefaultProfile(int keyCode, int modifiers) {
        return InputUtil.noModifiers(modifiers) && keyCode == 290;
    }

    public static boolean isOpenProfiles(int keyCode, int modifiers) {
        return modifiers == 2 && keyCode == 96;
    }

    public static boolean noModifiers(int modifiers) {
        return modifiers == 0;
    }

    public static boolean moveModifiers(int modifiers) {
        return modifiers == 2 || modifiers == 4;
    }

    public static boolean isRangeModifierActive() {
        return Screen.hasShiftDown();
    }

    public static boolean isSelectModifierActive() {
        return Screen.hasControlDown();
    }
}

