/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.history;

import io.github.fishstiz.packed_packs.gui.history.Restorable;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

public class HistoryManager<T extends Restorable.Snapshot<T>> {
    private static final int DEFAULT_CAPACITY = 25;
    private final int capacity;
    private final Deque<Restorable.Snapshot<T>> history;
    private final Deque<Restorable.Snapshot<T>> undone;

    public HistoryManager(Restorable.Snapshot<T> initialState, int capacity) {
        this.capacity = capacity;
        this.history = new ArrayDeque<Restorable.Snapshot<T>>(capacity);
        this.undone = new ArrayDeque<Restorable.Snapshot<T>>(capacity);
        this.push(initialState);
    }

    public HistoryManager() {
        this(null, 25);
    }

    public void push(Restorable.Snapshot<T> snapshot) {
        if (snapshot == null) {
            return;
        }
        while (this.history.size() >= this.capacity) {
            this.history.removeFirst();
        }
        this.undone.clear();
        this.history.addLast(snapshot);
    }

    public boolean undo() {
        if (this.history.size() > 1) {
            this.undone.addLast(this.history.removeLast());
            this.history.getLast().restore();
            return true;
        }
        return false;
    }

    public boolean redo() {
        if (!this.undone.isEmpty()) {
            Restorable.Snapshot<T> snapshot = this.undone.removeLast();
            snapshot.restore();
            this.history.addLast(snapshot);
            return true;
        }
        return false;
    }

    public void reset(Restorable.Snapshot<T> initialState) {
        this.history.clear();
        this.undone.clear();
        this.push(initialState);
    }

    public List<Restorable.Snapshot<T>> getStack() {
        ObjectArrayList stack = new ObjectArrayList(this.history.size() + this.undone.size());
        stack.addAll(this.history);
        stack.addAll(this.undone);
        return stack;
    }

    public int stackIndex() {
        if (this.history.isEmpty()) {
            return -1;
        }
        return this.history.size() - 1;
    }

    public void restore(int index) {
        int i;
        List<Restorable.Snapshot<T>> stack = this.getStack();
        int totalSize = stack.size();
        if (index < 0 || index >= totalSize) {
            return;
        }
        this.history.clear();
        this.undone.clear();
        for (i = 0; i <= index; ++i) {
            this.history.addLast(stack.get(i));
        }
        for (i = index + 1; i < totalSize; ++i) {
            this.undone.addLast(stack.get(i));
        }
        if (!this.history.isEmpty()) {
            this.history.getLast().restore();
        }
    }
}

