/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.fishstiz.packed_packs.compat.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.packed_packs.gui.components.events.DragEvent;
import io.github.fishstiz.packed_packs.gui.components.events.DragEventHandler;
import io.github.fishstiz.packed_packs.gui.components.events.DragEventRenderer;
import io.github.fishstiz.packed_packs.gui.components.events.DropEvent;
import io.github.fishstiz.packed_packs.gui.components.events.MoveEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.gui.components.events.RequestTransferEvent;
import io.github.fishstiz.packed_packs.gui.components.events.SelectionEvent;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.pack.PackAssetManager;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PackListEventHandler
extends Screen
implements PackListEventListener,
DragEventHandler {
    protected final PackAssetManager assetManager;
    private final DragEventRenderer dragEventRenderer;
    private DragEvent dragged;

    protected PackListEventHandler(Minecraft minecraft, Component title) {
        super(title);
        this.minecraft = minecraft;
        this.assetManager = new PackAssetManager(minecraft);
        this.dragEventRenderer = new DragEventRenderer(this.assetManager);
    }

    protected void focus(ComponentPath path) {
        this.clearFocus();
        path.applyFocus(true);
    }

    protected void focus(GuiEventListener element) {
        this.focus(ComponentPath.path((GuiEventListener)element, (ContainerEventHandler[])new ContainerEventHandler[]{this}));
    }

    protected void focusList(PackList packList) {
        PackList.Entry entry = packList.getSelected();
        if (entry != null) {
            this.focus(ComponentPath.path((GuiEventListener)entry, (ContainerEventHandler[])new ContainerEventHandler[]{packList, this}));
        } else {
            this.focus(ComponentPath.path((GuiEventListener)packList, (ContainerEventHandler[])new ContainerEventHandler[]{this}));
        }
    }

    protected void transferFocus(PackList source, PackList destination) {
        source.setFocused(null);
        this.focusList(destination);
    }

    protected void unfocusOtherLists(PackList focused) {
        for (PackList packList : this.getPackLists()) {
            if (packList == focused) continue;
            packList.setFocused(null);
        }
    }

    protected void handleRequestTransferEvent(RequestTransferEvent event) {
        PackList source = event.target();
        PackList destination = this.getDestination(source);
        if (destination == null || event.payload().isEmpty()) {
            return;
        }
        destination.clearSelection();
        source.removeAll(event.payload());
        destination.addAll(event.payload());
        destination.selectAll(event.payload());
        destination.select(event.trigger());
        this.transferFocus(source, destination);
    }

    @Override
    public void handleDragEvent(DragEvent event) {
        DragEventHandler.super.handleDragEvent(event);
        this.unfocusOtherLists(event.target());
    }

    protected void handleMoveEvent(MoveEvent event) {
        PackList.Entry entry = event.target().getEntry(event.trigger());
        if (entry != null) {
            this.focus(ComponentPath.path((GuiEventListener)entry, (ContainerEventHandler[])new ContainerEventHandler[]{event.target(), this}));
        } else {
            this.focus((GuiEventListener)event.target());
        }
    }

    @Override
    @Nullable
    public DragEvent getDragged() {
        return this.dragged;
    }

    @Override
    public void setDragged(@Nullable DragEvent dragged) {
        this.dragged = dragged;
    }

    @NotNull
    public abstract List<PackList> getPackLists();

    @Nullable
    protected abstract PackList getDestination(PackList var1);

    public abstract boolean isUnlocked();

    @Override
    public void onEvent(PackListEvent event) {
        PackListEvent packListEvent = event;
        Objects.requireNonNull(packListEvent);
        PackListEvent packListEvent2 = packListEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SelectionEvent.class, RequestTransferEvent.class, MoveEvent.class, DragEvent.class, DropEvent.class}, (Object)packListEvent2, n)) {
            case 0: {
                SelectionEvent selection = (SelectionEvent)packListEvent2;
                this.unfocusOtherLists(selection.target());
                break;
            }
            case 1: {
                RequestTransferEvent request = (RequestTransferEvent)packListEvent2;
                this.handleRequestTransferEvent(request);
                break;
            }
            case 2: {
                MoveEvent move = (MoveEvent)packListEvent2;
                this.handleMoveEvent(move);
                break;
            }
            case 3: {
                DragEvent drag = (DragEvent)packListEvent2;
                this.handleDragEvent(drag);
                break;
            }
            case 4: {
                DropEvent drop = (DropEvent)packListEvent2;
                this.transferFocus(drop.target(), drop.destination());
                break;
            }
        }
    }

    @Override
    public void onRelease(@NotNull DragEvent event, double mouseX, double mouseY) {
        List<PackList> packLists = this.getPackLists();
        for (int i = packLists.size() - 1; i >= 0; --i) {
            PackList packList = packLists.get(i);
            if (!packList.isHovered()) continue;
            packList.drop(event, mouseX, mouseY);
            return;
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        DragEvent event = this.getDragged();
        if (event != null) {
            PackList source = event.target();
            boolean validDrop = false;
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, this.getDroppableZ());
            if (this.isUnlocked()) {
                for (PackList list : this.getPackLists()) {
                    list.renderDroppableZone(guiGraphics, event, mouseX, mouseY, partialTick);
                    if (validDrop || !list.isMouseOver(mouseX, mouseY)) continue;
                    validDrop = source == list || source.canInteract(list);
                }
            }
            poseStack.translate(0.0f, 0.0f, 1.0f);
            this.dragEventRenderer.renderDragEvent(event, guiGraphics, mouseX, mouseY, partialTick);
            poseStack.popPose();
            MinecraftCursor.handleDrag(validDrop);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.isDraggingSelection() || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return this.isDraggingSelection() || super.charTyped(codePoint, modifiers);
    }
}

