/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.pack.folder;

import io.github.fishstiz.fidgetz.util.lang.ObjectsUtil;
import io.github.fishstiz.packed_packs.config.Folder;
import io.github.fishstiz.packed_packs.config.JsonLoader;
import io.github.fishstiz.packed_packs.pack.folder.FolderResourcesSupplier;
import io.github.fishstiz.packed_packs.transform.interfaces.FilePack;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.world.flag.FeatureFlagSet;
import org.jetbrains.annotations.Nullable;

public class FolderPack
extends Pack
implements FilePack {
    public static final Component FOLDER_OPEN_TEXT = ResourceUtil.getText("folder.open", new Object[0]);
    public static final Component FOLDER_DESCRIPTION = ResourceUtil.getText("folder", new Object[0]);
    public static final PackSelectionConfig FOLDER_SELECTION_CONFIG = new PackSelectionConfig(false, Pack.Position.TOP, false);
    public static final Pack.Metadata FOLDER_METADATA = new Pack.Metadata(FOLDER_DESCRIPTION, PackCompatibility.COMPATIBLE, FeatureFlagSet.of(), Collections.emptyList());
    private final Function<String, List<Pack>> nestedPacksProvider;
    private final Path path;

    public FolderPack(String id, String name, Function<String, List<Pack>> nestedPacksProvider, Path path) {
        super(new PackLocationInfo(id, (Component)Component.literal((String)name), PackUtil.PACK_SOURCE, Optional.empty()), (Pack.ResourcesSupplier)new FolderResourcesSupplier(path), FOLDER_METADATA, FOLDER_SELECTION_CONFIG);
        this.nestedPacksProvider = nestedPacksProvider;
        this.path = path;
    }

    public List<Pack> flatten() {
        ObjectArrayList result = new ObjectArrayList();
        result.add(this);
        result.addAll((Collection)ObjectsUtil.getOrDefault(this.nestedPacksProvider.apply(this.getId()), Collections.emptyList()));
        return result;
    }

    public CompletableFuture<Folder> loadConfig() {
        return CompletableFuture.supplyAsync(() -> {
            try (PackResources resources = this.open();){
                Folder folder;
                block16: {
                    IoSupplier configIoSupplier = resources.getRootResource(new String[]{"packed_packs.folderpack.json"});
                    if (configIoSupplier == null) {
                        throw new IOException();
                    }
                    InputStream inputStream = (InputStream)configIoSupplier.get();
                    try {
                        folder = JsonLoader.loadJson(inputStream, Folder.class);
                        if (inputStream == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    inputStream.close();
                }
                return folder;
            }
            catch (NoSuchFileException e) {
                return (Folder)ObjectsUtil.peek((Object)new Folder(), this::saveConfig);
            }
            catch (IOException e) {
                return new Folder();
            }
        }, Util.backgroundExecutor());
    }

    public void saveConfig(Folder folder) {
        if (folder != null) {
            folder.save(this.path.resolve("packed_packs.folderpack.json"));
        }
    }

    @Override
    @Nullable
    public Path packed_packs$getPath() {
        return this.path;
    }
}

