/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.transform.mixin.overrides;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.pack.PackOptionsResolver;
import io.github.fishstiz.packed_packs.transform.interfaces.ConfiguredPack;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Pack.class})
public abstract class PackMixin
implements ConfiguredPack {
    @Shadow
    @Final
    private Pack.Metadata metadata;
    @Shadow
    @Final
    private PackSelectionConfig selectionConfig;
    @Unique
    @Nullable
    private PackOptionsResolver packed_packs$resolver;

    @Override
    public void packed_packs$setConfigurationResolver(PackOptionsResolver resolver) {
        this.packed_packs$resolver = resolver;
    }

    @Override
    public boolean packed_packs$isHidden() {
        return this.packed_packs$resolver != null && this.packed_packs$resolver.isHidden(this.self());
    }

    @Unique
    private Pack self() {
        return (Pack)this;
    }

    @WrapMethod(method={"isRequired"})
    private boolean resolveRequired(Operation<Boolean> original) {
        PackOptionsResolver resolver = this.packed_packs$resolver;
        if (resolver != null && resolver.overridesRequired(this.self())) {
            return resolver.isRequired(this.self());
        }
        return (Boolean)original.call(new Object[0]);
    }

    @WrapMethod(method={"isFixedPosition"})
    private boolean resolveFixed(Operation<Boolean> original) {
        PackOptionsResolver resolver = this.packed_packs$resolver;
        if (resolver != null && resolver.overridesPosition(this.self())) {
            return resolver.isFixed(this.self());
        }
        return (Boolean)original.call(new Object[0]);
    }

    @WrapMethod(method={"getDefaultPosition"})
    private Pack.Position resolvePosition(Operation<Pack.Position> original) {
        Pack.Position position;
        if (this.packed_packs$resolver != null && (position = this.packed_packs$resolver.getPosition(this.self())) != null) {
            return position;
        }
        return (Pack.Position)original.call(new Object[0]);
    }

    @WrapMethod(method={"selectionConfig"})
    private PackSelectionConfig resolveSelectionConfig(Operation<PackSelectionConfig> original) {
        PackSelectionConfig selectionConfig;
        if (this.packed_packs$resolver != null && (selectionConfig = this.packed_packs$resolver.getSelectionConfig(this.self())) != null) {
            return selectionConfig;
        }
        return (PackSelectionConfig)original.call(new Object[0]);
    }

    @WrapMethod(method={"getCompatibility"})
    private PackCompatibility resolveCompatibility(Operation<PackCompatibility> original) {
        Profile defaultProfile;
        if (this.packed_packs$resolver != null && (defaultProfile = this.packed_packs$resolver.config().getDefaultProfile()) != null && defaultProfile.includes(this.self())) {
            return PackCompatibility.COMPATIBLE;
        }
        return (PackCompatibility)original.call(new Object[0]);
    }

    @Override
    public boolean packed_packs$isConfigured() {
        if (this.packed_packs$resolver != null) {
            Profile defaultProfile = this.packed_packs$resolver.config().getDefaultProfile();
            return defaultProfile != null && defaultProfile.includes(this.self());
        }
        return false;
    }

    @Override
    public Pack.Metadata packed_packs$getMetadata() {
        return this.metadata;
    }

    @Override
    public PackSelectionConfig packed_packs$originalConfig() {
        return this.selectionConfig;
    }
}

