/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.util;

import io.github.fishstiz.packed_packs.util.ResourceUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class ToastUtil {
    private static final SystemToast.SystemToastId FILE_OPS_FAIL_ID = new SystemToast.SystemToastId();
    private static final SystemToast.SystemToastId DEV_MODE_ID = new SystemToast.SystemToastId(750L);

    private ToastUtil() {
    }

    public static void onDevModeToggleToast(boolean enabled) {
        Component enableText = enabled ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF;
        SystemToast.addOrUpdate((ToastComponent)Minecraft.getInstance().getToasts(), (SystemToast.SystemToastId)DEV_MODE_ID, (Component)ResourceUtil.getModName(), (Component)ResourceUtil.getText("dev_mode", enableText));
    }

    public static void onFileFailToast(Component message) {
        SystemToast.addOrUpdate((ToastComponent)Minecraft.getInstance().getToasts(), (SystemToast.SystemToastId)FILE_OPS_FAIL_ID, (Component)ResourceUtil.getText("file.fail", new Object[0]), (Component)message);
    }

    public static Component getRenameFailText(String from, String to) {
        return ResourceUtil.getText("file.rename.fail", from, to);
    }

    public static Component getDeleteFailText(String fileName) {
        return ResourceUtil.getText("file.delete.fail", fileName);
    }
}

