package io.github.fishstiz.packed_packs.compat.etf;

import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.packed_packs.compat.Mod;
import io.github.fishstiz.packed_packs.compat.ModContext;
import io.github.fishstiz.packed_packs.compat.ModExtensionInternal;
import io.github.fishstiz.packed_packs.config.ModPreferences;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.gui.components.ToggleableHelper;
import io.github.fishstiz.packed_packs.gui.screens.PackedPacksScreen;
import net.minecraft.class_3264;
import net.minecraft.class_5375;

public class ETFModExtension implements ModExtensionInternal {
    @Override
    public ModContext mod() {
        return Mod.ETF;
    }

    @Override
    public void onCreateHeader(class_3264 type, FlexLayout header, PackedPacksScreen screen, class_5375 original) {
        if (type != class_3264.field_14188) return;

        this.mod().wrapError(header, screen, (layout, prev) -> {
            if (Config.get().isDevMode() || ModPreferences.ETF_BUTTON.isEnabled()) {
                layout.addChild(ETFButtonFactory.create(prev));
            }
        });
    }

    @Override
    public void onCreatePreferencesMenu(class_3264 type, ContextMenuItemBuilder builder) {
        if (type != class_3264.field_14188) return;

        this.mod().wrapError(builder, b -> b.add(ToggleableHelper.fromPref(ModPreferences.ETF_BUTTON.get())));
    }
}
