package io.github.fishstiz.packed_packs.pack.folder;

import io.github.fishstiz.packed_packs.util.PackUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_7367;
import net.minecraft.class_9224;

public record FolderResources(class_9224 location, Path path) implements class_3262 {
    public static final String FOLDER_CONFIG_FILENAME = "packed_packs.folderpack.json";

    @Override
    public @Nullable class_7367<InputStream> method_14410(String... elements) {
        if (elements.length > 0) {
            if (Objects.equals(elements[0], PackUtil.ICON_FILENAME)) {
                return () -> Files.newInputStream(this.path.resolve(PackUtil.ICON_FILENAME));
            } else if (Objects.equals(elements[0], FOLDER_CONFIG_FILENAME)) {
                return () -> Files.newInputStream(this.path.resolve(FOLDER_CONFIG_FILENAME));
            }
        }
        return null;
    }

    @Override
    public @Nullable class_7367<InputStream> method_14405(class_3264 packType, class_2960 location) {
        return null;
    }

    @Override
    public void method_14408(class_3264 packType, String namespace, String path, class_7664 resourceOutput) {
        // no-op
    }

    @Override
    public @NotNull Set<String> method_14406(class_3264 type) {
        return Collections.emptySet();
    }

    @Override
    public @Nullable <T> T method_14407(class_3270<T> deserializer) {
        return null;
    }

    @Override
    public void close() {
        // no-op
    }
}