package io.github.fishstiz.packed_packs.transform.mixin;

import io.github.fishstiz.fidgetz.util.lang.FunctionsUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_5369;

@Mixin(class_5369.class)
public abstract class PackSelectionModelMixin implements PackSelectionModelAccessor {
    @Shadow
    @Final
    List<class_3288> unselected;

    @Shadow
    @Final
    List<class_3288> selected;

    @Shadow
    @Final
    private class_3283 repository;

    @Shadow
    @Final
    Function<class_3288, class_2960> iconGetter;

    @Shadow
    @Final
    private Consumer<class_3283> output;

    @Override
    public void packed_packs$reset() {
        // needs to be reset when packs are updated in PackedPacksScreen, and user returns to original screen

        PackSelectionModelAccessor model = (PackSelectionModelAccessor) new class_5369(
                FunctionsUtil.nop(),
                this.iconGetter,
                this.repository,
                this.output
        );

        this.selected.clear();
        this.selected.addAll(model.getSelectedPacks());

        this.unselected.clear();
        this.unselected.addAll(model.getSelectedPacks());
    }
}
