package io.github.fishstiz.packed_packs.transform.mixin.overrides;

import io.github.fishstiz.packed_packs.config.DevConfig;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.fidgetz.util.lang.CollectionsUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

import java.util.List;
import net.minecraft.class_525;
import net.minecraft.class_5359;
import net.minecraft.class_7712;

@Mixin(class_525.class)
public abstract class CreateWorldScreenMixin {
    @ModifyArg(method = "openFresh", at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/gui/screens/worldselection/CreateWorldScreen;createDefaultLoadConfig(Lnet/minecraft/server/packs/repository/PackRepository;Lnet/minecraft/world/level/WorldDataConfiguration;)Lnet/minecraft/server/WorldLoader$InitConfig;"
    ))
    private static class_7712 applyDefaultProfile(class_7712 worldDataConfiguration) {
        Profile defaultProfile = DevConfig.get().getDatapacks().getDefaultProfile();
        if (defaultProfile == null) return worldDataConfiguration;

        class_5359 dataPackConfig = worldDataConfiguration.comp_1010();
        List<String> disabled = CollectionsUtil.addAll(dataPackConfig.method_29550(), dataPackConfig.method_29547());
        List<String> enabled = defaultProfile.getPackIds().reversed();
        disabled.removeAll(enabled);

        return new class_7712(new class_5359(enabled, disabled), worldDataConfiguration.comp_1011());
    }
}
