/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.config;

import io.github.fishstiz.fidgetz.util.lang.CollectionsUtil;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.config.JsonLoader;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.config.Profiles;
import io.github.fishstiz.packed_packs.util.AliasRegex;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.class_3264;
import org.jetbrains.annotations.Nullable;

public class DevConfig
implements Serializable {
    private static final String FILENAME = "config.meta.json";
    private static final DevConfig INSTANCE = DevConfig.loadOrDefault();
    private final ResourcePacks resourcepacks = new ResourcePacks();
    private final DataPacks datapacks = new DataPacks();

    private static Path getPath() {
        return PackedPacks.getConfigDir().resolve(FILENAME);
    }

    private static DevConfig loadOrDefault() {
        return JsonLoader.loadJsonOrDefault(DevConfig.getPath(), DevConfig.class, DevConfig::new);
    }

    public static DevConfig get() {
        return INSTANCE;
    }

    public void save() {
        JsonLoader.saveJson(this, DevConfig.getPath());
    }

    private DevConfig() {
    }

    public Packs get(class_3264 packType) {
        return switch (packType) {
            default -> throw new MatchException(null, null);
            case class_3264.field_14188 -> this.resourcepacks;
            case class_3264.field_14190 -> this.datapacks;
        };
    }

    public DataPacks getDatapacks() {
        return this.datapacks;
    }

    public ResourcePacks getResourcepacks() {
        return this.resourcepacks;
    }

    public static final class ResourcePacks
    extends Packs {
        @Override
        public class_3264 packType() {
            return class_3264.field_14188;
        }
    }

    public static final class DataPacks
    extends Packs {
        @Override
        public class_3264 packType() {
            return class_3264.field_14190;
        }
    }

    public static abstract sealed class Packs
    implements Serializable
    permits ResourcePacks, DataPacks {
        private final Map<String, String> aliases = new Object2ObjectLinkedOpenHashMap();
        @Nullable
        private transient Map<Pattern, String> aliasPatterns;
        private transient List<Pair<String, String>> remappedPacks;
        @Nullable
        private String defaultProfile;
        private transient Profile cachedDefaultProfile;

        public abstract class_3264 packType();

        public Set<String> getAliases() {
            return this.aliases.keySet();
        }

        public List<String> getAliases(String packId) {
            return CollectionsUtil.reverseLookup((Object)packId, this.aliases);
        }

        public boolean hasAlias(String packId) {
            return this.aliases.containsValue(packId);
        }

        @Nullable
        public String getAndSaveCanonicalId(Collection<Profile> profiles, String packId) {
            String canonicalId = this.aliases.get(packId);
            if (canonicalId != null) {
                this.savePackIdsOnResolve(profiles, packId, canonicalId);
                return canonicalId;
            }
            Map<Pattern, String> patternMap = this.getAliasPatterns();
            if (patternMap != null && (canonicalId = AliasRegex.resolveCanonicalId(packId, patternMap)) != null) {
                PackedPacks.LOGGER.info("[packed_packs] Resolved unknown pack '{}' to '{}' with regex, caching result.", (Object)packId, (Object)canonicalId);
                this.savePackIdsOnResolve(profiles, packId, canonicalId);
            }
            return canonicalId;
        }

        @Nullable
        private Map<Pattern, String> getAliasPatterns() {
            if (this.aliases.isEmpty()) {
                return null;
            }
            if (this.aliasPatterns == null) {
                this.aliasPatterns = AliasRegex.findPatternsFromKeys(this.aliases);
            }
            return this.aliasPatterns;
        }

        private void savePackIdsOnResolve(Collection<Profile> profiles, String packId, String canonicalId) {
            if (!this.aliases.containsKey(packId)) {
                Profile defaultProfile;
                this.aliases.put(packId, canonicalId);
                this.aliases.remove(canonicalId);
                if (this.remappedPacks == null) {
                    this.remappedPacks = new ObjectArrayList();
                }
                if ((defaultProfile = this.getDefaultProfile()) != null && defaultProfile.remapPackId(packId, canonicalId)) {
                    Profiles.save(this.packType(), defaultProfile);
                }
                for (Profile profile : profiles) {
                    if (Objects.equals(profile, defaultProfile) || !profile.remapPackId(packId, canonicalId)) continue;
                    Profiles.save(this.packType(), profile);
                }
                DevConfig.get().save();
            }
        }

        public void setAliases(String packId, List<String> aliases) {
            CollectionsUtil.updateReverseMapping(this.aliases, (Object)packId, aliases);
        }

        @Nullable
        public Profile getDefaultProfile() {
            if (this.defaultProfile == null) {
                return null;
            }
            if (this.cachedDefaultProfile != null) {
                return this.cachedDefaultProfile;
            }
            this.cachedDefaultProfile = Profiles.get(this.packType(), this.defaultProfile);
            if (this.cachedDefaultProfile == null) {
                this.defaultProfile = null;
            }
            return this.cachedDefaultProfile;
        }

        void setDefaultProfile(@Nullable String profileId) {
            this.defaultProfile = profileId;
            this.cachedDefaultProfile = null;
        }

        public void setDefaultProfile(@Nullable Profile profile) {
            this.defaultProfile = profile == null ? null : profile.getId();
            this.cachedDefaultProfile = profile;
        }
    }
}

