/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.FidgetzText;
import io.github.fishstiz.fidgetz.gui.components.LayoutWrapper;
import io.github.fishstiz.fidgetz.gui.components.Modal;
import io.github.fishstiz.fidgetz.gui.components.RenderableRectWidget;
import io.github.fishstiz.fidgetz.gui.components.ToggleableEditBox;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.fidgetz.gui.renderables.RenderableRect;
import io.github.fishstiz.fidgetz.util.DrawUtil;
import io.github.fishstiz.packed_packs.gui.components.events.FileRenameCloseEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FileRenameEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.pack.PackAssetManager;
import io.github.fishstiz.packed_packs.pack.PackFileOperations;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.ToastUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_8016;
import net.minecraft.class_8021;
import net.minecraft.class_8023;
import net.minecraft.class_8027;
import net.minecraft.class_8028;
import net.minecraft.class_8133;
import net.minecraft.class_8667;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileRenameModal
extends Modal<class_8667> {
    private static final int MAX_LENGTH = 255;
    private static final int CONTENT_WIDTH = 256;
    private static final int SHADOW_SIZE = 24;
    private static final Pattern ILLEGAL_CHAR_PATTERN = Pattern.compile(".*[<>:\"/\\\\|?*].*");
    private final RenderableRectWidget<Void> sprite;
    private final FidgetzText<Void> title;
    private final ToggleableEditBox<Void> nameEditor;
    private final FidgetzButton<Void> saveButton;
    private final PackFileOperations fileOps;
    private final PackAssetManager assets;
    private PackList packList;
    private class_3288 pack;
    private String oldName;

    public <S extends class_437 & PackListEventListener> FileRenameModal(S screen, PackFileOperations fileOps, PackAssetManager assets) {
        super(Modal.builder(screen, (class_8133)class_8667.method_52741().method_52735(8)).padding(8));
        this.fileOps = fileOps;
        this.assets = assets;
        this.sprite = ((RenderableRectWidget.Builder)RenderableRectWidget.builder((RenderableRect)PackAssetManager.DEFAULT_ICON).makeSquare()).build();
        this.title = ((FidgetzText.Builder)FidgetzText.builder().makeSquare()).setOffsetY(1).setShadow(true).build();
        FidgetzButton closeButton = ((FidgetzButton.Builder)FidgetzButton.builder().makeSquare()).setOnPress(() -> ((FileRenameModal)this).closeModal()).setSprite(GuiConstants.CROSS_SPRITE).build();
        this.nameEditor = ((ToggleableEditBox.Builder)ToggleableEditBox.builder().setWidth(256)).setEditable(true).addListener(this::handleChange).setMaxLength(255).setFilter(this::testInput).build();
        FidgetzButton cancelButton = FidgetzButton.builder().setOnPress(() -> ((FileRenameModal)this).closeModal()).setMessage(class_5244.field_24335).build();
        this.saveButton = FidgetzButton.builder().setOnPress(this::saveName).setMessage(class_5244.field_24334).build();
        FlexLayout titleLayout = FlexLayout.horizontal(this::getContentWidth).spacing(8);
        titleLayout.addChild(this.sprite);
        titleLayout.addFlexChild(this.title);
        titleLayout.addChild((class_8021)closeButton);
        FlexLayout buttonLayout = FlexLayout.horizontal(this::getContentWidth).spacing(8);
        buttonLayout.addFlexChild((class_339)cancelButton);
        buttonLayout.addFlexChild(this.saveButton);
        ((class_8667)((LayoutWrapper)this.root()).layout()).method_52736((class_8021)titleLayout);
        ((class_8667)((LayoutWrapper)this.root()).layout()).method_52736(this.nameEditor);
        ((class_8667)((LayoutWrapper)this.root()).layout()).method_52736((class_8021)buttonLayout);
        ((LayoutWrapper)this.root()).method_48206(arg_0 -> ((FileRenameModal)this).addRenderableWidget(arg_0));
        this.addListener(this::onClose);
    }

    private int getContentWidth() {
        return 256;
    }

    private void clearReferences() {
        this.packList = null;
        this.pack = null;
        this.oldName = null;
        this.sprite.setRenderableRect((RenderableRect)PackAssetManager.DEFAULT_ICON);
        this.title.method_25355(class_5244.field_39003);
        this.nameEditor.method_1852("");
    }

    public void open(PackList packList, class_3288 pack) {
        this.packList = packList;
        this.pack = pack;
        this.sprite.setRenderableRect((RenderableRect)this.assets.getIcon(pack));
        this.title.method_25355(pack.method_14457());
        this.oldName = FileRenameModal.sanitizeNameForEdit(pack);
        this.nameEditor.method_1852(this.oldName);
        this.nameEditor.method_1887(PackUtil.isZipPack(pack) ? ".zip" : null);
        this.saveButton.field_22763 = false;
        this.repositionElements();
        this.setOpen(true);
    }

    private boolean testInput(String input) {
        if (input == null || !input.isEmpty() && input.isBlank()) {
            return false;
        }
        return FileRenameModal.testIllegalChars(input);
    }

    private boolean canSave(String input) {
        if (input == null || input.isBlank()) {
            return false;
        }
        if (this.pack == null || PackUtil.validatePackPath(this.pack) == null) {
            return false;
        }
        String trimmed = input.trim();
        if (Objects.equals(this.oldName, trimmed)) {
            return false;
        }
        return FileRenameModal.testIllegalChars(input);
    }

    private void handleChange(String name) {
        this.saveButton.field_22763 = this.canSave(name);
    }

    private void onClose(boolean open) {
        if (open) {
            return;
        }
        PackList target = this.packList;
        class_3288 trigger = this.pack;
        if (target != null) {
            ((PackListEventListener)this.screen).onEvent(new FileRenameCloseEvent(target, trigger));
        }
        this.clearReferences();
    }

    private void saveName() {
        String newName = this.nameEditor.method_1882();
        if (!this.canSave(newName)) {
            return;
        }
        String sanitizedName = FileRenameModal.sanitizeNameForSave(this.pack, newName);
        if (this.fileOps.renamePack(this.pack, sanitizedName)) {
            PackList.Entry entry;
            class_5250 sanitizedNameText = class_2561.method_43470((String)sanitizedName);
            if (this.packList != null && (entry = this.packList.getEntry(this.pack)) != null) {
                entry.onRename((class_2561)sanitizedNameText);
            }
            ((PackListEventListener)this.screen).onEvent(new FileRenameEvent(this.packList, this.pack, (class_2561)sanitizedNameText));
            this.setOpen(false);
            this.clearReferences();
        } else {
            ToastUtil.onFileFailToast(ToastUtil.getRenameFailText(this.pack.method_14457().getString(), newName));
        }
    }

    private static String sanitizeNameForEdit(class_3288 pack) {
        String name = pack.method_14457().getString();
        return PackUtil.isZipPack(pack) ? name.replaceFirst(Pattern.quote(".zip") + "$", "") : name;
    }

    private static String sanitizeNameForSave(class_3288 pack, String newName) {
        newName = FilenameUtils.getName((String)newName).trim();
        return PackUtil.isZipPack(pack) ? newName + ".zip" : newName;
    }

    private static boolean testIllegalChars(@NotNull String input) {
        if (!(input = input.trim()).equals(FilenameUtils.getName((String)input))) {
            return false;
        }
        return !ILLEGAL_CHAR_PATTERN.matcher(input).matches();
    }

    protected void renderBackground(class_332 guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        DrawUtil.renderDropShadow((class_332)guiGraphics, (int)x, (int)y, (int)width, (int)height, (int)24);
        super.renderBackground(guiGraphics, x, y, width, height, mouseX, mouseY, partialTick);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean keyPressed = super.method_25404(keyCode, scanCode, modifiers);
        if (!keyPressed && this.isOpen() && keyCode == 257 && this.canSave(this.nameEditor.method_1882())) {
            this.saveName();
            return true;
        }
        return keyPressed;
    }

    public boolean method_25400(char codePoint, int modifiers) {
        boolean charTyped = super.method_25400(codePoint, modifiers);
        if (!charTyped && this.isOpen() && !this.nameEditor.method_25370()) {
            this.method_25395((class_364)this.nameEditor);
            return this.nameEditor.method_25400(codePoint, modifiers);
        }
        return charTyped;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public class_8016 method_48205(class_8023 event) {
        class_8028 direction;
        if (!this.nameEditor.method_25370() || !(event instanceof class_8023.class_8024)) return super.method_48205(event);
        class_8023.class_8024 class_80242 = (class_8023.class_8024)event;
        try {
            class_8028 class_80282;
            direction = class_80282 = class_80242.comp_1191();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (direction.method_48237() != class_8027.field_41822) return super.method_48205(event);
        if (class_437.method_25442()) return class_8016.method_48194(this.nameEditor, (class_4069[])new class_4069[]{this});
        this.nameEditor.method_1884(this.nameEditor.method_1881());
        return class_8016.method_48194(this.nameEditor, (class_4069[])new class_4069[]{this});
    }
}

