/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.profile;

import io.github.fishstiz.fidgetz.gui.components.AbstractFixedListWidget;
import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuContainer;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuProvider;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.ButtonSprites;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.ARGBColor;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import io.github.fishstiz.fidgetz.util.debounce.PollingDebouncer;
import io.github.fishstiz.fidgetz.util.debounce.SimplePollingDebouncer;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.DevConfig;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfileList
extends AbstractFixedListWidget<Entry>
implements ContextMenuContainer {
    private static final int ITEM_HEIGHT = 20;
    private static final class_2561 EMPTY_TEXT = ResourceUtil.getText("profile.empty", new Object[0]);
    private static final class_2561 DELETE_TEXT = ResourceUtil.getText("profile.delete", new Object[0]);
    private static final class_7919 DELETE_INFO = class_7919.method_47407((class_2561)ResourceUtil.getText("profile.delete.info", new Object[0]));
    private static final Sprite TRASH_SPRITE = Sprite.of16((class_2960)ResourceUtil.getIcon("trash"));
    private static final Sprite STAR_OUTLINE_SPRITE = Sprite.of16((class_2960)ResourceUtil.getIcon("star_outline"));
    private final PollingDebouncer<Void> debouncedRefresh = new SimplePollingDebouncer(this::refresh, 200L);
    private final BiConsumer<Profile, Profile> selectListener;
    private final Consumer<Profile> updateListener;
    private final Config.Packs userConfig;
    private final DevConfig.Packs config;
    @Nullable
    private Profile selectedProfile;

    public ProfileList(Config.Packs userConfig, DevConfig.Packs Config2, BiConsumer<Profile, Profile> selectListener, Consumer<Profile> updateListener) {
        super(20, 6, 0, 0);
        this.userConfig = userConfig;
        this.config = Config2;
        this.selectListener = selectListener;
        this.updateListener = updateListener;
    }

    public void scheduleRefresh() {
        this.debouncedRefresh.run();
    }

    public void refresh() {
        this.method_25339();
        int i = 0;
        Profile defaultProfile = this.config.getDefaultProfile();
        if (defaultProfile != null) {
            this.method_25321((class_350.class_351)new Entry(defaultProfile, i++));
        }
        List<Profile> profiles = this.userConfig.getProfiles();
        for (Profile profile : profiles) {
            if (defaultProfile != null && Objects.equals(profile.getId(), defaultProfile.getId())) continue;
            this.method_25321((class_350.class_351)new Entry(profile, i++));
        }
    }

    @Nullable
    public Profile getSelectedProfile() {
        return this.selectedProfile;
    }

    public void selectProfile(@Nullable Profile profile) {
        Profile previous = this.selectedProfile;
        this.selectedProfile = profile;
        this.selectListener.accept(previous, profile);
        this.updateListener.accept(profile);
    }

    public void removeProfile(Profile profile) {
        if (profile != null && this.selectedProfile == profile) {
            List<Profile> profiles = this.userConfig.getProfiles();
            if (!profiles.isEmpty()) {
                int index = profiles.indexOf(profile);
                Profile previous = index > 0 ? profiles.get(index - 1) : null;
                this.selectProfile(previous);
            } else {
                this.selectProfile(null);
            }
        }
        if (profile != null) {
            this.userConfig.removeProfile(profile);
        }
        this.refresh();
    }

    private void resync() {
        this.selectListener.accept(this.selectedProfile, this.selectedProfile);
        this.updateListener.accept(this.selectedProfile);
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.debouncedRefresh.poll();
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        if (this.method_25396().isEmpty()) {
            ProfileList.method_52718((class_332)guiGraphics, (class_327)this.field_22740.field_1772, (class_2561)EMPTY_TEXT, (int)(this.method_46426() + 8), (int)(this.method_46427() + 8), (int)(this.method_55442() - 8), (int)(this.method_55443() - 8), (int)Theme.WHITE.getARGB());
        }
    }

    public class Entry
    extends AbstractFixedListWidget.Entry
    implements ContextMenuProvider {
        private final Profile profile;
        private final List<FidgetzButton<Void>> children;
        private final FidgetzButton<Void> selectButton;
        private final FidgetzButton<Void> deleteButton;

        protected Entry(Profile profile, int index) {
            super((AbstractFixedListWidget)ProfileList.this, index);
            this.children = new ArrayList<FidgetzButton<Void>>();
            this.profile = profile;
            this.deleteButton = ((FidgetzButton.Builder)FidgetzButton.builder().makeSquare(this.method_25364())).setMessage(DELETE_TEXT).setSprite(this.isDefault() ? ButtonSprites.of((Sprite)GuiConstants.STAR_SPRITE) : (profile.isLocked() ? ButtonSprites.unclamp((Sprite)GuiConstants.LOCK_SPRITE) : ButtonSprites.of((Sprite)TRASH_SPRITE))).setOnPress(this::remove).build();
            boolean bl = this.deleteButton.field_22763 = !profile.isLocked() && !this.isDefault();
            if (this.deleteButton.field_22763) {
                this.deleteButton.method_47400(DELETE_INFO);
            }
            this.selectButton = FidgetzButton.builder().setMessage((class_2561)class_2561.method_43470((String)this.profile.getName())).setOnPress(this::select).build();
            this.children.add(this.deleteButton);
            this.children.add(this.selectButton);
        }

        public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.selectButton.field_22763 = ProfileList.this.selectedProfile != this.profile;
            this.deleteButton.method_48229(left, top);
            this.selectButton.method_48229(left + this.deleteButton.method_25368(), top);
            this.selectButton.method_25358(width - this.deleteButton.method_25368());
            this.deleteButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            this.selectButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            if (Config.get().isDevMode()) {
                boolean hovered;
                int borderColor;
                boolean hasProperty = true;
                if (this.isDefault() && this.profile.isLocked()) {
                    borderColor = Theme.PURPLE_500.getARGB();
                } else if (this.isDefault()) {
                    borderColor = Theme.BLUE_500.getARGB();
                } else if (this.profile.isLocked()) {
                    borderColor = Theme.RED_700.getARGB();
                } else {
                    borderColor = Theme.WHITE.getARGB();
                    hasProperty = false;
                }
                boolean bl = hovered = guiGraphics.method_58135(mouseX, mouseY) && GuiUtil.isHovered((class_364)this, (double)mouseX, (double)mouseY);
                if (hasProperty || hovered) {
                    guiGraphics.method_49601(left, top, width, height, borderColor);
                }
                if (hovered) {
                    int foregroundColor = ARGBColor.withAlpha((int)borderColor, (float)0.25f);
                    guiGraphics.method_25294(left, top, left + width, top + height, foregroundColor);
                }
            }
        }

        private void toggleLock() {
            boolean selected = this.isSelected();
            if (selected) {
                ProfileList.this.resync();
            }
            this.profile.setLocked(!this.profile.isLocked());
            ProfileList.this.refresh();
            if (selected) {
                ProfileList.this.updateListener.accept(this.profile);
            }
        }

        private void toggleDefault() {
            ProfileList.this.config.setDefaultProfile(this.isDefault() ? null : this.profile);
            ProfileList.this.refresh();
            if (!this.isSelected() && this.isDefault()) {
                this.select();
            } else {
                ProfileList.this.resync();
            }
        }

        private void remove() {
            ProfileList.this.removeProfile(this.profile);
        }

        private void select() {
            ProfileList.this.selectProfile(this.profile);
        }

        private boolean isDefault() {
            return Objects.equals(this.profile, ProfileList.this.config.getDefaultProfile());
        }

        private boolean isSelected() {
            return Objects.equals(this.profile, ProfileList.this.selectedProfile);
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return this.children;
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        public void method_48206(Consumer<class_339> consumer) {
            this.children.forEach(consumer);
        }

        public void buildItems(ContextMenuItemBuilder builder, int mouseX, int mouseY) {
            if (!Config.get().isDevMode()) {
                return;
            }
            builder.separatorIfNonEmpty();
            builder.add(GuiConstants.devItem((class_2561)ResourceUtil.getText("profile.default." + (this.isDefault() ? "unset" : "set"), new Object[0])).icon(() -> this.isDefault() ? GuiConstants.STAR_SPRITE : STAR_OUTLINE_SPRITE).action(this::toggleDefault).build());
            builder.add(GuiConstants.devItem((class_2561)ResourceUtil.getText("profile." + (this.profile.isLocked() ? "unlock" : "lock"), new Object[0])).icon(this.profile.isLocked() ? GuiConstants.LOCK_SPRITE_SMALL : GuiConstants.UNLOCK_SPRITE_SMALL).action(this::toggleLock).build());
        }
    }
}

