/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.screens;

import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenu;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.DevConfig;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.gui.components.pack.FileRenameModal;
import io.github.fishstiz.packed_packs.gui.components.pack.FolderDialog;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.gui.components.profile.ProfileList;
import io.github.fishstiz.packed_packs.gui.components.profile.Sidebar;
import io.github.fishstiz.packed_packs.gui.layouts.pack.AvailablePacksLayout;
import io.github.fishstiz.packed_packs.gui.layouts.pack.CurrentPacksLayout;
import io.github.fishstiz.packed_packs.pack.PackAssetManager;
import io.github.fishstiz.packed_packs.pack.PackFileOperations;
import io.github.fishstiz.packed_packs.pack.PackOptionsContext;
import io.github.fishstiz.packed_packs.pack.PackRepositoryManager;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_437;

public class WidgetFactory {
    private static boolean screenInitialized = false;
    private static boolean profilesInitialized = false;

    private WidgetFactory() {
    }

    private static <T> CompletableFuture<T> supplyAsync(Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(supplier, class_156.method_18349());
    }

    public static <S extends class_437 & PackListEventListener> PackedPacksWidgets createWidgets(S screen, PackOptionsContext options, PackRepositoryManager repository, PackAssetManager assets) {
        PackFileOperations fileOps = new PackFileOperations(options, repository);
        if (screenInitialized) {
            return new PackedPacksWidgets(new AvailablePacksLayout(options, assets, fileOps, screen), new CurrentPacksLayout(options, assets, fileOps, screen), new FolderDialog(screen, options, assets, fileOps), new FileRenameModal(screen, fileOps, assets), ContextMenu.builder(screen).setSpacing(8).setBackground(Theme.GRAY_800.getARGB()).setBorderColor(Theme.GRAY_500.getARGB()).build());
        }
        CompletableFuture<AvailablePacksLayout> availablePacks = WidgetFactory.supplyAsync(() -> new AvailablePacksLayout(options, assets, fileOps, screen));
        CompletableFuture<CurrentPacksLayout> currentPacks = WidgetFactory.supplyAsync(() -> new CurrentPacksLayout(options, assets, fileOps, screen));
        CompletableFuture<FolderDialog> folderDialog = WidgetFactory.supplyAsync(() -> new FolderDialog(screen, options, assets, fileOps));
        CompletableFuture<FileRenameModal> fileRenameModal = WidgetFactory.supplyAsync(() -> new FileRenameModal(screen, fileOps, assets));
        CompletableFuture<ContextMenu> contextMenu = WidgetFactory.supplyAsync(() -> ContextMenu.builder((class_437)screen).setSpacing(8).setBackground(Theme.GRAY_800.getARGB()).setBorderColor(Theme.GRAY_500.getARGB()).build());
        CompletableFuture.allOf(availablePacks, currentPacks, folderDialog, fileRenameModal, contextMenu).join();
        screenInitialized = true;
        return new PackedPacksWidgets(availablePacks.join(), currentPacks.join(), folderDialog.join(), fileRenameModal.join(), contextMenu.join());
    }

    public static <S extends class_437> ProfileWidgets createProfileWidgets(S screen, Config.Packs userConfig, DevConfig.Packs config, BiConsumer<Profile, Profile> selectListener, Consumer<Profile> updateListener) {
        if (profilesInitialized) {
            return new ProfileWidgets(new Sidebar(screen), new ProfileList(userConfig, config, selectListener, updateListener));
        }
        CompletableFuture<Sidebar> sidebar = WidgetFactory.supplyAsync(() -> new Sidebar(screen));
        CompletableFuture<ProfileList> profileList = WidgetFactory.supplyAsync(() -> new ProfileList(userConfig, config, selectListener, updateListener));
        CompletableFuture.allOf(sidebar, profileList).join();
        profilesInitialized = true;
        return new ProfileWidgets(sidebar.join(), profileList.join());
    }

    public record PackedPacksWidgets(AvailablePacksLayout availablePacksLayout, CurrentPacksLayout currentPacksLayout, FolderDialog folderDialog, FileRenameModal fileRenameModal, ContextMenu contextMenu) {
        public List<PackList> packLists() {
            return List.of(this.availablePacksLayout.list(), this.currentPacksLayout().list(), (PackList)this.folderDialog.root());
        }
    }

    public record ProfileWidgets(Sidebar sidebar, ProfileList profileList) {
    }
}

