/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.fidgetz.gui.components.contextmenu;

import io.github.fishstiz.fidgetz.gui.components.Fidgetz;
import io.github.fishstiz.fidgetz.gui.components.FidgetzText;
import io.github.fishstiz.fidgetz.gui.components.LayoutWrapper;
import io.github.fishstiz.fidgetz.gui.components.ToggleableDialog;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.MenuItem;
import io.github.fishstiz.fidgetz.gui.layouts.ScrollableLayout;
import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.gui.renderables.RenderableRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.gui.shapes.GuiRectangle;
import io.github.fishstiz.fidgetz.util.ARGBColor;
import io.github.fishstiz.fidgetz.util.DrawUtil;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8021;
import net.minecraft.class_8133;
import net.minecraft.class_8667;
import org.jetbrains.annotations.Nullable;

public class ContextMenu
extends ToggleableDialog<LayoutWrapper<ScrollableLayout>> {
    static final int DEFAULT_BORDER_COLOR = ARGBColor.withAlpha(Objects.requireNonNull(class_124.field_1080.method_532()), 1.0f);
    static final int DEFAULT_TEXT_INACTIVE_COLOR = ARGBColor.withAlpha(DEFAULT_BORDER_COLOR, 0.5f);
    static final int DEFAULT_BACKGROUND_COLOR = ARGBColor.withAlpha(Objects.requireNonNull(class_124.field_1063.method_532()), 1.0f);
    private static final int DEFAULT_SPACING = 8;
    private static final int ITEM_HEIGHT = 20;
    private static final int MAX_HEIGHT = 200;
    private static final int MIN_WIDTH = 150;
    private static final int MENU_POINT_OFFSET = 1;
    private static final int DROP_SHADOW_SIZE = 16;
    private final Builder builder;
    private final List<ContextMenu> childMenus = new ArrayList<ContextMenu>();
    private final int spacing;
    private final int borderColor;
    private final int softSeparatorColor;
    private final ContextMenu parentMenu;
    private Direction direction;
    private boolean forceOpen;

    protected ContextMenu(Builder builder) {
        super(builder);
        this.builder = builder;
        this.spacing = builder.spacing;
        this.borderColor = builder.borderColor;
        this.softSeparatorColor = ARGBColor.withAlpha(this.borderColor, 0.15f);
        this.parentMenu = builder.parentMenu;
        this.direction = builder.direction;
        ((LayoutWrapper)((Object)this.root())).setMinWidth(150);
        this.addListener(open -> {
            if (!open.booleanValue()) {
                this.direction = this.builder.direction;
                this.forceOpen = false;
            }
        });
    }

    @Override
    protected void clearWidgets() {
        super.clearWidgets();
        this.forEachChild(ContextMenu::clearWidgets);
        this.childMenus.clear();
    }

    private ItemWidget createItemWidget(MenuItem item) {
        if (!item.parent()) {
            return new ItemWidget(150, this.spacing, item, this);
        }
        ContextMenu childMenu = Builder.buildChild(this);
        this.childMenus.add(childMenu);
        return new ParentItemWidget(150, this.spacing, item, this, childMenu);
    }

    private void setItems(List<? extends MenuItem> items) {
        this.clearWidgets();
        class_8667 content = class_8667.method_52741();
        for (int i = 0; i < items.size(); ++i) {
            MenuItem next;
            MenuItem current = items.get(i);
            MenuItem menuItem = next = i + 1 < items.size() ? items.get(i + 1) : null;
            if (current == MenuItem.SEPARATOR) {
                content.method_52736((class_8021)new Separator(150, this.borderColor));
                continue;
            }
            content.method_52736((class_8021)this.createItemWidget(current));
            if (!current.shouldAutoSeparate() || next == null || !next.shouldAutoSeparate()) continue;
            content.method_52736((class_8021)new Separator(150, this.softSeparatorColor));
        }
        this.childMenus.forEach(this::addWidget);
        ScrollableLayout layout = new ScrollableLayout(class_310.method_1551(), (class_8133)content, content.method_25364());
        layout.setMaxHeight(200);
        layout.method_48206(this::addRenderableWidget);
        ((LayoutWrapper)((Object)this.root())).setLayout(layout);
        ((LayoutWrapper)((Object)this.root())).method_48206(this::addRenderableWidget);
    }

    private void open(int x, int y, Direction direction, List<? extends MenuItem> items) {
        if (items.isEmpty()) {
            return;
        }
        this.direction = direction;
        this.setItems(items);
        ((LayoutWrapper)((Object)this.root())).method_48222();
        ((LayoutWrapper)((Object)this.root())).method_48229(this.clampX(x), this.clampY(y));
        this.setOpen(true);
    }

    public void open(int x, int y, List<MenuItem> items) {
        this.open(x, y, this.builder.direction, items);
    }

    private int clampX(int x) {
        GuiRectangle bounds = this.getBoundingBox();
        this.direction = this.direction.next(this.screen, bounds, x);
        return this.direction.clamp(this.screen, bounds, x);
    }

    private int clampY(int y) {
        GuiRectangle bounds = this.getBoundingBox();
        return y + bounds.method_25364() > this.screen.field_22790 ? Math.max(0, this.screen.field_22790 - bounds.method_25364()) : y;
    }

    public int getItemHeight() {
        return 20;
    }

    @Override
    protected void renderBackground(class_332 guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        DrawUtil.renderDropShadow(guiGraphics, x, y, width, height, 16);
        super.renderBackground(guiGraphics, x, y, width, height, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderForeground(class_332 guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        guiGraphics.method_49601(x, y, width, height, this.borderColor);
        for (ContextMenu childMenu : this.childMenus) {
            childMenu.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Nullable
    public ContextMenu getOpenedChildMenu() {
        for (ContextMenu child : this.childMenus) {
            if (!child.isOpen()) continue;
            return child;
        }
        return null;
    }

    private boolean isHoveredAtDirection(int mouseX, int mouseY) {
        return this.isOpen() && (this.isMouseOverBounds(mouseX, mouseY) || this.direction.isHovered(mouseX, mouseY, this.getBoundingBox()));
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        if (!this.isOpen()) {
            return false;
        }
        ContextMenu child = this.getOpenedChildMenu();
        boolean withinBounds = child != null ? this.getBoundingBox().containsPoint(mouseX, mouseY) || child.getBoundingBox().containsPoint(mouseX, mouseY) : this.getBoundingBox().containsPoint(mouseX, mouseY);
        return withinBounds && super.method_25405(mouseX, mouseY);
    }

    public void forEachChild(Consumer<ContextMenu> consumer) {
        for (ContextMenu child : this.childMenus) {
            consumer.accept(child);
            child.forEachChild(consumer);
        }
    }

    public void forEachParent(Consumer<ContextMenu> visitor) {
        if (this.parentMenu != null) {
            visitor.accept(this.parentMenu);
            this.parentMenu.forEachParent(visitor);
        }
    }

    private void closeCascade() {
        this.setOpen(false);
        this.forEachParent(parent -> parent.setOpen(false));
    }

    public static <S extends class_437> Builder builder(S screen) {
        return new Builder(screen, new LayoutWrapper<ScrollableLayout>(new ScrollableLayout(class_310.method_1551(), (class_8133)class_8667.method_52741(), 200), 150, 0));
    }

    public static class Builder
    extends ToggleableDialog.Builder<LayoutWrapper<ScrollableLayout>, Builder> {
        protected Direction direction = Direction.RIGHT;
        protected int backgroundColor = DEFAULT_BACKGROUND_COLOR;
        protected int borderColor = DEFAULT_BORDER_COLOR;
        protected int spacing = 8;
        private ContextMenu parentMenu = null;

        protected <S extends class_437> Builder(S screen, LayoutWrapper<ScrollableLayout> root) {
            super(screen, root);
            this.focusOnOpen = false;
        }

        protected static <S extends class_437> ContextMenu buildChild(ContextMenu parentMenu) {
            Builder child = ContextMenu.builder(parentMenu.builder.screen);
            child.spacing = parentMenu.builder.spacing;
            child.backgroundColor = parentMenu.builder.backgroundColor;
            child.borderColor = parentMenu.builder.borderColor;
            child.background = parentMenu.builder.background;
            child.autoClose = parentMenu.builder.autoClose;
            child.focusOnOpen = parentMenu.builder.focusOnOpen;
            child.autoLoseFocus = parentMenu.builder.autoLoseFocus;
            child.parentMenu = parentMenu;
            child.direction = parentMenu.direction;
            return child.build();
        }

        public Builder setSpacing(int spacing) {
            this.spacing = spacing;
            return this;
        }

        public Builder setBorderColor(int borderColor) {
            this.borderColor = borderColor;
            return this;
        }

        @Override
        public Builder setBackground(int color) {
            this.backgroundColor = color;
            return this;
        }

        public Builder setDirection(Direction direction) {
            this.direction = direction;
            return this;
        }

        public ContextMenu build() {
            if (this.background == null) {
                this.background = new ColoredRect(this.backgroundColor);
            }
            return new ContextMenu(this);
        }
    }

    public static enum Direction {
        LEFT{

            @Override
            protected Direction next(class_437 screen, GuiRectangle bounds, int x) {
                return x - bounds.method_25368() / 2 < 0 ? RIGHT : this;
            }

            @Override
            protected int clamp(class_437 screen, GuiRectangle bounds, int x) {
                return Math.max(0, x - bounds.method_25368());
            }

            @Override
            protected int getX(GuiRectangle bounds) {
                return bounds.method_46426();
            }

            @Override
            protected boolean isHovered(int mouseX, int mouseY, GuiRectangle bounds) {
                return mouseX >= bounds.method_46426() && mouseX <= bounds.method_46426() + bounds.method_25368() + 5 && mouseY >= bounds.method_46427() && mouseY <= bounds.method_46427() + bounds.method_25364();
            }
        }
        ,
        RIGHT{

            @Override
            protected Direction next(class_437 screen, GuiRectangle bounds, int x) {
                return x + bounds.method_25368() / 2 > screen.field_22789 ? LEFT : this;
            }

            @Override
            protected int clamp(class_437 screen, GuiRectangle bounds, int x) {
                return x + bounds.method_25368() > screen.field_22789 ? screen.field_22789 - bounds.method_25368() : x;
            }

            @Override
            protected int getX(GuiRectangle bounds) {
                return bounds.getRight();
            }

            @Override
            protected boolean isHovered(int mouseX, int mouseY, GuiRectangle bounds) {
                return mouseX >= bounds.method_46426() - 5 && mouseX <= bounds.method_46426() + bounds.method_25368() && mouseY >= bounds.method_46427() && mouseY <= bounds.method_46427() + bounds.method_25364();
            }
        };

        private static final int HOVER_LEEWAY = 5;

        protected abstract Direction next(class_437 var1, GuiRectangle var2, int var3);

        protected abstract int clamp(class_437 var1, GuiRectangle var2, int var3);

        protected abstract int getX(GuiRectangle var1);

        protected abstract boolean isHovered(int var1, int var2, GuiRectangle var3);
    }

    private static class ItemWidget
    extends class_339
    implements Fidgetz {
        private static final int HOVER_OVERLAY_COLOR = ARGBColor.withAlpha(-1, 0.1f);
        private final FidgetzText<Void> text;
        protected final ContextMenu parent;
        protected final MenuItem item;
        protected final int spacing;

        private ItemWidget(int width, int spacing, MenuItem item, ContextMenu parent) {
            super(0, 0, width, 20, item.text());
            this.spacing = spacing;
            this.text = FidgetzText.builder().alignLeft().setOffsetY(1).setShadow(true).setMessage(item.text()).build();
            this.parent = parent;
            this.item = item;
        }

        public void method_25354(class_1144 handler) {
            if (this.item.active()) {
                super.method_25354(handler);
            }
        }

        public void method_25348(double mouseX, double mouseY) {
            if (this.item.active()) {
                this.item.run();
            }
            if (this.item.shouldCloseOnInteract()) {
                this.parent.closeCascade();
            }
        }

        protected void renderBackground(class_332 guiGraphics, int x, int y, int width, int height, float partialTick) {
            RenderableRect background = this.item.background();
            if (background != null) {
                background.render(guiGraphics, x, y, width, height, partialTick);
            }
        }

        protected void renderIcon(class_332 guiGraphics, int x, int y, int width, int height, float partialTick) {
            Sprite icon = this.item.icon();
            if (icon != null) {
                icon.render(guiGraphics, x, y, width, height, partialTick);
            }
        }

        protected void renderText(class_332 guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
            this.text.method_46438(this.item.textColor());
            this.text.method_48229(x, y);
            this.text.method_55445(width, height);
            this.text.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        }

        protected void renderHighlight(class_332 guiGraphics, int x, int y, int right, int bottom, boolean hovered, float partialTick) {
            if (hovered && this.item.active()) {
                guiGraphics.method_25294(x, y, right, bottom, HOVER_OVERLAY_COLOR);
            }
        }

        protected void renderForeground(class_332 guiGraphics, int x, int y, int width, int height, boolean hovered, double mouseX, double mouseY, float partialTick) {
        }

        protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.method_47400(this.item.tooltip());
            this.field_22762 = this.field_22762 && this.method_25405(mouseX, mouseY);
            int x = this.method_46426();
            int y = this.method_46427();
            int width = this.method_25368();
            int height = this.method_25364();
            int right = x + width;
            int bottom = y + height;
            this.renderBackground(guiGraphics, x, y, width, height, partialTick);
            this.renderHighlight(guiGraphics, x, y, right, bottom, this.field_22762, partialTick);
            Objects.requireNonNull(class_310.method_1551().field_1772);
            int size = 9;
            int innerX = x + this.spacing;
            int innerY = y + this.spacing;
            int innerWidth = width - this.spacing * 2;
            int innerHeight = height - this.spacing * 2;
            int iconY = innerY + (innerHeight - size) / 2;
            int textX = this.item.icon() != null ? innerX + size + this.spacing : innerX;
            int textWidth = this.item.icon() != null ? innerWidth - size - this.spacing : innerWidth;
            this.renderIcon(guiGraphics, innerX, iconY, size, size, partialTick);
            this.renderText(guiGraphics, textX, innerY, textWidth, innerHeight, mouseX, mouseY, partialTick);
            this.renderForeground(guiGraphics, x, y, width, height, this.field_22762, mouseX, mouseY, partialTick);
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            if (!this.parent.isOpen()) {
                return false;
            }
            for (ContextMenu siblingChild : this.parent.childMenus) {
                if (!siblingChild.isOpen() || !siblingChild.isMouseOverBounds(mouseX, mouseY)) continue;
                return false;
            }
            return super.method_25405(mouseX, mouseY);
        }

        protected void method_47399(class_6382 narrationElementOutput) {
            narrationElementOutput.method_37034(class_6381.field_33788, this.method_25369());
        }
    }

    private static class ParentItemWidget
    extends ItemWidget {
        private static final String CARET_RIGHT = ">";
        private final ContextMenu child;

        ParentItemWidget(int width, int spacing, MenuItem item, ContextMenu parent, ContextMenu child) {
            super(width, spacing, item, parent);
            this.child = child;
        }

        private void openChild() {
            GuiRectangle parentBounds = this.parent.getBoundingBox();
            GuiRectangle childBounds = this.child.getBoundingBox();
            Direction parentDirection = this.parent.direction;
            Direction nextDirection = parentDirection.next(this.parent.screen, childBounds, parentDirection.getX(parentBounds));
            int x = nextDirection.getX(this);
            int y = this.method_46427();
            this.parent.forEachChild(menu -> {
                if (menu != this.child) {
                    menu.setOpen(false);
                }
            });
            this.child.open(x, y, nextDirection, this.item.children());
        }

        private void closeChildren() {
            this.child.setOpen(false);
            this.child.forEachChild(menu -> menu.setOpen(false));
        }

        @Override
        public void method_25348(double mouseX, double mouseY) {
            if (this.item.active()) {
                this.item.run();
                boolean bl = this.child.forceOpen = !this.child.forceOpen || !this.child.isOpen();
                if (!this.child.isOpen()) {
                    this.openChild();
                }
            } else if (this.item.shouldCloseOnInteract()) {
                this.parent.closeCascade();
            }
        }

        private boolean isWithinParentXBounds(int mouseX, int mouseY) {
            if (this.method_49606()) {
                return true;
            }
            GuiRectangle parentBox = this.parent.getBoundingBox();
            return mouseX >= parentBox.method_46426() && mouseX <= parentBox.getRight() && mouseY >= this.method_46427() && mouseY <= this.method_55443();
        }

        @Override
        protected void renderText(class_332 guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
            int textWidth = width - (height + this.spacing);
            super.renderText(guiGraphics, x, y, textWidth, height, mouseX, mouseY, partialTick);
            if (this.item.active()) {
                class_327 font = class_310.method_1551().field_1772;
                int caretWidth = font.method_1727(CARET_RIGHT);
                Objects.requireNonNull(font);
                int caretHeight = 9;
                int caretX = x + textWidth + this.spacing + (height - caretWidth) / 2;
                int caretY = y + (height - caretHeight) / 2;
                int color = this.item.textColor();
                guiGraphics.method_51433(font, CARET_RIGHT, caretX, caretY, color, false);
            }
        }

        @Override
        protected void renderHighlight(class_332 guiGraphics, int x, int y, int right, int bottom, boolean hovered, float partialTick) {
            super.renderHighlight(guiGraphics, x, y, right, bottom, hovered || this.child.isOpen(), partialTick);
        }

        @Override
        protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
            if (!this.item.active()) {
                if (this.child.isOpen()) {
                    this.closeChildren();
                }
                this.child.forceOpen = false;
                return;
            }
            boolean looselyHovered = this.isWithinParentXBounds(mouseX, mouseY) && guiGraphics.method_58135(mouseX, mouseY);
            ContextMenu sibling = this.parent.getOpenedChildMenu();
            if (!(looselyHovered || !this.child.isOpen() || this.child.forceOpen || sibling != null && sibling.isHoveredAtDirection(mouseX, mouseY))) {
                this.closeChildren();
            } else if (looselyHovered && this.method_49606() && !this.child.isOpen() && (sibling == null || !sibling.forceOpen && !sibling.isHoveredAtDirection(mouseX, mouseY))) {
                this.openChild();
            }
        }
    }

    private static class Separator
    extends class_339
    implements Fidgetz {
        private final int color;

        private Separator(int width, int color) {
            super(0, 0, width, 1, class_5244.field_39003);
            this.color = color;
        }

        public boolean method_25370() {
            return false;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            return false;
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            return this.field_22764 && GuiUtil.containsPoint((class_8021)this, mouseX, mouseY);
        }

        protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.method_25292(this.method_46426(), this.method_55442() - 1, this.getMidY(), this.color);
        }

        protected void method_47399(class_6382 narrationElementOutput) {
        }
    }
}

