/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.fidgetz.gui.components.contextmenu;

import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenu;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.MenuItem;
import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.gui.renderables.RenderableRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.lang.ObjectsUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class MenuItemBuilder {
    private final List<MenuItem> children = new ObjectArrayList();
    private final class_2561 text;
    private Runnable action = ObjectsUtil::nop;
    private RenderableRect background;
    private Supplier<@Nullable Sprite> iconSupplier;
    private Supplier<class_7919> tooltipSupplier;
    private boolean shouldCloseOnInteract = true;
    private boolean shouldAutoSeparate = true;
    private BooleanSupplier activeSupplier;
    private IntSupplier textColorSupplier;

    MenuItemBuilder(class_2561 text) {
        this.text = text;
    }

    public MenuItemBuilder action(Runnable action) {
        this.action = action;
        return this;
    }

    public MenuItemBuilder background(@Nullable RenderableRect background) {
        this.background = background;
        return this;
    }

    public MenuItemBuilder background(int backgroundColor) {
        this.background = new ColoredRect(backgroundColor);
        return this;
    }

    public MenuItemBuilder icon(@Nullable Sprite icon) {
        this.iconSupplier = () -> icon;
        return this;
    }

    public MenuItemBuilder icon(Supplier<@Nullable Sprite> icon) {
        this.iconSupplier = icon;
        return this;
    }

    public MenuItemBuilder tooltip(Supplier<@Nullable class_7919> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public MenuItemBuilder tooltip(class_7919 tooltip) {
        return this.tooltip(() -> tooltip);
    }

    public MenuItemBuilder closeOnInteract(boolean value) {
        this.shouldCloseOnInteract = value;
        return this;
    }

    public MenuItemBuilder autoSeparate(boolean value) {
        this.shouldAutoSeparate = value;
        return this;
    }

    public MenuItemBuilder activeWhen(BooleanSupplier activeSupplier) {
        this.activeSupplier = activeSupplier;
        return this;
    }

    public MenuItemBuilder textColor(IntSupplier textColorSupplier) {
        this.textColorSupplier = textColorSupplier;
        return this;
    }

    public MenuItemBuilder textColor(int textColor) {
        this.textColorSupplier = () -> textColor;
        return this;
    }

    public MenuItemBuilder addChild(MenuItem child) {
        this.children.add(child);
        return this;
    }

    public MenuItemBuilder addChildren(Collection<MenuItem> children) {
        this.children.addAll(children);
        return this;
    }

    private void setDefaults() {
        if (this.iconSupplier == null) {
            this.iconSupplier = MenuItemBuilder::nullSupplier;
        }
        if (this.tooltipSupplier == null) {
            this.tooltipSupplier = MenuItemBuilder::nullSupplier;
        }
        if (this.activeSupplier == null) {
            this.activeSupplier = () -> true;
        }
        if (this.textColorSupplier == null) {
            this.textColorSupplier = () -> this.activeSupplier.getAsBoolean() ? -1 : ContextMenu.DEFAULT_TEXT_INACTIVE_COLOR;
        }
    }

    private static <T> T nullSupplier() {
        return null;
    }

    public MenuItem build() {
        this.setDefaults();
        return new MenuItemImpl(this.text, this.action, this.background, this.iconSupplier, this.tooltipSupplier, this.shouldCloseOnInteract, this.shouldAutoSeparate, this.activeSupplier, this.textColorSupplier, this.children);
    }

    private record MenuItemImpl(class_2561 text, Runnable action, RenderableRect background, Supplier<@Nullable Sprite> iconSupplier, Supplier<@Nullable class_7919> tooltipSupplier, boolean shouldCloseOnInteract, boolean shouldAutoSeparate, BooleanSupplier activeSupplier, IntSupplier textColorSupplier, List<MenuItem> children) implements MenuItem
    {
        @Override
        public void run() {
            this.action.run();
        }

        @Override
        public boolean active() {
            return this.activeSupplier.getAsBoolean();
        }

        @Override
        public int textColor() {
            return this.textColorSupplier.getAsInt();
        }

        @Override
        @Nullable
        public Sprite icon() {
            return this.iconSupplier.get();
        }

        @Override
        @Nullable
        public class_7919 tooltip() {
            return this.tooltipSupplier.get();
        }
    }
}

