/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.fidgetz.gui.renderables.sprites;

import io.github.fishstiz.fidgetz.gui.renderables.RenderableRect;
import io.github.fishstiz.fidgetz.gui.shapes.Line;
import io.github.fishstiz.fidgetz.gui.shapes.Size;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class Sprite
implements RenderableRect {
    public final class_2960 location;
    public final int width;
    public final int height;
    public final int uOffset;
    public final int vOffset;
    public final int uWidth;
    public final int vHeight;

    public Sprite(class_2960 location, int width, int height, int uOffset, int vOffset, int uWidth, int vHeight) {
        this.location = location;
        this.width = width;
        this.height = height;
        this.uOffset = uOffset;
        this.vOffset = vOffset;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
    }

    public Sprite(class_2960 location, int width, int height) {
        this(location, width, height, 0, 0, width, height);
    }

    public Sprite(class_2960 location, Size size, Line u, Line v) {
        this(location, size.width(), size.height(), u.start(), v.start(), u.length(), v.length());
    }

    public Sprite(class_2960 location, Size size) {
        this(location, size.width(), size.height());
    }

    public static Sprite of32(class_2960 location) {
        return new Sprite(location, Size.of32());
    }

    public static Sprite of16(class_2960 location) {
        return new Sprite(location, Size.of16());
    }

    @Override
    public void render(class_332 guiGraphics, int x, int y, int width, int height, float partialTick) {
        guiGraphics.method_25293(this.location, x, y, width, height, (float)this.uOffset, (float)this.vOffset, this.uWidth, this.vHeight, this.width, this.height);
    }

    public void render(class_332 guiGraphics, int x, int y) {
        this.render(guiGraphics, x, y, this.width, this.height, 0.0f);
    }

    public void renderClamped(class_332 guiGraphics, int x, int y, int width, int height, float partialTick) {
        int drawWidth = Math.min(width, this.width);
        int drawHeight = Math.min(height, this.height);
        int offsetX = (width - drawWidth) / 2;
        int offsetY = (height - drawHeight) / 2;
        this.render(guiGraphics, x + offsetX, y + offsetY, drawWidth, drawHeight, partialTick);
    }
}

