/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.fidgetz.util.text;

import io.github.fishstiz.fidgetz.util.lang.CollectionsUtil;
import io.github.fishstiz.fidgetz.util.text.TextStylizer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_2583;
import net.minecraft.class_5224;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class AsyncStylizerFormatter {
    private final TextStylizer[] textStylizers;
    private final Supplier<String> textSupplier;
    private final Executor executor;
    private final StylizedSequence readSequence = new StylizedSequence();
    private final StylizedSequence writeSequence = new StylizedSequence();
    private volatile StylizedSequence currentSequence = this.readSequence;
    private volatile String lastText = "";

    public AsyncStylizerFormatter(List<TextStylizer> textStylizers, Supplier<String> textSupplier, Executor executor) {
        this.textStylizers = CollectionsUtil.mapToArray(textStylizers, TextStylizer::copy, TextStylizer[]::new);
        this.textSupplier = textSupplier;
        this.executor = executor;
    }

    public AsyncStylizerFormatter(List<TextStylizer> textStylizers, Supplier<String> textSupplier) {
        this(textStylizers, textSupplier, class_156.method_18349());
    }

    @Nullable
    public class_5481 format(String displayText, int displayPos) {
        String currentText = this.textSupplier.get();
        if (currentText.isBlank()) {
            return null;
        }
        StylizedSequence current = this.currentSequence;
        current.text = currentText;
        current.displayPos = displayPos;
        current.displayEnd = displayPos + displayText.length();
        if (!currentText.equals(this.lastText)) {
            this.lastText = currentText;
            this.executor.execute(this::computeStyles);
        }
        return current;
    }

    private void computeStyles() {
        String text;
        StylizedSequence write = this.currentSequence == this.readSequence ? this.writeSequence : this.readSequence;
        write.text = text = this.lastText;
        write.charStyles.size(text.length());
        Arrays.fill(write.charStyles.elements(), 0, write.charStyles.size(), null);
        for (TextStylizer stylizer : this.textStylizers) {
            if (!stylizer.canStylize(text)) continue;
            stylizer.reset(text);
            while (stylizer.find()) {
                for (int i = stylizer.start(); i < stylizer.end(); ++i) {
                    write.charStyles.set(i, (Object)stylizer.style());
                }
            }
        }
        this.currentSequence = write;
    }

    private static class StylizedSequence
    implements class_5481 {
        final ObjectArrayList<class_2583> charStyles = new ObjectArrayList();
        volatile String text = "";
        int displayPos;
        int displayEnd;

        private StylizedSequence() {
        }

        public boolean accept(class_5224 sink) {
            String currentText = this.text;
            int start = Math.max(0, this.displayPos);
            int end = Math.min(Math.min(currentText.length(), this.displayEnd), Math.max(this.charStyles.size(), currentText.length()));
            for (int i = start; i < end; ++i) {
                class_2583 style;
                class_2583 class_25832 = style = i < this.charStyles.size() ? (class_2583)this.charStyles.get(i) : null;
                if (sink.accept(i - this.displayPos, Objects.requireNonNullElse(style, class_2583.field_24360), (int)currentText.charAt(i))) continue;
                return false;
            }
            return true;
        }
    }
}

