/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.config;

import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.compat.Mod;
import io.github.fishstiz.packed_packs.config.ConfigFixer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class Preferences {
    public static final Preferences INSTANCE = Preferences.load();
    private final Map<String, Preference<?>> options = new Object2ObjectOpenHashMap();
    public final Preference<Boolean> originalScreenWidget = new Preference<Boolean>(this, "original_screen", true);
    public final Preference<Boolean> optionsWidget = new Preference<Boolean>(this, "options", true);
    public final Preference<Boolean> actionBarWidget = new Preference<Boolean>(this, "action_bar", true);
    public final Preference<Boolean> toggleIncompatibleWidget = new Preference<Boolean>(this, "toggle_incompatible", true);
    public final Preference<Boolean> folderPackWidget = new Preference<Boolean>(this, "folder_pack", true);
    public final Preference<Boolean> etfButton = new Preference<Boolean>(this, "etf_button", true, Preferences.modPrefDeserializer(Mod.ETF));
    public final Preference<Boolean> respackoptsButton = new Preference<Boolean>(this, "respackopts_button", true, Preferences.modPrefDeserializer(Mod.RESPACKOPTS));
    public final Preference<Boolean> vtdButton = new Preference<Boolean>(this, "vtd_button", true, Preferences.modPrefDeserializer(Mod.VTD));
    public final Preference<Boolean> vtdEditButton = new Preference<Boolean>(this, "vtd_edit_button", true, Preferences.modPrefDeserializer(Mod.VTD));

    private Preferences() {
    }

    private static File getFile() {
        return PackedPacks.getConfigDir().resolve("preferences.properties").toFile();
    }

    private static Preferences load() {
        Preferences prefs = new Preferences();
        File file = Preferences.getFile();
        if (!file.exists() && !(file = ConfigFixer.getPreviousPreferencesFile()).exists()) {
            return prefs;
        }
        Properties props = new Properties();
        try (FileInputStream fis = new FileInputStream(file);){
            props.load(fis);
            for (Map.Entry<String, Preference<?>> entry : prefs.options.entrySet()) {
                String key = entry.getKey();
                String value = props.getProperty(key);
                entry.getValue().deserializeAndSet(value);
            }
        }
        catch (IOException | NumberFormatException e) {
            PackedPacks.LOGGER.error("[packed_packs] Failed to load preferences. ", (Throwable)e);
        }
        return prefs;
    }

    public void reset() {
        this.options.values().forEach(Preference::reset);
    }

    public void save() {
        Properties props = new Properties();
        for (Map.Entry<String, Preference<?>> entry : this.options.entrySet()) {
            Object value = entry.getValue().get();
            props.setProperty(entry.getKey(), value.toString());
        }
        try (FileOutputStream fos = new FileOutputStream(Preferences.getFile());){
            props.store(fos, "Preferences");
        }
        catch (IOException e) {
            PackedPacks.LOGGER.error("[packed_packs] Failed to save preferences. ", (Throwable)e);
        }
    }

    private static Function<String, Boolean> modPrefDeserializer(Mod mod) {
        return value -> !mod.isLoaded() || Boolean.parseBoolean(value);
    }

    public class Preference<T> {
        private final String key;
        private final T defaultValue;
        private final Function<String, T> deserializer;
        private T value;

        Preference(Preferences this$0, String key, @Nullable T defaultValue, Function<String, T> deserializer) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.deserializer = deserializer != null ? deserializer : Preference.getDefaultDeserializer(defaultValue);
            this.value = defaultValue;
            this$0.options.put(this.key, this);
        }

        Preference(Preferences this$0, String key, T defaultValue) {
            this(this$0, key, defaultValue, null);
        }

        public void set(T value) {
            this.value = value;
        }

        public T get() {
            return this.value;
        }

        public String getKey() {
            return this.key;
        }

        public T getDefault() {
            return this.defaultValue;
        }

        public void reset() {
            this.value = this.defaultValue;
        }

        void deserializeAndSet(@Nullable String value) {
            if (value == null) {
                this.value = this.defaultValue;
                return;
            }
            try {
                this.value = this.deserializer.apply(value);
            }
            catch (Exception e) {
                this.value = this.defaultValue;
                PackedPacks.LOGGER.error("[packed_packs] Failed to read preference '{}' with value '{}'. ", new Object[]{this.key, value, e});
            }
        }

        static <T> Function<String, T> getDefaultDeserializer(T defaultValue) {
            if (defaultValue instanceof Boolean) {
                return value -> Boolean.parseBoolean(value);
            }
            if (defaultValue instanceof Integer) {
                return value -> Integer.parseInt(value);
            }
            if (defaultValue instanceof String) {
                return value -> value;
            }
            throw new UnsupportedOperationException("No default deserializer for " + String.valueOf(defaultValue));
        }
    }
}

