/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.pack;

import com.google.common.hash.Hashing;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.pack.folder.FolderPack;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3288;
import net.minecraft.class_7367;
import org.jetbrains.annotations.Nullable;

public class PackAssetManager {
    public static final Sprite DEFAULT_FOLDER_ICON = Sprite.of16(ResourceUtil.getResource("textures/misc/unknown_folder.png"));
    public static final Sprite DEFAULT_ICON = Sprite.of16(class_2960.method_60656((String)"textures/misc/unknown_pack.png"));
    private final Map<String, Sprite> cachedIcons = new Object2ObjectOpenHashMap();
    private final class_310 minecraft;
    private Map<String, Sprite> staleIcons;

    public PackAssetManager(class_310 minecraft) {
        this.minecraft = minecraft;
    }

    public Sprite getIcon(class_3288 pack) {
        return this.cachedIcons.getOrDefault(pack.method_14463(), this.staleIcons != null ? this.staleIcons.getOrDefault(pack.method_14463(), PackAssetManager.getDefaultIcon(pack)) : PackAssetManager.getDefaultIcon(pack));
    }

    public void getOrLoadIcon(class_3288 pack, Consumer<Sprite> iconCallback) {
        Sprite cachedIcon;
        Sprite staleIcon;
        if (this.staleIcons != null && (staleIcon = this.staleIcons.get(pack.method_14463())) != null) {
            iconCallback.accept(staleIcon);
        }
        if ((cachedIcon = this.cachedIcons.get(pack.method_14463())) != null) {
            iconCallback.accept(cachedIcon);
        } else {
            this.loadPackIcon(pack).thenAcceptAsync(location -> {
                Sprite sprite = location != null ? Sprite.of16(location) : PackAssetManager.getDefaultIcon(pack);
                this.cachedIcons.put(pack.method_14463(), sprite);
                iconCallback.accept(sprite);
            }, (Executor)this.minecraft);
        }
    }

    public void clearIconCache() {
        this.staleIcons = new Object2ObjectOpenHashMap(this.cachedIcons);
        this.cachedIcons.clear();
    }

    public static Sprite getDefaultIcon(class_3288 pack) {
        return pack instanceof FolderPack ? DEFAULT_FOLDER_ICON : DEFAULT_ICON;
    }

    public static class_2960 getDefaultLocation(class_3288 pack) {
        return PackAssetManager.getDefaultIcon((class_3288)pack).location;
    }

    private CompletableFuture<@Nullable class_2960> loadPackIcon(class_3288 pack) {
        return CompletableFuture.supplyAsync(() -> {
            try (class_3262 packResources = pack.method_14458();){
                class_2960 class_29602;
                block17: {
                    class_7367 iconIoSupplier = packResources.method_14410(new String[]{"pack.png"});
                    if (iconIoSupplier == null) {
                        class_2960 class_29603 = null;
                        return class_29603;
                    }
                    class_2960 icon = class_2960.method_60656((String)PackAssetManager.hashIconName(pack.method_14463()));
                    InputStream iconStream = (InputStream)iconIoSupplier.get();
                    try {
                        class_1011 nativeImage = class_1011.method_4309((InputStream)iconStream);
                        class_1060 manager = this.minecraft.method_1531();
                        this.minecraft.execute(() -> manager.method_4616(icon, (class_1044)new class_1043(nativeImage)));
                        class_29602 = icon;
                        if (iconStream == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (iconStream != null) {
                            try {
                                iconStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    iconStream.close();
                }
                return class_29602;
            }
            catch (Exception e) {
                if (!(e instanceof NoSuchFileException)) {
                    PackedPacks.LOGGER.warn("Failed to load icon from pack '{}'", (Object)pack.method_14463(), (Object)e);
                }
                return null;
            }
        }, class_156.method_18349());
    }

    private static String hashIconName(String id) {
        return "pack/" + class_156.method_30309((String)id, class_2960::method_29184) + "/" + String.valueOf(Hashing.sha1().hashUnencodedChars((CharSequence)id)) + "/icon";
    }
}

