package io.github.fishstiz.packed_packs.compat.etf;

import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.compat.Mod;
import io.github.fishstiz.packed_packs.compat.api.ModExtension;
import io.github.fishstiz.packed_packs.config.Preferences;
import io.github.fishstiz.packed_packs.gui.metadata.Toggleable;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_5375;

public class ETFModExtension implements ModExtension {
    @Override
    public class_2960 id() {
        return Mod.ETF.getInternalId();
    }

    @Override
    public void onCreateHeader(class_3264 type, FlexLayout header, class_5375 screen) {
        if (type != class_3264.field_14188) return;

        Mod.ETF.wrapError(header, screen, (layout, prev) -> {
            if (PackedPacks.CONFIG.isDevMode() || Preferences.INSTANCE.etfButton.get()) {
                layout.addChild(ETFButtonFactory.create(prev));
            }
        });
    }

    @Override
    public void onCreatePreferencesMenu(class_3264 type, ContextMenuItemBuilder builder) {
        if (type != class_3264.field_14188) return;

        Mod.ETF.wrapError(builder, b -> b.add(Toggleable.fromPref(Preferences.INSTANCE.etfButton)));
    }
}
