package io.github.fishstiz.fidgetz.transform.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.fishstiz.fidgetz.transform.interfaces.UnpaddedScrollableLayout;
import net.minecraft.class_11467;
import net.minecraft.class_7528;
import net.minecraft.class_8133;
import net.minecraft.class_9017;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;

@Mixin(class_11467.class)
public abstract class ScrollableLayoutMixin implements UnpaddedScrollableLayout {
    @Shadow
    @Final
    class_8133 content;

    @Shadow
    private int maxHeight;

    @Shadow
    private int minWidth;

    @Unique
    private boolean fidgetz$unpadded;

    @Override
    public void fidgetz$setUnpadded(boolean unpadded) {
        this.fidgetz$unpadded = unpadded;
    }

    @Override
    public boolean fidgetz$unpadded() {
        return this.fidgetz$unpadded;
    }

    @WrapOperation(method = "arrangeElements", at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/gui/components/ScrollableLayout$Container;setWidth(I)V"
    ))
    private void removePaddingOnArrange(@Coerce class_9017 instance, int width, Operation<Void> original) {
        if (this.fidgetz$unpadded) {
            boolean scrollbarVisible = this.content.method_25364() > this.maxHeight;
            original.call(instance, Math.max(this.content.method_25368() + (scrollbarVisible ? class_7528.field_55258 : 0), this.minWidth));
        } else {
            original.call(instance, width);
        }
    }
}
