package io.github.fishstiz.packed_packs.compat.resourcify;

import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.packed_packs.compat.Mod;
import io.github.fishstiz.packed_packs.compat.ModExtensionInternal;
import io.github.fishstiz.packed_packs.gui.screens.PackedPacksScreen;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_4185;
import net.minecraft.class_5375;

public class ResourcifyModExtension implements ModExtensionInternal {
    @Override
    public Mod mod() {
        return Mod.RESOURCIFY;
    }

    @Override
    public @Nullable class_2960 loadAfter() {
        return Mod.VTD.getInternalId();
    }

    @Override
    public void onCreateHeader(class_3264 type, FlexLayout header, PackedPacksScreen screen, class_5375 original) {
        this.mod().wrapError(header, original, (layout, packScreen) -> {
            List<? extends class_4185> buttons = ResourcifyButtons.getButtons(packScreen);
            if (buttons != null) {
                for (class_4185 button : buttons.reversed()) {
                    layout.addChild(button);
                }
            }
        });
    }
}
