package io.github.fishstiz.packed_packs.gui.screens;

import io.github.fishstiz.packed_packs.gui.components.events.*;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.pack.PackAssetManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_8016;

public abstract class PackListEventHandler extends class_437 implements PackListEventListener, DragEventHandler {
    protected final PackAssetManager assetManager;
    private final DragEventRenderer dragEventRenderer;
    private DragEvent dragged;

    protected PackListEventHandler(class_310 minecraft, class_2561 title) {
        super(title);
        this.field_22787 = minecraft;
        this.assetManager = new PackAssetManager(minecraft);
        this.dragEventRenderer = new DragEventRenderer(this.assetManager);
    }

    protected void focus(class_8016 path) {
        this.method_48267();
        path.method_48195(true);
    }

    protected void focus(class_364 element) {
        this.focus(class_8016.method_48194(element, this));
    }

    protected void focusList(PackList packList) {
        PackList.Entry entry = packList.method_25334();

        if (entry != null) {
            this.focus(class_8016.method_48194(entry, packList, this));
        } else {
            this.focus(class_8016.method_48194(packList, this));
        }
    }

    protected void transferFocus(PackList source, PackList destination) {
        source.method_25395(null);
        this.focusList(destination);
    }

    protected void unfocusOtherLists(PackList focused) {
        for (PackList packList : this.getPackLists()) {
            if (packList != focused) {
                packList.method_25395(null);
            }
        }
    }

    protected void handleRequestTransferEvent(RequestTransferEvent event) {
        PackList source = event.target();
        PackList destination = this.getDestination(source);

        if (destination == null || event.payload().isEmpty()) {
            return;
        }

        destination.clearSelection();
        source.removeAll(event.payload());
        destination.addAll(event.payload());
        destination.selectAll(event.payload());
        destination.select(event.trigger());

        this.transferFocus(source, destination);
    }

    @Override
    public void handleDragEvent(DragEvent event) {
        DragEventHandler.super.handleDragEvent(event);
        this.unfocusOtherLists(event.target());
    }

    protected void handleMoveEvent(MoveEvent event) {
        PackList.Entry entry = event.target().getEntry(event.trigger());
        if (entry != null) {
            this.focus(class_8016.method_48194(entry, event.target(), this));
        } else {
            this.focus(event.target());
        }
    }

    @Override
    public @Nullable DragEvent getDragged() {
        return this.dragged;
    }

    @Override
    public void setDragged(@Nullable DragEvent dragged) {
        this.dragged = dragged;
    }

    protected abstract @NotNull List<PackList> getPackLists();

    protected abstract @Nullable PackList getDestination(PackList source);

    protected abstract boolean isUnlocked();

    @Override
    public void onEvent(PackListEvent event) {
        switch (event) {
            case SelectionEvent selection -> this.unfocusOtherLists(selection.target());
            case RequestTransferEvent request -> this.handleRequestTransferEvent(request);
            case MoveEvent move -> this.handleMoveEvent(move);
            case DragEvent drag -> this.handleDragEvent(drag);
            case DropEvent drop -> this.transferFocus(drop.target(), drop.destination());
            default -> {
            }
        }
    }

    @Override
    public void onRelease(@NotNull DragEvent event, double mouseX, double mouseY) {
        for (PackList packList : this.getPackLists()) {
            if (packList.method_49606()) {
                packList.drop(event, mouseX, mouseY);
                return;
            }
        }
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);

        DragEvent event = this.getDragged();
        if (event != null) {
            if (this.isUnlocked()) {
                for (PackList list : this.getPackLists()) {
                    list.renderDroppableZone(guiGraphics, event, mouseX, mouseY, partialTick);
                }
            }

            this.dragEventRenderer.renderDragEvent(event, guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.isDraggingSelection() || super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25400(char codePoint, int modifiers) {
        return this.isDraggingSelection() || super.method_25400(codePoint, modifiers);
    }
}
