/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components;

import io.github.fishstiz.packed_packs.gui.components.SelectionContext;
import io.github.fishstiz.packed_packs.util.InputUtil;
import net.minecraft.class_156;
import net.minecraft.class_364;

public class MouseSelectionHandler<T> {
    private static final double DRAG_THRESHOLD = 1.0;
    private final class_364 inputListener;
    private final SelectionContext<T> context;
    private MouseSelectionState mouseSelectionState = MouseSelectionState.INACTIVE;
    private long lastClickTime = 0L;

    public MouseSelectionHandler(class_364 inputListener, SelectionContext<T> context) {
        this.inputListener = inputListener;
        this.context = context;
    }

    private static boolean exceedsDragThreshold(double dragX, double dragY) {
        return Math.hypot(dragX, dragY) > 1.0;
    }

    private boolean updateDoubleClick() {
        long currentTime = class_156.method_658();
        boolean doubleClicked = currentTime - this.lastClickTime < 250L;
        this.lastClickTime = currentTime;
        return doubleClicked;
    }

    public Action mouseClicked(double mouseX, double mouseY, int button) {
        if (!InputUtil.isLeftClick(button) || !this.inputListener.method_25405(mouseX, mouseY)) {
            this.mouseSelectionState = MouseSelectionState.INACTIVE;
            return Action.NONE;
        }
        if (!InputUtil.isRangeModifierActive() && !InputUtil.isSelectModifierActive() && this.updateDoubleClick()) {
            return Action.TRANSFER;
        }
        if (InputUtil.isRangeModifierActive()) {
            this.mouseSelectionState = MouseSelectionState.SELECTING_MANY;
            return Action.SELECT_RANGE;
        }
        if (InputUtil.isSelectModifierActive()) {
            this.mouseSelectionState = MouseSelectionState.SELECTING_MANY;
            return Action.SELECT_TOGGLE;
        }
        if (!this.context.isSelected()) {
            this.mouseSelectionState = MouseSelectionState.SELECTING_ONE;
            return Action.SELECT_EXCLUSIVE;
        }
        if (!this.context.isSelectedLast()) {
            this.mouseSelectionState = MouseSelectionState.SELECTING_ONE;
            return Action.SELECT;
        }
        this.mouseSelectionState = MouseSelectionState.SELECTING_ONE;
        return Action.FOCUS;
    }

    public Action mouseReleased(double mouseX, double mouseY, int button) {
        if (this.inputListener.method_25405(mouseX, mouseY) && this.mouseSelectionState == MouseSelectionState.SELECTING_ONE && this.context.isSelectedLast() && this.context.selection().size() > 1) {
            this.mouseSelectionState = MouseSelectionState.INACTIVE;
            return Action.SELECT_EXCLUSIVE;
        }
        this.mouseSelectionState = MouseSelectionState.INACTIVE;
        return Action.NONE;
    }

    public Action mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.inputListener.method_25405(mouseX, mouseY)) {
            this.mouseSelectionState = MouseSelectionState.INACTIVE;
            return Action.NONE;
        }
        if (MouseSelectionHandler.exceedsDragThreshold(dragX, dragY) && this.context.isSelected() && this.mouseSelectionState == MouseSelectionState.SELECTING_ONE) {
            return Action.DRAG;
        }
        return Action.NONE;
    }

    private static enum MouseSelectionState {
        INACTIVE,
        SELECTING_ONE,
        SELECTING_MANY;

    }

    public static enum Action {
        NONE(false),
        FOCUS(false),
        SELECT(true),
        SELECT_TOGGLE(true),
        SELECT_EXCLUSIVE(true),
        SELECT_RANGE(true),
        TRANSFER(false),
        DRAG(false);

        private final boolean select;

        private Action(boolean select) {
            this.select = select;
        }

        public boolean shouldDispatch() {
            return this != NONE;
        }

        public boolean shouldSelect() {
            return this.select;
        }
    }
}

