package io.github.fishstiz.fidgetz.gui.components;

import io.github.fishstiz.fidgetz.gui.shapes.Padding;
import net.minecraft.class_437;
import net.minecraft.class_8133;

import static io.github.fishstiz.fidgetz.util.DrawUtil.DEMO_BACKGROUND;

public class Modal<T extends class_8133> extends ToggleableDialog<LayoutWrapper<T>> {
    private static final int MIN_SIZE = 50;

    protected Modal(io.github.fishstiz.fidgetz.gui.components.Modal.Builder<T> builder) {
        super(builder);

        this.root().setPadding(builder.padding);
        this.root().method_48206(this::addRenderableWidget);
    }

    public void repositionElements() {
        this.root().method_48222();
        this.root().method_46421(this.screen.field_22789 / 2 - this.root().method_25368() / 2);
        this.root().method_46419(this.screen.field_22790 / 2 - this.root().method_25364() / 2);
    }

    public void closeModal() {
        this.setOpen(false);
    }

    public void clear() {
        this.clearWidgets();
    }

    public static <S extends class_437 & ToggleableDialogContainer, T extends class_8133> io.github.fishstiz.fidgetz.gui.components.Modal.Builder<T> builder(S screen, T layout) {
        return new io.github.fishstiz.fidgetz.gui.components.Modal.Builder<>(screen, new LayoutWrapper<>(layout, MIN_SIZE, MIN_SIZE));
    }

    public static class Builder<T extends class_8133> extends ToggleableDialog.Builder<LayoutWrapper<T>, io.github.fishstiz.fidgetz.gui.components.Modal.Builder<T>> {
        protected Padding padding = Padding.empty();

        protected <S extends class_437 & ToggleableDialogContainer> Builder(S screen, LayoutWrapper<T> root) {
            super(screen, root);

            this.background = DEMO_BACKGROUND;
        }

        public io.github.fishstiz.fidgetz.gui.components.Modal.Builder<T> padding(Padding padding) {
            this.padding = padding;
            return this;
        }

        public io.github.fishstiz.fidgetz.gui.components.Modal.Builder<T> padding(int padding) {
            return this.padding(new Padding(padding));
        }

        @Override
        public Modal<T> build() {
            return new Modal<>(this);
        }
    }
}
