/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.annotations.SerializedName;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.DevConfig;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.config.Profiles;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

@Deprecated(forRemoval=true)
class ConfigFixer {
    ConfigFixer() {
    }

    static File getPreviousPreferencesFile() {
        return FabricLoader.getInstance().getConfigDir().resolve("packed_packs.preferences.properties").toFile();
    }

    static File getPreviousConfigFile() {
        return FabricLoader.getInstance().getConfigDir().resolve("packed_packs.json").toFile();
    }

    static void migrateConfig(Config config) {
        Instant now = Instant.now();
        PackedPacks.LOGGER.info("[packed_packs] Migrating config...");
        DevConfig devConfig = DevConfig.get();
        try {
            List datapackProfiles = config.getDatapacks().oldProfiles;
            List resourcepackProfiles = config.getResourcepacks().oldProfiles;
            config.save();
            devConfig.getDatapacks().setDefaultProfile(config.getDatapacks().oldDefaultProfile);
            devConfig.getResourcepacks().setDefaultProfile(config.getResourcepacks().oldDefaultProfile);
            devConfig.save();
            if (!datapackProfiles.isEmpty()) {
                config.getDatapacks().availableProfiles = datapackProfiles;
                for (Profile profile : datapackProfiles) {
                    Profiles.save(config.getDatapacks().packType(), profile);
                    PackedPacks.LOGGER.info("[packed_packs] Migrated data pack profile '{}' with id '{}'", (Object)profile.getName(), (Object)profile.getId());
                }
            }
            if (!resourcepackProfiles.isEmpty()) {
                config.getResourcepacks().availableProfiles = resourcepackProfiles;
                for (Profile profile : resourcepackProfiles) {
                    Profiles.save(config.getResourcepacks().packType(), profile);
                    PackedPacks.LOGGER.info("[packed_packs] Migrated resource pack profile '{}' with id '{}'", (Object)profile.getName(), (Object)profile.getId());
                }
            }
            PackedPacks.LOGGER.info("[packed_packs] Config migrated in {} ms.", (Object)Duration.between(now, Instant.now()).toMillis());
        }
        catch (Exception e) {
            PackedPacks.LOGGER.warn("[packed_packs] Failed to migrate config. ", (Throwable)e);
        }
    }

    static class ProfileExclusionStrategy
    implements ExclusionStrategy {
        private static final String DEFAULT_PROFILE = "defaultProfile";
        private static final String PROFILES_ARRAY = "profiles";
        private static final String PROFILE_ID = "id";

        ProfileExclusionStrategy() {
        }

        public boolean shouldSkipField(FieldAttributes f) {
            if (Config.Packs.class.isAssignableFrom(f.getDeclaringClass())) {
                if (f.getName().equals(PROFILES_ARRAY) || f.getName().equals(DEFAULT_PROFILE)) {
                    return true;
                }
                SerializedName serializedName = (SerializedName)f.getAnnotation(SerializedName.class);
                if (serializedName != null) {
                    if (serializedName.value().equals(PROFILES_ARRAY)) {
                        return true;
                    }
                    if (serializedName.value().equals(DEFAULT_PROFILE)) {
                        return true;
                    }
                }
            }
            return f.getDeclaringClass().equals(Profile.class) && f.getName().equals(PROFILE_ID);
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    }
}

