package io.github.fishstiz.fidgetz.gui.components;

import io.github.fishstiz.fidgetz.util.GuiUtil;
import net.minecraft.class_310;
import net.minecraft.class_4265;
import net.minecraft.class_8030;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFixedListWidget<T extends AbstractFixedListWidget<T>.Entry> extends class_4265<T> {
    protected static final int DEFAULT_SCROLLBAR_OFFSET = 6;
    protected final int scrollbarOffset;
    protected final int offsetY;
    protected final int rowGap;

    protected AbstractFixedListWidget(int itemHeight, int scrollbarOffset, int offsetY, int rowGap) {
        super(class_310.method_1551(), 0, 0, 0, itemHeight + rowGap);

        this.scrollbarOffset = scrollbarOffset;
        this.offsetY = offsetY;
        this.rowGap = rowGap;
    }

    protected AbstractFixedListWidget(int itemHeight, int offsetY, int rowGap) {
        this(itemHeight, DEFAULT_SCROLLBAR_OFFSET, offsetY, rowGap);
    }

    protected AbstractFixedListWidget(int itemHeight) {
        this(itemHeight, 0, 0);
    }

    @Override
    protected boolean method_74038(double mouseX, double mouseY) {
        return super.method_74038(mouseX, mouseY) && this.method_49606();
    }

    protected boolean beforeScrollbarX(double mouseX) {
        return !this.method_44392() || mouseX < this.method_65507();
    }

    public void setClampedScrollAmount(double scrollAmount) {
        this.method_44382(Math.clamp(scrollAmount, 0d, this.method_44390()));
    }

    public void clampScrollAmount() {
        this.setClampedScrollAmount(this.method_44387());
    }

    @Override
    protected int method_65507() {
        return this.method_55442() - field_55258;
    }

    @Override
    public int method_25322() {
        return this.method_44392() ? this.method_25368() - field_55258 : this.method_25368();
    }

    @Override
    public int method_25342() {
        return this.method_46426();
    }

    @Override
    public int method_25337(int index) {
        return (this.method_46427() + this.offsetY) - (int) this.method_44387() + index * this.field_62109;
    }

    protected int getRowIndex(double y) {
        int index = (int) Math.floor(Math.max(0, y - (this.method_46427() + this.offsetY) + this.method_44387()) / this.field_62109);
        return index >= 0 && index < this.method_25340() ? index : -1;
    }

    @Override
    public void method_53533(int height) {
        super.method_53533(height);
        this.clampScrollAmount();
    }

    @Override
    public void method_55445(int width, int height) {
        super.method_55445(width, height);
        this.clampScrollAmount();
    }

    @Override
    protected int method_44395() {
        return this.offsetY * 2 + this.method_25340() * this.field_62109 - this.rowGap;
    }

    public int getItemHeight() {
        return this.field_62109 - this.rowGap;
    }

    protected T getEntry(int index) {
        return this.method_25396().get(index);
    }

    protected @Nullable T getPreviousEntry() {
        T current = this.method_25334();
        if (current != null && current.getIndex() > 0) {
            return this.method_25396().get(current.getIndex() - 1);
        } else if (current == null && !this.method_25396().isEmpty()) {
            return this.method_25396().getFirst();
        }
        return null;
    }

    protected @Nullable T getNextEntry() {
        T current = this.method_25334();
        if (current != null && current.getIndex() + 1 < this.method_25396().size()) {
            return this.method_25396().get(current.getIndex() + 1);
        } else if (current == null && !this.method_25396().isEmpty()) {
            return this.method_25396().getFirst();
        }
        return null;
    }

    public abstract class Entry extends class_4265.class_4266<T> {
        protected final int index;

        protected Entry(int index) {
            this.index = index;
        }

        protected Entry() {
            this(AbstractFixedListWidget.this.method_25396().size());
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public int method_46426() {
            return AbstractFixedListWidget.this.method_25342();
        }

        @Override
        public int method_46427() {
            return AbstractFixedListWidget.this.method_25337(this.index);
        }

        @Override
        public int method_25368() {
            return AbstractFixedListWidget.this.method_25322();
        }

        @Override
        public int method_25364() {
            return AbstractFixedListWidget.this.getItemHeight();
        }

        public int getRight() {
            return this.method_46426() + this.method_25368();
        }

        public int getBottom() {
            return this.method_46427() + this.method_25364();
        }

        @Override
        public @NotNull class_8030 method_48202() {
            return new class_8030(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            return GuiUtil.containsPoint(this, mouseX, mouseY);
        }
    }
}
