package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.components.*;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuContainer;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.util.DrawUtil;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.compat.ModAdditions;
import io.github.fishstiz.packed_packs.config.Preferences;
import io.github.fishstiz.packed_packs.gui.components.MouseSelectionHandler;
import io.github.fishstiz.packed_packs.gui.components.SelectionContext;
import io.github.fishstiz.packed_packs.gui.components.contextmenu.PackMenuHeader;
import io.github.fishstiz.packed_packs.gui.history.Restorable;
import io.github.fishstiz.packed_packs.gui.metadata.Toggleable;
import io.github.fishstiz.packed_packs.pack.PackAssetManager;
import io.github.fishstiz.packed_packs.pack.PackFileOperations;
import io.github.fishstiz.packed_packs.pack.PackOptionsContext;
import io.github.fishstiz.packed_packs.transform.interfaces.FilePack;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.ToastUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import io.github.fishstiz.packed_packs.gui.components.events.*;
import io.github.fishstiz.packed_packs.pack.folder.FolderPack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import net.minecraft.class_8016;
import net.minecraft.class_8023;

import static io.github.fishstiz.fidgetz.util.GuiUtil.playClickSound;
import static io.github.fishstiz.packed_packs.util.InputUtil.*;
import static io.github.fishstiz.packed_packs.util.constants.GuiConstants.*;
import static io.github.fishstiz.packed_packs.util.lang.ObjectsUtil.*;

public abstract class PackList extends AbstractFixedListWidget<PackList.Entry> implements
        Restorable<PackList.Snapshot>,
        ContainerEventHandlerPatch,
        ContextMenuContainer {
    protected static final int Y_OFFSET = 1;
    protected static final int ITEM_HEIGHT = 35;
    protected static final int ROW_GAP = 3;
    protected final PackOptionsContext options;
    protected final PackAssetManager assets;
    protected final PackListModel list;
    private final PackFileOperations fileOps;
    private final PackListEventListener listener;

    protected PackList(PackOptionsContext options, PackAssetManager assets, PackFileOperations fileOps, PackListEventListener listener) {
        super(ITEM_HEIGHT);
        this.assets = assets;
        this.options = options;
        this.fileOps = fileOps;
        this.listener = listener;
        this.list = new PackListModel(this.options);
        this.refreshList();
    }

    protected abstract @NotNull io.github.fishstiz.packed_packs.gui.components.pack.PackList.Entry createEntry(SelectionContext<class_3288> context, int index);

    public @Nullable io.github.fishstiz.packed_packs.gui.components.pack.PackList.Entry getEntry(@Nullable class_3288 pack) {
        if (pack == null) return null;
        for (io.github.fishstiz.packed_packs.gui.components.pack.PackList.Entry entry : this.method_25396()) {
            if (Objects.equals(entry.pack(), pack)) return entry;
        }
        return null;
    }

    private void refreshEntries() {
        io.github.fishstiz.packed_packs.gui.components.pack.PackList.Entry focused = this.method_25336();
        List<class_3288> selection = this.list.getSelection();
        List<class_3288> visiblePacks = this.list.getVisibleItems();

        this.method_25339();
        for (int i = 0; i < visiblePacks.size(); i++) {
            this.method_25321(this.createEntry(new SelectionContext<>(selection, visiblePacks.get(i)), i));
        }

        this.clampScrollAmount();
        this.method_25395(mapOrNull(focused, f -> this.getEntry(f.pack())));
    }

    protected void refreshList() {
        this.list.refresh();
        this.refreshEntries();
    }

    public void scrollToTop() {
        this.method_44382(0);
    }

    public void reload(Collection<class_3288> packs) {
        this.list.replaceAll(packs);
        this.method_25395(null);
        this.refresh();
    }

    public @NotNull List<class_3288> copyPacks() {
        return List.copyOf(this.list.getItems());
    }

    public List<class_3288> getOrderedSelection() {
        return this.list.getOrderedSelection();
    }

    public void clearSelection() {
        this.list.clearSelection();
    }

    private void refresh() {
        this.clearSelection();
        this.refreshList();
        this.scrollToTop();
    }

    public void sort(Query.SortOption sort) {
        if (this.list.sort(sort)) {
            this.refresh();
        }
    }

    public void hideIncompatible(boolean hideIncompatible) {
        if (this.list.hideIncompatible(hideIncompatible)) {
            this.clearSelection();
            this.refreshList();
        }
    }

    public void search(@NotNull String search) {
        if (this.list.search(search)) {
            this.refresh();
        }
    }

    public boolean isQueried() {
        return this.list.isQueried();
    }

    public void addAll(List<class_3288> packs) {
        for (class_3288 pack : packs) {
            this.list.add(pack);
        }
        this.refreshList();
    }

    public void addOrMove(class_3288 pack, int to) {
        this.list.insertOrMove(to, pack);
        this.list.select(pack);
    }

    public boolean moveAll(List<class_3288> selection, int to) {
        if (this.list.moveAll(to, selection)) {
            this.refreshList();
            return true;
        }
        return true;
    }

    private boolean removePack(class_3288 pack) {
        io.github.fishstiz.packed_packs.gui.components.pack.PackList.Entry focused = this.method_25336();
        if (this.list.remove(pack)) {
            if (focused != null && focused.pack().method_14463().equals(pack.method_14463())) {
                this.method_25395(null);
            }
            return true;
        }
        return false;
    }

    public void remove(class_3288 pack) {
        this.removePack(pack);
        this.refreshList();
    }

    public void removeAll(List<class_3288> packs) {
        boolean removed = false;
        for (class_3288 pack : packs) {
            removed |= this.removePack(pack);
        }
        if (removed) {
            this.refreshList();
        }
    }

    public @Nullable class_3288 getLastSelected() {
        return this.list.getLastSelected();
    }

    @Override
    public @Nullable io.github.fishstiz.packed_packs.gui.components.pack.PackList.Entry method_25334() {
        return this.getLastSelected() != null ? this.getEntry(this.getLastSelected()) : super.method_25334();
    }

    @Override
    public void setSelected(@Nullable io.github.fishstiz.packed_packs.gui.components.pack.PackList.Entry selected) {
        this.field_22751 = selected;
    }

    public boolean isSelected(class_3288 pack) {
        return this.list.isSelected(pack);
    }

    public void scrollToLastSelected() {
        ifPresent(this.getEntry(this.getLastSelected()), this::method_73377);
    }

    public void unselect(class_3288 pack) {
        this.list.unselect(pack);

        io.github.fishstiz.packed_packs.gui.components.pack.PackList.Entry entry = this.getEntry(pack);
        if (entry == this.method_25336()) {
            this.method_25395(null);
        }
        if (entry == this.method_25334()) {
            this.setSelected(null);
        }
    }

    public void select(class_3288 pack) {
        if (this.list.select(pack)) {
            io.github.fishstiz.packed_packs.gui.components.pack.PackList.Entry entry = this.getEntry(pack);
            this.method_25395(entry);
            this.setSelected(entry);
        }
    }

    public void selectAll() {
        this.list.getVisibleItems().forEach(this::select);
    }

    public void selectAll(List<class_3288> packs) {
        packs.forEach(this::select);
    }

    public void selectExclusive(class_3288 pack) {
        this.clearSelection();
        this.select(pack);
    }

    public void selectToggle(class_3288 pack) {
        if (this.isSelected(pack)) {
            this.unselect(pack);
        } else {
            this.select(pack);
        }
    }

    public void selectRange(class_3288 pack) {
        this.list.selectRange(pack);
        this.select(pack);
    }

    public boolean isTransferable(class_3288 pack) {
        return testNullable(this.getEntry(pack), PackList.Entry::isTransferable);
    }

    public void transferAll() {
        List<class_3288> payload = new ArrayList<>();
        List<class_3288> visiblePacks = this.list.getVisibleItems();
        for (int i = visiblePacks.size() - 1; i >= 0; i--) {
            class_3288 pack = visiblePacks.get(i);
            if (this.isTransferable(pack)) {
                payload.add(pack);
            }
        }
        if (!payload.isEmpty()) {
            this.sendEvent(new RequestTransferEvent(this, this.getLastSelected(), payload));
        }
    }

    protected void sendEvent(PackListEvent event) {
        this.listener.onEvent(event);
    }

    public abstract boolean canInteract(PackList source);

    protected abstract boolean canDrop(DragEvent dragEvent, double mouseX, double mouseY);

    protected abstract List<class_3288> handleDrop(DragEvent dragEvent, double mouseX, double mouseY);

    public abstract void renderDroppableZone(class_332 guiGraphics, DragEvent dragEvent, int mouseX, int mouseY, float partialTick);

    public final void drop(DragEvent dragEvent, double mouseX, double mouseY) {
        if (this.options.isLocked()) return;

        List<class_3288> dropped = this.handleDrop(dragEvent, mouseX, mouseY);
        if (!dropped.isEmpty()) {
            if (dragEvent.target() != this) {
                this.sendEvent(new DropEvent(dragEvent.target(), this, dropped));
            } else {
                this.sendEvent(new MoveEvent(this, dragEvent.trigger(), dropped));
            }
        }
    }

    protected void openFolder(FolderPack folderPack) {
        this.sendEvent(new FolderOpenEvent(this, folderPack));
    }

    private @Nullable class_8016 method_48214(class_8023.class_8024 arrowNavigation) {
        io.github.fishstiz.packed_packs.gui.components.pack.PackList.Entry entry = switch (arrowNavigation.comp_1191()) {
            case field_41826 -> this.getPreviousEntry();
            case field_41827 -> this.getNextEntry();
            default -> null;
        };
        if (entry != null) {
            if (isRangeModifierActive()) {
                this.selectRange(entry.pack());
            } else {
                this.selectExclusive(entry.pack());
            }
            this.sendEvent(new SelectionEvent(this));
            this.method_73377(entry);
            return class_8016.method_48194(entry, this);
        }
        this.method_25395(null);
        return null;
    }

    @Override
    public @Nullable class_8016 method_48205(class_8023 event) {
        if (!this.method_25370()) {
            class_3288 lastSelected = this.getLastSelected();
            io.github.fishstiz.packed_packs.gui.components.pack.PackList.Entry entry = null;
            if (lastSelected != null) {
                entry = this.getEntry(lastSelected);
            } else if (!this.method_25396().isEmpty()) {
                entry = this.method_25396().getFirst();
            }
            if (entry != null) {
                this.select(entry.pack());
                this.method_73377(entry);
                return class_8016.method_48194(entry, this);
            }
        } else if (event instanceof class_8023.class_8024 arrowNavigation) {
            return this.method_48214(arrowNavigation);
        } else {
            this.method_25395(null);
        }
        return null;
    }

    @Override
    public boolean method_25404(class_11908 keyEvent) {
        io.github.fishstiz.packed_packs.gui.components.pack.PackList.Entry entry = this.getEntry(this.getLastSelected());
        if (isExpandFolder(keyEvent) && entry != null && entry.folderWidget != null && this.list.getSelection().size() == 1) {
            this.openFolder(entry.folderWidget.getMetadata());
            return true;
        }
        if (isTransfer(keyEvent)) {
            if (entry != null && entry.transfer()) {
                playClickSound();
            }
            return entry != null;
        }
        return super.method_25404(keyEvent);
    }

    @Override
    public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClicked) {
        boolean scrolling = this.method_65505(mouseButtonEvent);
        return this.method_25405(mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799()) &&
               ContainerEventHandlerPatch.super.mouseClickedAt(mouseButtonEvent, doubleClicked) ||
               scrolling;
    }

    @Override
    protected void method_25311(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25311(guiGraphics, mouseX, mouseY, partialTick);

        io.github.fishstiz.packed_packs.gui.components.pack.PackList.Entry focused = this.method_25336();
        if (focused != null && focused.method_25370() && this.method_25396().contains(focused)) {
            int outlineTop = focused.method_46427();
            int outlineHeight = focused.method_25364() + Y_OFFSET;
            DrawUtil.renderOutline(guiGraphics, focused.method_46426(), outlineTop, focused.method_25368(), outlineHeight, Theme.WHITE.getARGB());
        }
    }

    @Override
    public int method_44390() {
        int maxScrollAmount = super.method_44390();
        return maxScrollAmount > 0 ? maxScrollAmount + Y_OFFSET : maxScrollAmount;
    }

    public @NotNull io.github.fishstiz.packed_packs.gui.components.pack.PackList.Snapshot captureState(String eventName) {
        return new io.github.fishstiz.packed_packs.gui.components.pack.PackList.Snapshot(this);
    }

    public void replaceState(@NotNull io.github.fishstiz.packed_packs.gui.components.pack.PackList.Snapshot snapshot) {
        snapshot.model.restore();
        this.refreshEntries();
        this.method_25395(this.getEntry(snapshot.focused));
        this.setSelected(this.getEntry(snapshot.selected));
    }

    public record Snapshot(
            PackList target,
            @Nullable class_3288 focused,
            @Nullable class_3288 selected,
            PackListModel.Snapshot model
    ) implements Restorable.Snapshot<io.github.fishstiz.packed_packs.gui.components.pack.PackList.Snapshot> {
        public Snapshot(PackList target, PackListModel.Snapshot model) {
            this(target, extractPack(target.method_25336()), extractPack(target.method_25334()), model);
        }

        public Snapshot(PackList target) {
            this(target, target.list.captureState());
        }

        public io.github.fishstiz.packed_packs.gui.components.pack.PackList.Snapshot replaceAll(List<class_3288> packs) {
            return new io.github.fishstiz.packed_packs.gui.components.pack.PackList.Snapshot(this.target, this.focused, this.selected, this.model.replaceAll(packs));
        }

        public io.github.fishstiz.packed_packs.gui.components.pack.PackList.Snapshot retainAll(Set<class_3288> packs) {
            return new io.github.fishstiz.packed_packs.gui.components.pack.PackList.Snapshot(this.target, this.focused, this.selected, this.model.retainAll(packs));
        }
    }

    private static @Nullable class_3288 extractPack(@Nullable io.github.fishstiz.packed_packs.gui.components.pack.PackList.Entry entry) {
        return mapOrNull(entry, io.github.fishstiz.packed_packs.gui.components.pack.PackList.Entry::pack);
    }

    public abstract class Entry extends AbstractFixedListWidget<io.github.fishstiz.packed_packs.gui.components.pack.PackList.Entry>.Entry implements ContainerEventHandlerPatch, ContextMenuContainer {
        private static final int V_MARGIN = ROW_GAP / 2 + Y_OFFSET;
        private static final int BACKGROUND_MARGIN = 1;
        private static final class_7919 FOLDER_OPEN_INFO = class_7919.method_47407(FolderPack.FOLDER_OPEN_TEXT);
        protected static final int H_SPACING = 2;
        protected static final ColoredRect SELECTED_OVERLAY = new ColoredRect(Theme.BLUE_500.withAlpha(0.25F));
        protected final SelectionContext<class_3288> context;
        private final List<class_364> children = new ArrayList<>();
        private final List<class_4068> renderables = new ArrayList<>();
        private final List<class_4068> topRenderables = new ArrayList<>();
        private final List<class_6379> narratables = new ArrayList<>();
        private final MouseSelectionHandler<class_3288> selectionHandler;
        private final PackWidget packWidget;
        private final @Nullable PackListDevMenu devMenu;
        private FidgetzButton<FolderPack> folderWidget;
        private boolean stale = false;

        protected Entry(SelectionContext<class_3288> context, int index) {
            super(index);
            this.context = context;
            this.selectionHandler = new MouseSelectionHandler<>(this, context);
            this.packWidget = this.addRenderableWidget(new PackWidget(
                    this.pack(),
                    PackList.this.assets,
                    this.method_46426(),
                    PackList.this.method_25337(this.index),
                    this.method_25368(),
                    ITEM_HEIGHT - ROW_GAP,
                    H_SPACING
            ));
            boolean devMode = PackedPacks.CONFIG.isDevMode();
            if (this.pack() instanceof FolderPack folderPack && (devMode || Preferences.INSTANCE.folderPackWidget.get())) {
                this.folderWidget = this.addTopRenderableOnly(this.prependWidget(
                        Toggleable.applyPref(Preferences.INSTANCE.folderPackWidget, FidgetzButton.<FolderPack>builder())
                                .setTooltip(FOLDER_OPEN_INFO)
                                .setHeight(this.packWidget.method_25364() / 3)
                                .makeSquare()
                                .setSprite(GuiConstants.HAMBURGER_SPRITE)
                                .setFocusOnInteract(false)
                                .setMetadata(folderPack)
                                .setOnPress(this::openFolder)
                                .build()
                ));
            }
            this.devMenu = devMode ? createDevMenu(PackList.this.options, this.context) : null;
            ModAdditions.onCreateEntry(PackList.this.options.getConfig().packType(), this);
        }

        protected @Nullable PackListDevMenu createDevMenu(PackOptionsContext options, SelectionContext<class_3288> context) {
            return new PackListDevMenu(options, context);
        }

        public class_3288 pack() {
            return this.context.item();
        }

        public <U extends class_364 & class_4068> U addRenderableWidget(U widget) {
            this.children.add(widget);
            this.renderables.add(widget);
            if (widget instanceof class_6379 narratable) this.narratables.add(narratable);
            return widget;
        }

        public <U extends class_364> U prependWidget(U widget) {
            this.children.addFirst(widget);
            if (widget instanceof class_6379 narratable) this.narratables.add(narratable);
            return widget;
        }

        public <U extends class_4068> U addTopRenderableOnly(U renderable) {
            this.topRenderables.add(renderable);
            return renderable;
        }

        public boolean isTransferable() {
            return !PackList.this.options.isLocked() && !this.isStale();
        }

        public boolean isSelected() {
            return this.context.isSelected();
        }

        public boolean isSelectedLast() {
            return this.context.isSelectedLast();
        }

        protected void sendPacks(class_3288 trigger, List<class_3288> payload) {
            PackList.this.sendEvent(new RequestTransferEvent(PackList.this, trigger, payload));
        }

        private boolean sendSelection() {
            List<class_3288> payload = new ObjectArrayList<>();

            for (class_3288 selected : PackList.this.getOrderedSelection().reversed()) {
                if (PackList.this.isTransferable(selected)) {
                    payload.add(selected);
                }
            }

            if (!payload.isEmpty()) {
                class_3288 trigger = this.isTransferable() ? this.pack() : null;
                this.sendPacks(trigger, payload);
                return true;
            }

            return false;
        }

        public boolean transfer() {
            if (!this.isSelected() && this.isTransferable()) {
                PackList.this.sendEvent(new RequestTransferEvent(PackList.this, this.pack()));
                return true;
            }

            return this.sendSelection();
        }

        protected boolean handleMouseAction(MouseSelectionHandler.Action action) {
            if (!action.shouldDispatch() || this.isStale()) return false;

            switch (action) {
                case SELECT -> PackList.this.select(this.pack());
                case SELECT_TOGGLE -> PackList.this.selectToggle(this.pack());
                case SELECT_EXCLUSIVE -> PackList.this.selectExclusive(this.pack());
                case SELECT_RANGE -> PackList.this.selectRange(this.pack());
                case TRANSFER -> {
                    if (this.isTransferable()) {
                        PackList.this.sendEvent(new RequestTransferEvent(PackList.this, this.pack()));
                        return false;
                    }
                }
                case DRAG ->
                        PackList.this.sendEvent(new DragEvent(PackList.this, PackList.this.getOrderedSelection().reversed(), this.pack()));
            }

            if (action.shouldSelect()) {
                PackList.this.sendEvent(new SelectionEvent(PackList.this));
            }

            return true;
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            return PackList.this.beforeScrollbarX(mouseX) && super.method_25405(mouseX, mouseY);
        }

        @Override
        public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClicked) {
            if (ContainerEventHandlerPatch.super.method_25402(mouseButtonEvent, doubleClicked)) {
                return false;
            }
            return this.handleMouseAction(this.selectionHandler.mouseClicked(mouseButtonEvent));
        }

        @Override
        public boolean method_25406(class_11909 mouseButtonEvent) {
            return this.handleMouseAction(this.selectionHandler.mouseReleased(mouseButtonEvent));
        }

        @Override
        public boolean method_25403(class_11909 mouseButtonEvent, double dragX, double dragY) {
            return this.handleMouseAction(this.selectionHandler.mouseDragged(mouseButtonEvent, dragX, dragY));
        }

        @Override
        public boolean method_25404(class_11908 keyEvent) {
            if (super.method_25404(keyEvent)) {
                return true;
            }
            if (isOpenFile(keyEvent)) {
                PackUtil.openPack(this.pack());
                return true;
            }
            if (isOpenFolder(keyEvent)) {
                PackUtil.openParent(this.pack());
                return true;
            }
            if (isDelete(keyEvent) && this.canOperateFile()) {
                this.deletePack();
                return true;
            }
            if (isRename(keyEvent) && this.canOperateFile()) {
                this.renamePack();
                return true;
            }
            return false;
        }

        public void renderBack(class_332 guiGraphics, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (!this.pack().method_14460().method_14437() && !PackList.this.options.getConfig().isIncompatibleWarningsHidden()) {
                int backgroundLeft = left + BACKGROUND_MARGIN;
                int backgroundTop = top + BACKGROUND_MARGIN;
                int backgroundRight = backgroundLeft + width - BACKGROUND_MARGIN;
                int backgroundBottom = backgroundTop + height - BACKGROUND_MARGIN;

                guiGraphics.method_25294(backgroundLeft, backgroundTop, backgroundRight, backgroundBottom, Theme.RED_900.getARGB());
            }
        }

        protected abstract void renderForeground(class_332 guiGraphics, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick);

        private void renderSelection(class_332 guiGraphics, int top, int left, int width, int height) {
            if (this.isSelected()) {
                pick(isSelectedLast(), WHITE_OVERLAY, SELECTED_OVERLAY).render(guiGraphics, left, top, width, height);
                DrawUtil.renderOutline(guiGraphics, left, top, width, height, Theme.BLUE_500.getARGB());
            }
        }

        protected void renderTop(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.folderWidget != null) {
                int folderWidgetY = this.getBottom() - this.folderWidget.method_25364() - BACKGROUND_MARGIN;
                this.folderWidget.method_48229(this.packWidget.getContentLeft(), folderWidgetY);
            }

            for (class_4068 renderable : this.topRenderables) {
                renderable.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        @Override
        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            hovering = hovering && PackList.this.beforeScrollbarX(mouseX) && GuiUtil.isHovered(this, mouseX, mouseY);

            int left = this.method_46426();
            int top = this.method_46427();
            int width = this.method_25368();
            int height = this.method_25364();
            int innerTop = top + V_MARGIN;
            int innerHeight = height - ROW_GAP;

            this.packWidget.method_48229(left, innerTop);
            this.packWidget.method_25358(width);

            this.renderBack(guiGraphics, top, left, width, height, mouseX, mouseY, hovering, partialTick);

            for (class_4068 renderable : this.renderables) {
                renderable.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }

            this.renderSelection(guiGraphics, top, left, width, height + Y_OFFSET);
            this.renderForeground(guiGraphics, innerTop, left, width, innerHeight, mouseX, mouseY, hovering, partialTick);
            this.renderTop(guiGraphics, mouseX, mouseY, partialTick);

            if (this.devMenu != null) {
                this.devMenu.renderDevSprites(guiGraphics, innerTop, left, width);
            }
        }

        @Override
        public void buildItems(ContextMenuItemBuilder builder, int mouseX, int mouseY) {
            PackList.this.method_25395(this);
            ContextMenuContainer.super.buildItems(builder
                            .add(new PackMenuHeader(this.pack(), this.packWidget.getSprite()))
                            .whenNonNull(this.devMenu)
                            .ifTrue(PackListDevMenu::onBuildHeader)
                            .whenNonNull(this.folderWidget)
                            .ifTrue(b -> b
                                    .simpleItem(FolderPack.FOLDER_OPEN_TEXT, this::openFolder)
                                    .separator()
                            )
                            .whenNonNull(((FilePack) this.pack()).packed_packs$getPath())
                            .ifTrue(b -> b
                                    .simpleItem(RENAME_FILE_TEXT, this::canOperateFile, this::renamePack)
                                    .simpleItem(DELETE_FILE_TEXT, this::canOperateFile, this::deletePack)
                                    .simpleItem(OPEN_FILE_TEXT, () -> PackUtil.openPack(this.pack()))
                                    .simpleItem(OPEN_PARENT_TEXT, () -> PackUtil.openParent(this.pack()))
                            ),
                    mouseX,
                    mouseY
            );
        }

        private void openFolder() {
            PackList.this.openFolder(Objects.requireNonNull(this.folderWidget, "Cannot open folder without folder widget").getMetadata());
        }

        public boolean canOperateFile() {
            return PackList.this.fileOps.isOperable(this.pack());
        }

        public void deletePack() {
            if (PackList.this.fileOps.deletePack(this.pack())) {
                this.stale = true;
                PackList.this.remove(this.pack());
                PackList.this.sendEvent(new FileDeleteEvent(PackList.this));
            } else {
                ToastUtil.onFileFailToast(ToastUtil.getDeleteFailText(this.pack().method_14457().getString()));
            }
        }

        public void renamePack() {
            PackList.this.sendEvent(new FileRenameOpenEvent(PackList.this, this.pack()));
        }

        public void onRename(class_2561 newName) {
            this.stale = true;
            this.packWidget.onRename(newName);
            if (this.folderWidget != null) {
                this.folderWidget.field_22763 = false;
            }
        }

        public boolean isStale() {
            return this.stale;
        }

        @Override
        public @NotNull List<class_364> method_25396() {
            return this.children;
        }

        @Override
        public @NotNull List<class_6379> method_37025() {
            return this.narratables;
        }
    }
}
