package io.github.fishstiz.packed_packs.gui.components.pack;

import com.google.common.collect.ImmutableList;
import io.github.fishstiz.packed_packs.gui.history.Restorable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_8021;
import net.minecraft.class_8030;

import static io.github.fishstiz.packed_packs.util.lang.ObjectsUtil.testNullable;

public interface PackList extends class_4069, class_8021, Restorable<PackList.Snapshot> {
    void add(class_3288 pack);

    void addAll(List<class_3288> packs);

    boolean move(class_3288 pack, int index);

    boolean moveAll(List<class_3288> packs, int index);

    void remove(class_3288 pack);

    void removeAll(List<class_3288> packs);

    void unselect(class_3288 pack);

    void select(class_3288 pack);

    void selectAll(List<class_3288> packs);

    void selectExclusive(class_3288 pack);

    void selectRange(class_3288 pack);

    void clearSelection();

    boolean canDrop(PackList source, ImmutableList<class_3288> payload, class_3288 trigger, double mouseX, double mouseY);

    void drop(PackList source, ImmutableList<class_3288> payload, class_3288 trigger, double mouseX, double mouseY);

    void renderDroppableZone(class_332 guiGraphics, PackList source, ImmutableList<class_3288> payload, class_3288 trigger, int mouseX, int mouseY, float partialTick);

    boolean isLocked();

    boolean isHovered();

    @Nullable Entry getSelected();

    @Nullable Entry getEntry(class_3288 pack);

    default boolean isTransferable(class_3288 pack) {
        return testNullable(this.getEntry(pack), Entry::isTransferable);
    }

    @NotNull ImmutableList<class_3288> copyPacks();

    @NotNull ImmutableList<class_3288> copySelection();

    @NotNull Query copyQuery();

    @Override
    default @NotNull class_8030 method_48202() {
        return class_8021.super.method_48202();
    }

    default @NotNull io.github.fishstiz.packed_packs.gui.components.pack.PackList.Snapshot captureState() {
        return new io.github.fishstiz.packed_packs.gui.components.pack.PackList.Snapshot(this, this.copyPacks(), this.copySelection(), this.copyQuery());
    }

    interface Entry extends class_364 {
        boolean isTransferable();

        class_3288 getPack();
    }

    record Snapshot(
            PackList target,
            ImmutableList<class_3288> packs,
            ImmutableList<class_3288> selection,
            Query query
    ) implements Restorable.Snapshot<io.github.fishstiz.packed_packs.gui.components.pack.PackList.Snapshot> {
        public io.github.fishstiz.packed_packs.gui.components.pack.PackList.Snapshot validate(List<class_3288> validPacks) {
            List<class_3288> validated = new ArrayList<>(this.packs);
            validated.retainAll(validPacks);
            return new io.github.fishstiz.packed_packs.gui.components.pack.PackList.Snapshot(this.target, ImmutableList.copyOf(validated), this.selection, this.query);
        }
    }
}
